/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import oracle.classloader.util.ClassLoadLogger;

public class LogMessageStore {
    private LinkedList messages = new LinkedList();

    public void log(Level level, String key, Object sub0, Object sub1, Object sub2) {
        this.log(level, key, new Object[]{sub0, sub1, sub2});
    }

    public void log(Level level, String key, Object sub0, Object sub1, Object sub2, Object sub3) {
        this.log(level, key, new Object[]{sub0, sub1, sub2, sub3});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, String key, Object[] subs) {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            this.messages.add(new LogMessage(level, key, subs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        LinkedList list;
        if (this.messages.size() == 0) {
            return;
        }
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            list = (LinkedList)this.messages.clone();
            this.messages.clear();
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ((LogMessage)it.next()).writeMessage();
        }
    }

    public int size() {
        return this.messages.size();
    }

    private static class LogMessage {
        private Level level;
        private String key;
        private Object[] subs;

        LogMessage(Level level, String key, Object[] subs) {
            this.level = level;
            this.key = key;
            this.subs = subs;
        }

        void writeMessage() {
            if (ClassLoadLogger.willLog(this.level)) {
                ClassLoadLogger.log(this.level, this.key, this.subs);
            }
        }
    }
}

