/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.classloader.util.ClassLoadLogger;

public abstract class LoadedPackages {
    private static LoadedPackages accessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getPackagesLoadedBy(ClassLoader loader) {
        if (accessor == null) {
            accessor = LoadedPackages.getAccessor();
        }
        try {
            ClassLoader classLoader = loader;
            synchronized (classLoader) {
                return accessor.doGet(loader);
            }
        }
        catch (Throwable e) {
            return Collections.EMPTY_MAP;
        }
    }

    protected abstract Map doGet(ClassLoader var1) throws Exception;

    private static LoadedPackages getAccessor() {
        LoadedPackages result = null;
        try {
            Field packages = ClassLoader.class.getDeclaredField("packages");
            packages.setAccessible(true);
            if (Map.class.isAssignableFrom(packages.getType())) {
                result = new MapAccessor(packages);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null) {
            result = new Empty();
        }
        return result;
    }

    private static class MapAccessor
    extends LoadedPackages {
        private Field field;

        MapAccessor(Field field) {
            this.field = field;
        }

        public Map doGet(ClassLoader loader) throws Exception {
            HashMap map = (HashMap)this.field.get(loader);
            return Collections.unmodifiableMap(map);
        }
    }

    private static class Empty
    extends LoadedPackages {
        private boolean warned;

        private Empty() {
        }

        public Map doGet(ClassLoader loader) {
            if (!this.warned) {
                ClassLoadLogger.log(Level.WARNING, "no.loaded.packages");
                this.warned = true;
            }
            return Collections.EMPTY_MAP;
        }
    }
}

