/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.FindLoadedClass;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.DependentClass;
import oracle.classloader.util.ExecutionStack;
import oracle.classloader.util.LocalizedText;

public class InvalidClass
extends DependentClass {
    private static final String DUPLICATE_ERROR = "uplicate class";
    private static final String VERSION_ERROR = "nsupported major.minor version ";
    private static final String CLASS_VERSION_PROPERTY = "java.class.version";
    private String errorMessage;
    private String invalidClassName;
    private String invalidClassLoaderName;
    private String invalidClassCodeSource;
    private String invalidClassOrigin;

    public InvalidClass(LinkageError error, String invalidClassName, String invalidClassLoaderName, String invalidClassCodeSource, String invalidClassOrigin, ExecutionStack stack) {
        super(null, stack);
        this.errorMessage = error.getMessage();
        this.invalidClassName = invalidClassName;
        this.invalidClassLoaderName = invalidClassLoaderName;
        this.invalidClassCodeSource = invalidClassCodeSource;
        this.invalidClassOrigin = invalidClassOrigin;
    }

    protected String createDescription(LocalizedText localizedText, String dependentClassName, String dependentClassLoaderName, String dependentClassCodeSource, String dependentClassOrigin, String initiatingClassLoaderName) {
        return localizedText.getText("invalid.class", new Object[]{this.errorMessage, this.invalidClassName, this.invalidClassLoaderName, this.invalidClassCodeSource, this.invalidClassOrigin, dependentClassName, dependentClassLoaderName, dependentClassCodeSource, dependentClassOrigin});
    }

    protected String getAnalysis(LocalizedText localizedText, PolicyClassLoader dependentLoader, PolicyClassLoader initiatingLoader) {
        if (this.errorMessage.indexOf(DUPLICATE_ERROR) >= 0) {
            return this.analyzeDuplicateClass(localizedText, dependentLoader);
        }
        if (this.errorMessage.indexOf(VERSION_ERROR) >= 0) {
            return this.analyzeUnsupportedVersion(localizedText);
        }
        return null;
    }

    private String analyzeUnsupportedVersion(LocalizedText localizedText) {
        int[] currentVersion = new int[2];
        String currentVersionStr = InvalidClass.parseClassVersion(ClassLoadEnvironment.getProperty(CLASS_VERSION_PROPERTY), currentVersion);
        int[] foundVersion = new int[2];
        int start = this.errorMessage.indexOf(VERSION_ERROR) + VERSION_ERROR.length();
        String foundVersionStr = InvalidClass.parseClassVersion(this.errorMessage.substring(start), foundVersion);
        boolean foundIsNewer = foundVersion[0] == currentVersion[0] ? foundVersion[1] > currentVersion[1] : foundVersion[0] > currentVersion[0];
        String messageKey = foundIsNewer ? "found.newer.class.version" : "found.older.class.version";
        return localizedText.getText(messageKey, currentVersionStr, foundVersionStr);
    }

    private static String parseClassVersion(String version, int[] result) {
        int end;
        int dot = version.indexOf(46);
        result[0] = Integer.parseInt(version.substring(0, dot));
        int length = version.length();
        for (end = dot + 1; end < length && Character.isDigit(version.charAt(end)); ++end) {
        }
        result[1] = Integer.parseInt(version.substring(dot + 1, end));
        return version.substring(0, end);
    }

    private String analyzeDuplicateClass(LocalizedText localizedText, PolicyClassLoader dependentLoader) {
        String result = null;
        FindLoadedClass visitor = new FindLoadedClass(this.invalidClassName);
        ClassLoaderQuery.visitLoadersInSearchOrder(dependentLoader, visitor);
        Class existingClass = visitor.getLoadedClass();
        if (existingClass != null) {
            String messageKey = null;
            Object[] args = null;
            PolicyClassLoader existingLoader = ClassLoaderQuery.getLoaderFor(existingClass);
            String existingLoaderName = ClassLoaderQuery.getLoaderNameFor(existingClass, existingLoader);
            if (existingLoader != null) {
                if (existingLoader == dependentLoader) {
                    messageKey = "original.class.same.loader";
                    args = new Object[]{existingLoaderName};
                } else if (existingLoader.isSharedLoader()) {
                    messageKey = ClassLoaderQuery.isImportedBy(existingLoader, dependentLoader) ? "original.class.imported" : "original.class.not.imported";
                    args = new Object[]{existingLoaderName, dependentLoader.getUniqueName()};
                }
            }
            if (args == null) {
                messageKey = "original.class";
                String existingCodeSource = ClassLoaderQuery.getCodeSourcePathFor(existingClass, "unknown");
                String existingOrigin = ClassLoaderQuery.getFirstOriginDescriptionFor(existingClass);
                args = new Object[]{existingLoaderName, existingCodeSource, existingOrigin};
            }
            result = localizedText.getText(messageKey, args);
        }
        return result;
    }
}

