/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadLogger;

public class GarbageCollection {
    private static final Logger LOG = ClassLoadLogger.getLogger();
    private static final Field PENDING = GarbageCollection.getPendingField();
    private static final Object PENDING_LOCK = GarbageCollection.getPendingLock();
    private static String HEAP_DUMP_FILE_NAME = "heapdump";
    private static String HEAP_DUMP_FILE_NAME_EXTENSION = ".bin";

    private static Field getPendingField() {
        Field result = null;
        try {
            result = Reference.class.getDeclaredField("pending");
            result.setAccessible(true);
        }
        catch (Throwable t) {
            GarbageCollection.log(Level.WARNING, "Unable to access pending References.");
        }
        return result;
    }

    private static Object getPendingLock() {
        Object result = null;
        try {
            Field field = Reference.class.getDeclaredField("lock");
            field.setAccessible(true);
            result = field.get(null);
        }
        catch (Throwable t) {
            GarbageCollection.log(Level.WARNING, "Unable to access pending Reference lock.");
        }
        return result;
    }

    public static boolean dumpHeap(File dumpFile, boolean liveObjectsOnly) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
            Object[] parameters = new Object[]{dumpFile.getAbsolutePath(), liveObjectsOnly};
            String[] signatures = new String[]{"java.lang.String", "boolean"};
            server.invoke(name, "dumpHeap", parameters, signatures);
        }
        catch (Throwable t) {
            GarbageCollection.log(Level.WARNING, "Unable to dump heap: " + t);
            return false;
        }
        return true;
    }

    public static File getHeapDumpFile() {
        String rootDirPath = System.getenv("T_WORK");
        if (rootDirPath == null) {
            String logFile = System.getProperty("oracle.process.log");
            rootDirPath = logFile != null ? new File(logFile).getParent() : System.getProperty("user.dir");
        }
        File rootDir = new File(rootDirPath);
        String baseName = HEAP_DUMP_FILE_NAME;
        String ext = HEAP_DUMP_FILE_NAME_EXTENSION;
        File result = new File(rootDir, baseName + ext);
        int index = 1;
        while (result.exists()) {
            result = new File(rootDir, baseName + index + ext);
            ++index;
        }
        return result;
    }

    public static void log(Goal goal, String message) {
        GarbageCollection.log(goal.getLogLevel(), message);
    }

    public static void log(Level level, String message) {
        if (LOG.isLoggable(level)) {
            LOG.log(level, "GC: " + message);
        }
    }

    public static synchronized boolean forceCollection(Goal goal) {
        boolean goalReached = goal.reached();
        if (!(goalReached || (goalReached = GarbageCollection.systemGC(goal)) || (goalReached = GarbageCollection.forceOldGenerationGC(goal)) || (goalReached = GarbageCollection.forcePermanentGenerationGC(goal)))) {
            GarbageCollection.sleep(goal, "Waiting for thread completion", 500L);
            goalReached = GarbageCollection.systemGC(goal);
        }
        return goalReached;
    }

    private static boolean forcePermanentGenerationGC(Goal goal) {
        boolean goalReached = goal.reached();
        if (!goalReached && BigClassLoader.isValid()) {
            GarbageCollection.log(goal, "Begin permgen collection");
            ArrayList<Class> classCache = new ArrayList<Class>();
            OutOfMemoryError error = null;
            int cacheSize = 0;
            try {
                while (classCache != null) {
                    classCache.add(BigClassLoader.defineClass());
                    ++cacheSize;
                }
            }
            catch (OutOfMemoryError e) {
                error = e;
            }
            classCache = null;
            try {
                GarbageCollection.log(goal, "Loading final large class...");
                BigClassLoader.defineClass();
                GarbageCollection.log(goal, "Loaded final large class...");
            }
            catch (OutOfMemoryError e) {
                error = e;
            }
            goalReached = GarbageCollection.systemGC(goal);
            GarbageCollection.log(goal, "Got expected " + error + ", count " + cacheSize);
            GarbageCollection.log(goal, "Finished permgen collection; goalReached=" + goalReached);
        }
        return goalReached;
    }

    private static boolean forceOldGenerationGC(Goal goal) {
        boolean goalReached = goal.reached();
        if (!goalReached) {
            Object memory;
            GarbageCollection.log(goal, "Begin oldgen collection");
            OutOfMemoryError error = null;
            Runtime rt = Runtime.getRuntime();
            int allocSize = 0;
            try {
                memory = new byte[16384][];
                while (memory != null) {
                    for (int i = 0; i < ((byte[][])memory).length; ++i) {
                        if (i == 0) {
                            allocSize = (int)rt.freeMemory();
                        } else if (i == 1) {
                            allocSize = (int)rt.totalMemory();
                        } else if (i == 2) {
                            allocSize = (int)rt.maxMemory();
                        } else if (i == 3) {
                            allocSize = Integer.MAX_VALUE;
                        }
                        memory[i] = new byte[allocSize];
                    }
                }
            }
            catch (OutOfMemoryError e) {
                error = e;
            }
            memory = null;
            goalReached = goal.reached();
            if (!goalReached) {
                for (int i = 0; i < 3 && !(goalReached = GarbageCollection.systemGC(goal)); ++i) {
                }
            }
            GarbageCollection.log(goal, "Got expected " + error);
            GarbageCollection.log(goal, "Finished oldgen collection; goalReached=" + goalReached);
        }
        return goalReached;
    }

    private static boolean systemGC(Goal goal) {
        boolean goalReached = goal.reached();
        if (!goalReached) {
            System.gc();
            GarbageCollection.sleep(goal, null, 100L);
            System.runFinalization();
            System.gc();
            System.gc();
            GarbageCollection.waitForPendingReferences(goal);
            goalReached = goal.reached();
            GarbageCollection.log(goal, "Finished system GC calls; goalReached=" + goalReached);
        }
        return goalReached;
    }

    private static void sleep(Goal goal, String message, long millis) {
        if (message != null) {
            GarbageCollection.log(goal, message);
        }
        try {
            GarbageCollection.class.wait(millis);
        }
        catch (InterruptedException i) {
            GarbageCollection.log(goal, (message != null ? message : "") + " (sleep interrupted!)");
        }
    }

    private static void waitForPendingReferences(Goal goal) {
        if (PENDING != null && PENDING_LOCK != null) {
            while (GarbageCollection.hasPendingReferences(goal)) {
                GarbageCollection.sleep(goal, "Waiting for pending References to be enqueued", 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasPendingReferences(Goal goal) {
        boolean hasPending = false;
        try {
            Object object = PENDING_LOCK;
            synchronized (object) {
                hasPending = PENDING.get(null) != null;
            }
        }
        catch (Throwable t) {
            GarbageCollection.log(goal, "Unable to wait for pending References: " + t);
        }
        return hasPending;
    }

    private static class BigClassLoader
    extends ClassLoader {
        private static final String BIG_CLASS_NAME = "com.sun.corba.se.impl.logging.ORBUtilSystemException";
        private static byte[] data;

        private BigClassLoader() {
        }

        private static void init() {
            try {
                String resource = BIG_CLASS_NAME.replace('.', '/').concat(".class");
                InputStream in = BigClassLoader.class.getClassLoader().getResourceAsStream(resource);
                data = ArrayUtils.read(in);
            }
            catch (Throwable t) {
                data = new byte[0];
                ClassLoadLogger.getLogger().log(Level.WARNING, "Caught", t);
            }
        }

        public static boolean isValid() {
            if (data == null) {
                BigClassLoader.init();
            }
            return data.length > 0;
        }

        public static Class defineClass() {
            return new BigClassLoader().defineIt();
        }

        private Class defineIt() {
            if (BigClassLoader.isValid()) {
                return this.defineClass(BIG_CLASS_NAME, data, 0, data.length);
            }
            return null;
        }
    }

    public static interface Goal {
        public boolean reached();

        public Level getLogLevel();
    }
}

