/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SearchSequence;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;

public class ExecutionStack {
    public static int SUN_ID = 0;
    public static int BEA_ID = 1;
    public static int IBM_ID = 2;
    public static int ORACLE_ID = 3;
    public static int UNKNOWN_ID = -1;
    public static int VM_VENDOR_ID = ExecutionStack.getVMVendorID();
    private static final String LOAD_CLASS_METHOD = "loadClass";
    private static final String VM_LOAD_CLASS_METHOD = ClassLoadEnvironment.getDependencyResolutionMethodName();
    private static final String CLASS_FOR_NAME_METHOD = "forName";
    private static final boolean DEBUG_FIX_CLASS_ARRAY = "true".equals(ClassLoadEnvironment.getProperty("debug.fix.class.array"));
    private static final Class UNKNOWN = Unknown.class;
    private static final String CLASS_LOADER_NAME = ClassLoader.class.getName();
    private static final String POLICY_CLASS_LOADER_NAME = PolicyClassLoader.class.getName();
    private static final String CLASS_NAME = Class.class.getName();
    private static final String URL_LOADER_NAME = URLClassLoader.class.getName();
    private static final String[] JROCKIT_CLASS_NAMES = new String[]{"jrockit.vm.Classes", "jrockit.vm.RNI", "jrockit.vm.AccessController", "jrockit.vm.ExceptionHandler"};
    private static final Collection LOADER_RELATED_CLASS_NAMES = ExecutionStack.getLoaderClassNames();
    private static final OurManager sm = new OurManager();
    private static final int START_INDEX = 2;
    private int frameZeroIndex;
    private Class[] classes;
    private StackTraceElement[] elements;
    private Class callerClass;
    private int vmLoadClassMethodIndex;
    private int loadClassIndexFromCustomLoader;
    private int loadClassIndexFromJavaLangClassLoader;
    private int classForNameIndex;
    private int callerClassIndex;
    public static final int ACCESS_CONTROLLER_COUNT = ExecutionStack.getAccessControllerCount();

    private static int getVMVendorID() {
        int result = UNKNOWN_ID;
        String vendor = ClassLoadEnvironment.getProperty("java.vm.vendor");
        if (vendor.indexOf("Sun") >= 0) {
            result = SUN_ID;
        } else if (vendor.indexOf("BEA") >= 0) {
            result = BEA_ID;
        } else if (vendor.indexOf("IBM") >= 0) {
            result = IBM_ID;
        } else if (vendor.indexOf("Oracle") >= 0) {
            result = ORACLE_ID;
        }
        return result;
    }

    private static Collection getLoaderClassNames() {
        int i;
        Collection list = ExecutionStack.createClassNameCollection();
        for (Class loaderClass = PolicyClassLoader.class; loaderClass != Object.class; loaderClass = loaderClass.getSuperclass()) {
            list.add(loaderClass.getName());
        }
        list.add(Class.class.getName());
        list.add(SearchSequence.class.getName());
        list.add(SearchPolicy.class.getName());
        Class<?>[] loaderClasses = PolicyClassLoader.class.getDeclaredClasses();
        for (int i2 = 0; i2 < loaderClasses.length; ++i2) {
            Class<?> aClass = loaderClasses[i2];
            if (aClass.getName().indexOf("LoadClassAction") < 0) continue;
            list.add(aClass.getName());
            break;
        }
        Class<?>[] policyClasses = SearchPolicy.class.getDeclaredClasses();
        for (i = 0; i < policyClasses.length; ++i) {
            list.add(policyClasses[i].getName());
        }
        if (VM_VENDOR_ID == BEA_ID) {
            for (i = 0; i < JROCKIT_CLASS_NAMES.length; ++i) {
                try {
                    list.add(Class.forName(JROCKIT_CLASS_NAMES[i]).getName());
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    private static Collection createClassNameCollection() {
        if (VM_VENDOR_ID == BEA_ID) {
            return new ArrayList();
        }
        return new HashSet();
    }

    private static boolean isLoaderRelatedClass(String className) {
        if (LOADER_RELATED_CLASS_NAMES.contains(className)) {
            return true;
        }
        return className.startsWith(URL_LOADER_NAME);
    }

    public ExecutionStack() {
        this.frameZeroIndex = 2;
        this.classes = sm.getCallers();
        this.elements = sm.getTrace();
    }

    public ExecutionStack(int frameZeroIndex) {
        this.frameZeroIndex = frameZeroIndex + 2;
        this.classes = sm.getCallers();
        this.elements = sm.getTrace();
    }

    public int getFrameCount() {
        int length = this.classes.length;
        if (this.elements.length < length) {
            length = this.elements.length;
        }
        return length - this.frameZeroIndex;
    }

    public Class getClassInstance(int frameIndex) {
        if (this.classes.length < this.elements.length) {
            this.fixClassArray();
        }
        return this.classes[frameIndex + this.frameZeroIndex];
    }

    public SharedCodeSource getCodeSource(int frameIndex) {
        return ClassLoaderQuery.getCodeSourceFor(this.getClassInstance(frameIndex));
    }

    public URL getCodeSourceLocation(int frameIndex) {
        return ClassLoaderQuery.getCodeSourceLocationFor(this.getClassInstance(frameIndex));
    }

    public String getCodeSourceDescription(int frameIndex) {
        return ClassLoaderQuery.getCodeSourceDescriptionFor(this.getClassInstance(frameIndex));
    }

    public PolicyClassLoader getClassLoader(int frameIndex) {
        return ClassLoaderQuery.getLoaderFor(this.getClassInstance(frameIndex));
    }

    public String getClassLoaderName(int frameIndex) {
        return ClassLoaderQuery.getLoaderNameFor(this.getClassInstance(frameIndex));
    }

    public String getFileName(int frameIndex) {
        return this.elements[frameIndex + this.frameZeroIndex].getFileName();
    }

    public int getLineNumber(int frameIndex) {
        return this.elements[frameIndex + this.frameZeroIndex].getLineNumber();
    }

    public String getClassName(int frameIndex) {
        return this.elements[frameIndex + this.frameZeroIndex].getClassName();
    }

    public String getMethodName(int frameIndex) {
        return this.elements[frameIndex + this.frameZeroIndex].getMethodName();
    }

    public boolean isNativeMethod(int frameIndex) {
        return this.elements[frameIndex + this.frameZeroIndex].isNativeMethod();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.appendStackTrace(buf);
        return buf.toString();
    }

    public void appendStackTrace(StringBuffer buffer) {
        int i;
        int count = this.getFrameCount();
        for (i = 0; i < count; ++i) {
            buffer.append("\tat ");
            this.append(i, buffer);
            buffer.append(ClassLoadLogger.EOL);
        }
        if (this.elements.length < this.classes.length) {
            for (i = count + 2; i < this.classes.length; ++i) {
                buffer.append("\tat ");
                buffer.append(this.classes[i].getName());
                buffer.append(" (method and line unknown).");
                buffer.append(ClassLoadLogger.EOL);
            }
        }
    }

    private void append(int frameIndex, StringBuffer buffer) {
        buffer.append(this.getClassName(frameIndex));
        buffer.append('.');
        buffer.append(this.getMethodName(frameIndex));
        buffer.append(" (");
        if (this.isNativeMethod(frameIndex)) {
            buffer.append("Native method");
        } else {
            String fileName = this.getFileName(frameIndex);
            if (fileName != null) {
                buffer.append(fileName);
                int lineNo = this.getLineNumber(frameIndex);
                if (lineNo >= 0) {
                    buffer.append(':');
                    buffer.append(lineNo);
                }
            } else {
                buffer.append("Unknown source file");
            }
        }
        buffer.append(") [");
        buffer.append(this.getCodeSourceDescription(frameIndex));
        buffer.append(", by ");
        buffer.append(this.getClassLoaderName(frameIndex));
        buffer.append(']');
    }

    public int indexOfMethod(String className, String methodName) {
        return this.indexOfMethod(className, methodName, 0);
    }

    public int indexOfMethod(String className, String methodName, int startIndex) {
        int count = this.classes.length - this.frameZeroIndex;
        for (int i = this.frameZeroIndex + startIndex; i < count; ++i) {
            if (!this.elements[i].getClassName().equals(className) || !this.elements[i].getMethodName().equals(methodName)) continue;
            return i - this.frameZeroIndex;
        }
        return -1;
    }

    public Class getCallerClass() {
        if (this.callerClass == null) {
            this.vmLoadClassMethodIndex = -1;
            this.loadClassIndexFromJavaLangClassLoader = -1;
            this.classForNameIndex = -1;
            this.callerClassIndex = -1;
            int count = this.elements.length;
            for (int i = this.frameZeroIndex; i < count; ++i) {
                String className = this.elements[i].getClassName();
                if (ExecutionStack.isLoaderRelatedClass(className)) {
                    String methodName = this.elements[i].getMethodName();
                    if (className.equals(CLASS_LOADER_NAME)) {
                        if (methodName.equals(LOAD_CLASS_METHOD)) {
                            this.loadClassIndexFromJavaLangClassLoader = i;
                            this.loadClassIndexFromCustomLoader = i;
                            continue;
                        }
                        if (this.vmLoadClassMethodIndex >= 0 || !methodName.equals(VM_LOAD_CLASS_METHOD)) continue;
                        this.vmLoadClassMethodIndex = i;
                        continue;
                    }
                    if (className.equals(CLASS_NAME)) {
                        if (!methodName.equals(CLASS_FOR_NAME_METHOD)) continue;
                        this.classForNameIndex = i;
                        continue;
                    }
                    if (!className.equals(POLICY_CLASS_LOADER_NAME) || !methodName.equals(LOAD_CLASS_METHOD)) continue;
                    this.loadClassIndexFromCustomLoader = i;
                    continue;
                }
                Class theClass = this.getClassInstance(i - this.frameZeroIndex);
                if (theClass == null) continue;
                if (!ClassLoader.class.isAssignableFrom(theClass)) {
                    this.callerClass = theClass;
                    this.callerClassIndex = i;
                    break;
                }
                if (!this.elements[i].getMethodName().equals(LOAD_CLASS_METHOD)) continue;
                this.loadClassIndexFromCustomLoader = i;
            }
            if (this.callerClass == null) {
                this.callerClass = UNKNOWN;
            }
        }
        return this.callerClass;
    }

    public boolean didCallerInvokeClassForName() {
        if (this.callerClass == null) {
            this.getCallerClass();
        }
        return this.callerClassIndex == this.classForNameIndex + 1;
    }

    public boolean didCallerInvokeLoadClass() {
        if (this.callerClass == null) {
            this.getCallerClass();
        }
        return this.callerClassIndex == this.loadClassIndexFromCustomLoader + 1;
    }

    boolean mustThrowClassNotFound() {
        if (this.callerClass == null) {
            this.getCallerClass();
        }
        if (this.callerClass == UNKNOWN) {
            return true;
        }
        if (this.classForNameIndex < 0 && this.vmLoadClassMethodIndex >= 0) {
            return this.loadClassIndexFromJavaLangClassLoader > 0;
        }
        return true;
    }

    private void fixClassArray() {
        int elementsLength = this.elements.length;
        Class[] newClasses = new Class[elementsLength];
        int classIndex = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            StackTraceElement element = this.elements[i];
            if (element.isNativeMethod()) {
                newClasses[i] = null;
                continue;
            }
            String className = this.elements[i].getClassName();
            if (className.startsWith("java.lang.reflect.") || className.startsWith("sun.reflect.")) {
                newClasses[i] = null;
                continue;
            }
            if (classIndex == this.classes.length) {
                if (!DEBUG_FIX_CLASS_ARRAY) continue;
                System.out.println("Missing Class[" + i + "] for " + element + ". classIndex: " + classIndex);
                continue;
            }
            newClasses[i] = this.classes[classIndex++];
        }
        this.classes = newClasses;
    }

    public static Class[] getCallers() {
        return sm.getCallers();
    }

    private static int getAccessControllerCount() {
        int result = 0;
        Class[] stack = (Class[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return sm.getCallers();
            }
        });
        for (int i = 2; i < stack.length && stack[i] != ExecutionStack.class; ++i) {
            ++result;
        }
        return result;
    }

    private static class OurManager
    extends SecurityManager {
        private OurManager() {
        }

        public Class[] getCallers() {
            return this.getClassContext();
        }

        public StackTraceElement[] getTrace() {
            return new Error().getStackTrace();
        }
    }

    private static class Unknown {
        private Unknown() {
        }
    }
}

