/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchMetrics;
import oracle.classloader.SearchPolicy;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassPreprocessor;
import oracle.classloader.util.ClassPreprocessorSequence;
import oracle.classloader.util.PropertyUtils;

public abstract class ClassPreprocessorFactory {
    public static String SYSTEM_PROPERTY_NAME = ClassLoadEnvironment.getSystemClassPreprocessorKey();
    private static final boolean shouldCreate = ClassLoadEnvironment.allowClassPreprocessing();
    private static boolean systemInitialized;
    private static Class[] systemProcessorClasses;
    private static boolean applicationInitialized;
    private static Class[] applicationProcessorClasses;
    private static SearchMetrics metrics;

    public static synchronized ClassPreprocessor create(PolicyClassLoader loader, ClassPreprocessor userDefined) {
        if (shouldCreate) {
            try {
                Class[] processorClasses = ClassPreprocessorFactory.getProcessorClasses(loader);
                return ClassPreprocessorFactory.createInstanceFor(processorClasses, loader, userDefined);
            }
            catch (Exception e) {
                ClassLoadLogger.logException("Could not create preprocessor.", e, false);
            }
        }
        return null;
    }

    public static void setSystemInitialized(boolean initialized) {
        systemInitialized = initialized;
    }

    public static void reset() {
        systemInitialized = false;
        applicationInitialized = false;
        systemProcessorClasses = null;
        applicationProcessorClasses = null;
        metrics = SearchMetrics.getInstance("ClassPreprocessorFactory");
    }

    private static Class[] getProcessorClasses(PolicyClassLoader loader) throws Exception {
        if (loader.isApplicationLoader()) {
            if (!applicationInitialized) {
                applicationProcessorClasses = ClassPreprocessorFactory.getClassesFromProperty(ClassPreprocessor.PROPERTY_NAME, loader);
                applicationInitialized = true;
            }
            if (applicationProcessorClasses == null) {
                return systemProcessorClasses;
            }
            return applicationProcessorClasses;
        }
        if (!systemInitialized && loader.getName().equals(ClassLoadEnvironment.getMainLoaderName())) {
            systemProcessorClasses = ClassPreprocessorFactory.getClassesFromProperty(SYSTEM_PROPERTY_NAME, loader);
            systemInitialized = true;
        }
        return systemProcessorClasses;
    }

    private static ClassPreprocessor createInstanceFor(Class[] processorClasses, PolicyClassLoader loader, ClassPreprocessor userDefined) throws Exception {
        ClassPreprocessor result = userDefined;
        if (processorClasses != null) {
            int systemPrecount = processorClasses.length;
            Object[] list = new ClassPreprocessor[systemPrecount];
            for (int i = 0; i < systemPrecount; ++i) {
                list[i] = (ClassPreprocessor)processorClasses[i].newInstance();
            }
            if (userDefined != null) {
                list = (ClassPreprocessor[])ArrayUtils.append(ClassPreprocessor.class, list, systemPrecount++, userDefined);
            }
            result = new ClassPreprocessorSequence((ClassPreprocessor[])list, systemPrecount);
            return result.initialize(loader);
        }
        if (result != null) {
            return result.initialize(loader);
        }
        return null;
    }

    private static Class[] getClassesFromProperty(String propertyName, PolicyClassLoader loader) throws ClassNotFoundException, IOException {
        Class[] result = null;
        String value = ClassPreprocessorFactory.getProperty(propertyName, loader);
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, ";:");
            int count = st.countTokens();
            result = new Class[count];
            int index = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                result[index++] = loader.loadClass(token);
            }
        }
        return result;
    }

    private static String getProperty(String propertyName, PolicyClassLoader loader) throws IOException {
        String resourceName;
        URL res;
        String result = null;
        if (propertyName != null && (result = ClassLoadEnvironment.getProperty(propertyName)) == null && (res = SearchPolicy.FIND_LOCAL.findResource(resourceName = PropertyUtils.getServiceResourcePath(propertyName), loader, metrics, false)) != null) {
            InputStream is = res.openStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            result = rd.readLine();
            rd.close();
        }
        return result;
    }

    static {
        metrics = SearchMetrics.getInstance("ClassPreprocessorFactory");
    }
}

