/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClassDependencies {
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;

    public static List getDependencies(String className, ClassLoader loader, boolean recurse, String[] ignorePackages) throws IOException {
        if (recurse) {
            HashSet<String> checked = new HashSet<String>();
            checked.add(className);
            ClassDependencies.recursiveAddDependencies(className, loader, ignorePackages, checked);
            checked.remove(className);
            return new ArrayList(checked);
        }
        return ClassDependencies.getDependencies(className, loader);
    }

    private static void recursiveAddDependencies(String className, ClassLoader loader, String[] ignorePackages, Set checked) throws IOException {
        String resourceName = className.replace('.', '/') + ".class";
        InputStream is = loader.getResourceAsStream(resourceName);
        if (is != null) {
            List deps = ClassDependencies.getDependencies(is);
            Iterator iterator = deps.iterator();
            while (iterator.hasNext()) {
                String dependentClassName = ((String)iterator.next()).replace('/', '.');
                if (!ClassDependencies.shouldRecurse(dependentClassName, checked, ignorePackages)) continue;
                ClassDependencies.recursiveAddDependencies(dependentClassName, loader, ignorePackages, checked);
            }
        }
    }

    private static boolean shouldRecurse(String className, Set checked, String[] ignorePackages) {
        if (checked.contains(className)) {
            return false;
        }
        checked.add(className);
        if (ignorePackages != null) {
            for (int i = 0; i < ignorePackages.length; ++i) {
                if (!className.startsWith(ignorePackages[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static List getDependencies(String className, ClassLoader loader) throws IOException {
        String resourceName = className.replace('.', '/') + ".class";
        InputStream is = loader.getResourceAsStream(resourceName);
        if (is != null) {
            return ClassDependencies.getDependencies(is);
        }
        return Collections.EMPTY_LIST;
    }

    public static List getDependencies(Class clz) throws IOException {
        InputStream is = null;
        String resourceName = clz.getName().replace('.', '/') + ".class";
        ClassLoader loader = clz.getClassLoader();
        is = loader == null ? ClassLoader.getSystemResourceAsStream(resourceName) : loader.getResourceAsStream(resourceName);
        return ClassDependencies.getDependencies(new DataInputStream(is));
    }

    public static List getDependencies(InputStream in) throws IOException {
        return ClassDependencies.getDependencies(new DataInputStream(in));
    }

    public static List getDependencies(DataInputStream in) throws IOException {
        Collector c = new Collector();
        ClassDependencies.visitDependencies(in, c);
        return c.list;
    }

    private ClassDependencies() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitDependencies(DataInputStream in, Visitor visitor) throws IOException {
        try {
            if (in.readInt() != -889275714) {
                throw new IllegalStateException("NOT A CLASS FILE");
            }
            in.readUnsignedShort();
            in.readUnsignedShort();
            int pool_count = in.readUnsignedShort();
            Object[] cp = new Object[pool_count];
            ArrayList<Integer> classRefs = new ArrayList<Integer>(pool_count / 4);
            block12: for (int i = 1; i < pool_count; ++i) {
                switch (in.readUnsignedByte()) {
                    case 1: {
                        cp[i] = in.readUTF();
                        continue block12;
                    }
                    case 3: 
                    case 4: {
                        in.readInt();
                        continue block12;
                    }
                    case 5: 
                    case 6: {
                        in.readInt();
                        in.readInt();
                        ++i;
                        continue block12;
                    }
                    case 7: {
                        Integer idx = new Integer(in.readUnsignedShort());
                        cp[i] = idx;
                        classRefs.add(idx);
                        continue block12;
                    }
                    case 8: {
                        in.readUnsignedShort();
                        continue block12;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        in.readUnsignedShort();
                        in.readUnsignedShort();
                        continue block12;
                    }
                    case 12: {
                        in.readUnsignedShort();
                        in.readUnsignedShort();
                        continue block12;
                    }
                }
            }
            in.readUnsignedShort();
            int thisClassIdx = (Integer)cp[in.readUnsignedShort()];
            Iterator it = classRefs.iterator();
            while (it.hasNext()) {
                String className;
                int idx = (Integer)it.next();
                if (idx == thisClassIdx || (className = (String)cp[idx]).startsWith("[") || visitor.visitDependency(className.replace('/', '.'))) continue;
                break;
            }
        }
        finally {
            in.close();
        }
    }

    private static class Collector
    implements Visitor {
        List list = new ArrayList();

        private Collector() {
        }

        public boolean visitDependency(String dependentClassName) {
            this.list.add(dependentClassName);
            return true;
        }
    }

    public static interface Visitor {
        public boolean visitDependency(String var1);
    }
}

