/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import oracle.classloader.util.AnnotatedNoClassDefFoundError;
import oracle.classloader.util.AnnotatedThrowable;
import oracle.classloader.util.MissingClass;

public class AnnotationUtils {
    public static Throwable mapError(Throwable error) {
        String missingClassName;
        MissingClass missingClass;
        String message;
        if (!(error instanceof AnnotatedNoClassDefFoundError) && (message = error.getMessage()) != null && (missingClass = MissingClass.remove(missingClassName = message.replace('/', '.'))) != null) {
            return new AnnotatedNoClassDefFoundError(missingClass);
        }
        return error;
    }

    public static String getMessageFor(Throwable error) {
        String result = error.getMessage();
        if (!AnnotatedThrowable.class.isAssignableFrom(error.getClass()) && error instanceof NoClassDefFoundError) {
            result = AnnotationUtils.getMessageForUnresolvedDependency((NoClassDefFoundError)error);
        }
        return result;
    }

    public static String getMessageForUnresolvedDependency(NoClassDefFoundError error) {
        String missingClassName = error.getMessage().replace('/', '.');
        MissingClass missingClass = MissingClass.remove(missingClassName);
        if (missingClass != null) {
            return missingClass.getDescription();
        }
        return error.getMessage();
    }
}

