/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.tools;

import java.io.File;
import oracle.classloader.tools.ManifestState;

public abstract class ManifestFormatter {
    public static final String EOL = System.getProperty("line.separator");
    public static final String ORACLE_HOME = ManifestFormatter.getOracleHome();
    private static final String ORACLE_HOME_VAR = "${oracle.home}";
    protected static final String FORMAT_OPTION = "-tree";
    protected static final String OPTIONS = "[-a(bsolutePaths)]";
    protected static final String INDENT = "    ";
    protected StringBuilder builder = new StringBuilder();
    private boolean absolutePaths;

    private static String getOracleHome() {
        String result = System.getProperty("oracle.home");
        if (result == null) {
            try {
                File j2eeDir;
                File homeDir;
                String pclPath = ManifestFormatter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                File file = new File(pclPath);
                if (file.exists() && (homeDir = file.getParentFile()).getName().equals("home") && (j2eeDir = homeDir.getParentFile()).getName().equals("j2ee")) {
                    result = j2eeDir.getParentFile().getName();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    protected ManifestFormatter() {
    }

    public String format(File[] jars, int maxDepth) {
        for (int i = 0; i < jars.length; ++i) {
            File jar = jars[i];
            ManifestState manifest = new ManifestState(jar, maxDepth);
            this.append(manifest, i, jars.length - 1);
        }
        return this.builder.toString();
    }

    public String formatOption() {
        return FORMAT_OPTION;
    }

    public String options() {
        return OPTIONS;
    }

    protected boolean checkArgument(String argument) {
        if (argument.startsWith("-a")) {
            this.absolutePaths = true;
            return true;
        }
        return false;
    }

    protected abstract void append(ManifestState var1, int var2, int var3);

    public String toString() {
        return this.builder.toString();
    }

    protected void appendJarPath(ManifestState manifest) {
        this.appendJarPath(manifest, this.absolutePaths);
    }

    protected void appendJarPath(ManifestState manifest, boolean absolutePath) {
        if (absolutePath) {
            this.appendPath(manifest.getAbsoluteJarPath());
        } else {
            this.append(manifest.getRelativeJarPath());
        }
        if (manifest.getFailure() != null) {
            this.append(" (Error " + manifest.getFailure() + ")");
        } else if (!manifest.doesExist()) {
            this.append(" (Not Found)");
        } else if (manifest.isDuplicate()) {
            this.append(" (Duplicate)");
        } else if (manifest.getManifest() == null) {
            this.append(" (No Manifest)");
        }
    }

    protected void appendPath(String path) {
        if (ORACLE_HOME != null && path.startsWith(ORACLE_HOME)) {
            this.builder.append(ORACLE_HOME_VAR);
            this.builder.append(path.substring(ORACLE_HOME.length()));
        } else {
            this.builder.append(path);
        }
    }

    protected void append(Object obj) {
        this.builder.append(obj);
    }

    protected void appendln(Object obj) {
        this.builder.append(obj);
        this.builder.append(EOL);
    }

    protected void append(String msg) {
        this.builder.append(msg);
    }

    protected void appendln(String msg) {
        this.builder.append(msg);
        this.builder.append(EOL);
    }

    protected void appendln() {
        this.builder.append(EOL);
    }
}

