/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.Arrays;
import java.util.Properties;
import oracle.classloader.query.ReportQuery;
import oracle.classloader.util.ClassLoadEnvironment;

public class SystemProperties
extends ReportQuery {
    public String getDescription() {
        return "List or set System properties." + EOL + EOL + "Args: [<key>=<value>]" + EOL + EOL + "Lists the current values if no key=value pairs are specified.";
    }

    public void createQueryReport(String[] args) throws Exception {
        if (args.length == 0) {
            this.appendProperties();
        } else {
            for (int i = 0; i < args.length; ++i) {
                this.setProperty(args[i]);
            }
        }
    }

    private void setProperty(String pair) {
        int index = pair.indexOf(61);
        if (index <= 0) {
            this.appendln("Invalid argument: " + pair);
        } else {
            String key = pair.substring(0, index);
            String value = pair.substring(index + 1);
            Object oldValue = ClassLoadEnvironment.setProperty(key, value);
            this.append("System property '");
            this.append(key);
            this.append("' set to '");
            this.append(ClassLoadEnvironment.getProperty(key));
            this.append("'");
            if (oldValue != null) {
                this.append(" (original value: '");
                this.append(oldValue);
                this.append("')");
            }
            this.appendln();
        }
    }

    private void appendProperties() {
        Properties props = System.getProperties();
        Object[] keys = props.keySet().toArray();
        Arrays.sort(keys);
        this.appendln("System properties: ");
        this.appendln();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object value = props.get(key);
            this.indentLineNumber(i + 1);
            this.append(key);
            this.append(" = ");
            this.appendln(value);
        }
        this.appendln();
    }
}

