/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;

public class ListQueries
extends ClassLoaderQuery {
    private static List QUERY_CLASS_NAMES;
    private static Map QUERY_DESCRIPTIONS;
    private boolean summary = true;
    private List classNames = new ArrayList();
    private int maxKeyLength;
    private static final String SUFFIX = "Specify the query name for a full description, or use the '-l' option to see full descriptions for all.";

    public String getDescription() {
        return "List built-in subclasses of the \"oracle.classloader.query.Query\" class.\n\nArgs: [-l] [queryclass]... \n\nList each query with a single line description. Use the -l option for full descriptions. Pass one or more query class name to list only those queries.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.parseArgs(args);
        Map descriptions = this.classNames.isEmpty() ? ListQueries.getQueryClassDescriptions() : ClassLoadEnvironment.getQueryDescriptions(this.classNames);
        ArrayList keys = new ArrayList(descriptions.keySet());
        if (this.summary) {
            for (String key : keys) {
                int length = key.length();
                if (length <= this.maxKeyLength) continue;
                this.maxKeyLength = length;
            }
        }
        this.appendln();
        Collections.sort(keys);
        for (String key : keys) {
            String value = (String)descriptions.get(key);
            if (this.summary) {
                int eol = value.indexOf(10);
                if (eol < 0) {
                    eol = value.length();
                }
                value = value.substring(0, eol);
                this.append(key);
                int padding = this.maxKeyLength - key.length();
                for (int j = 0; j < padding; ++j) {
                    this.append(' ');
                }
                this.append(" - ");
                this.appendln(value);
                continue;
            }
            this.appendln();
            this.appendln(key);
            this.appendln();
            this.appendWrapped("", 4, 80, value);
            this.appendln();
        }
        if (keys.size() > 1) {
            this.appendln();
            this.appendln(SUFFIX);
        }
    }

    public static synchronized List getQueryClassNames() {
        if (QUERY_CLASS_NAMES == null) {
            ArrayList names = new ArrayList();
            try {
                ListQueries.addQueryClassNames(names);
            }
            catch (Exception e) {
                ClassLoadLogger.logException("Failed to init query class names.", e, true);
            }
            QUERY_DESCRIPTIONS = ClassLoadEnvironment.getQueryDescriptions(names);
            QUERY_CLASS_NAMES = new ArrayList(QUERY_DESCRIPTIONS.keySet());
            Collections.sort(QUERY_CLASS_NAMES);
        }
        return QUERY_CLASS_NAMES;
    }

    public static synchronized Map getQueryClassDescriptions() {
        if (QUERY_DESCRIPTIONS == null) {
            ListQueries.getQueryClassNames();
        }
        return QUERY_DESCRIPTIONS;
    }

    private static void addQueryClassNames(List classNames) throws Exception {
        ArrayList codeSources = new ArrayList();
        ClassLoadEnvironment.addQueryCodeSources(codeSources);
        String[] packageNames = ClassLoadEnvironment.getDefaultQueryPackageNames();
        String[] packagePrefixes = new String[packageNames.length];
        for (int i = 0; i < packageNames.length; ++i) {
            packagePrefixes[i] = packageNames[i].replace('.', '/') + "/";
        }
        for (SharedCodeSource cs : codeSources) {
            ListQueries.addQueryClassNames(cs, packagePrefixes, classNames);
        }
    }

    private static void addQueryClassNames(SharedCodeSource codeSource, String[] packagePrefixes, List queryClassNames) throws Exception {
        String[] contents = codeSource.list();
        for (int i = 0; i < contents.length; ++i) {
            String path = contents[i];
            for (int j = 0; j < packagePrefixes.length; ++j) {
                String className;
                String prefix = packagePrefixes[j];
                if (!path.startsWith(prefix) || !path.endsWith(".class") || path.indexOf(36) >= 0 || (className = path.substring(prefix.length())).indexOf(47) >= 0) continue;
                className = className.substring(0, className.length() - 6);
                queryClassNames.add(className);
            }
        }
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-l")) {
                this.summary = false;
                continue;
            }
            this.classNames.add(arg);
        }
    }
}

