/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.net.URL;
import java.util.Enumeration;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;

public class GetResource
extends ClassLoaderQuery {
    private String resourcePath;
    private PolicyClassLoader loader;
    private boolean all;

    public String getDescription() {
        return "Call getResource() or getResources() on a specified loader and report the results.\n\nArgs: resourcePath [loaderName] [-all]\n\nUses getResource() unless -all is specified. Uses default app root loader if not specified.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.parseArgs(args);
        this.append("Calling getResource");
        if (this.all) {
            this.append('s');
        }
        this.append("(\"");
        this.append(this.resourcePath);
        this.append("\") on ");
        this.append(this.loader.getDisplayName());
        try {
            if (this.all) {
                Enumeration result = this.loader.getResources(this.resourcePath);
                if (!result.hasMoreElements()) {
                    this.appendln(" returns an empty set.");
                } else {
                    this.appendln(" returns:");
                    this.appendln();
                    int line = 1;
                    while (result.hasMoreElements()) {
                        this.indentLineNumber(line++);
                        this.append(". ");
                        this.appendResource((URL)result.nextElement());
                        this.appendln();
                    }
                }
            } else {
                URL result = this.loader.getResource(this.resourcePath);
                if (result == null) {
                    this.appendln(" returns null.");
                } else {
                    this.appendln(" returns:");
                    this.appendln();
                    this.appendResource(result);
                    this.appendln();
                }
            }
        }
        catch (Throwable e) {
            this.appendln(" failed:");
            this.appendln();
            this.appendln(e.toString());
        }
    }

    protected void appendResource(URL url) {
        this.append(url);
    }

    private void parseArgs(String[] args) {
        this.resourcePath = args[0];
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-all")) {
                this.all = true;
                continue;
            }
            this.loader = GetResource.findLoader(args[1]);
            if (this.loader != null) continue;
            throw new IllegalArgumentException("Loader \"" + args[1] + "\" not found.");
        }
        if (this.loader == null) {
            this.loader = GetResource.findLoader("default.root");
            if (this.loader == null) {
                this.loader = GetResource.getMainLoader();
            }
        }
    }
}

