/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedJar;
import oracle.classloader.util.ClassLoadLogger;

public class DuplicateCodeSources
extends ClassLoaderQuery {
    private boolean doDigestCheck;

    public String getDescription() {
        return "List code-sources that have more than 1 subscriber, or the same name.\nThe -digest option can be specified for bit-wise comparisons.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.processArgs(args);
        this.reportMultipleSubscribers(DuplicateCodeSources.findMultipleSubscribers());
        this.reportDuplicateFileNames(DuplicateCodeSources.findDuplicateFileNames());
        if (this.doDigestCheck) {
            this.reportDuplicateDigests(DuplicateCodeSources.findDuplicateDigests());
        }
    }

    public static List findMultipleSubscribers() {
        ArrayList<SharedCodeSource> result = new ArrayList<SharedCodeSource>();
        for (SharedCodeSource source : DuplicateCodeSources.getAllCodeSources()) {
            if (source.getSubscribers().getCount() <= 1) continue;
            result.add(source);
        }
        return result;
    }

    public static List findDuplicateFileNames() {
        ArrayList result = new ArrayList();
        HashMap<String, SharedCodeSource> names = new HashMap<String, SharedCodeSource>();
        for (SharedCodeSource source : DuplicateCodeSources.getAllCodeSources()) {
            Object existing;
            String fileName = source.getLocation().getPath();
            if (fileName.endsWith("/")) continue;
            int index = fileName.lastIndexOf(47);
            if (index >= 0) {
                fileName = fileName.substring(index + 1);
            }
            if ((existing = names.get(fileName)) != null) {
                if (existing instanceof List) {
                    ((List)existing).add(source);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(existing);
                    list.add(source);
                    result.add(list);
                }
            }
            names.put(fileName, source);
        }
        return result;
    }

    public static List findDuplicateDigests() {
        ArrayList result = new ArrayList();
        HashMap<String, SharedCodeSource> names = new HashMap<String, SharedCodeSource>();
        List allCodeSources = DuplicateCodeSources.getAllCodeSources();
        int current = 1;
        int total = allCodeSources.size();
        for (SharedCodeSource source : DuplicateCodeSources.getAllCodeSources()) {
            if (source instanceof SharedJar) {
                System.out.println("Computing digest " + current++ + " of " + total + ": " + source.getLocation());
                try {
                    String digest = DuplicateCodeSources.digestToString(source.getSHADigest());
                    Object existing = names.get(digest);
                    if (existing != null) {
                        if (existing instanceof List) {
                            ((List)existing).add(source);
                        } else {
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(existing);
                            list.add(source);
                            result.add(list);
                        }
                    }
                    names.put(digest, source);
                }
                catch (Exception e) {
                    ClassLoadLogger.log(Level.SEVERE, e.getMessage());
                }
                continue;
            }
            System.out.println("Skipping " + current++ + " of " + total + ": " + source.getLocation());
        }
        return result;
    }

    public static String digestToString(byte[] digest) {
        int count = digest.length;
        char[] chars = new char[count];
        for (int i = 0; i < digest.length; ++i) {
            chars[i] = (char)digest[i];
        }
        return new String(chars);
    }

    private void processArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-digest")) continue;
            this.doDigestCheck = true;
        }
    }

    private void reportMultipleSubscribers(List list) {
        if (list.isEmpty()) {
            this.appendln("No code-sources found with multiple subscribers.");
        } else {
            for (SharedCodeSource source : list) {
                this.append(source);
                this.append(" has ");
                this.append(source.getSubscribers().getCount());
                this.appendln(" subscribers: ");
                PolicyClassLoader[] subscribers = source.getSubscribers().getSubscribers();
                for (int i = 0; i < subscribers.length; ++i) {
                    PolicyClassLoader subscriber = subscribers[i];
                    if (subscriber == null) continue;
                    this.indent();
                    this.appendln(subscriber.getUniqueName());
                }
                this.appendln();
            }
        }
    }

    private void reportDuplicateFileNames(List list) {
        if (list.isEmpty()) {
            this.appendln("No code-sources found with the same file-name.");
        } else {
            for (List duplicates : list) {
                this.appendln("The following code-sources have the same file-name:");
                for (SharedCodeSource source : duplicates) {
                    this.indent();
                    this.appendln(source);
                }
                this.appendln();
            }
        }
    }

    private void reportDuplicateDigests(List list) {
        if (list.isEmpty()) {
            this.appendln("No code-sources found with the same digest.");
        } else {
            for (List duplicates : list) {
                this.appendln("The following code-sources have the same digest:");
                for (SharedCodeSource source : duplicates) {
                    this.indent();
                    this.appendln(source);
                }
                this.appendln();
            }
        }
    }
}

