/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.classloader.ClassLoaderFilter;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;

public class DuplicateClasses
extends ClassLoaderQuery {
    private PolicyClassLoader loader;
    private boolean includeSystem;
    private List loaders;
    private List codeSources;
    public static final ClassLoaderFilter APPLICATION_FILTER = new ClassLoaderFilter(){

        public boolean match(PolicyClassLoader loader) {
            return loader.isApplicationLoader();
        }
    };

    public String getDescription() {
        return "List duplicate classes, both loaded and in code-sources.\n\nArgs: [loaderName] [-systemCodeSources]\n\nBy default, all loaders and all application code-sources are checked. Use loaderName to limit the code-source search to a specific search path. Use -systemCodeSources to include system code-sources.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.parseArgs(args);
        HashMap csIndex = new HashMap();
        HashMap csDuplicateCounts = new HashMap();
        ArrayList csDuplicateResources = new ArrayList();
        ArrayList csDuplicateClasses = new ArrayList();
        ArrayList csRedundantCodeSources = new ArrayList();
        Map loadedDuplicates = DuplicateClasses.collectDuplicateClassesFrom(this.loaders);
        DuplicateClasses.collectResourcePathInfo(this.codeSources, csIndex, csDuplicateCounts, csDuplicateResources, csDuplicateClasses, csRedundantCodeSources);
        this.reportHeader(loadedDuplicates.size());
        this.reportLoadedDuplicates(loadedDuplicates);
        this.reportCodeSourcesWithDuplicates(csDuplicateCounts);
        this.reportRedundantCodeSources(csRedundantCodeSources);
        this.reportDuplicateResources(csDuplicateResources, csIndex);
        this.reportDuplicateClasses(csDuplicateClasses, csIndex);
    }

    private void parseArgs(String[] args) {
        List loaderSet;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-systemCodeSources")) {
                this.includeSystem = true;
                continue;
            }
            this.loader = DuplicateClasses.findLoader(arg);
            if (this.loader != null) continue;
            throw new IllegalArgumentException("Loader \"" + arg + "\" not found.");
        }
        this.loaders = DuplicateClasses.getAllLoaders();
        if (this.loader == null && this.includeSystem) {
            this.codeSources = DuplicateClasses.getAllCodeSources();
        } else if (this.loader == null) {
            ClassLoaderFilter filter = this.includeSystem ? null : APPLICATION_FILTER;
            loaderSet = DuplicateClasses.getAllLoaders(filter);
            this.codeSources = DuplicateClasses.getCodeSourcesOf(loaderSet);
        } else {
            LoaderVisitor visitor = new LoaderVisitor(this.includeSystem);
            DuplicateClasses.visitLoadersInSearchOrder(this.loader, visitor);
            loaderSet = visitor.getLoaders();
            this.codeSources = DuplicateClasses.getCodeSourcesOf(loaderSet);
        }
    }

    private static Map collectDuplicateClassesFrom(List loaders) {
        HashMap<String, Class> names = new HashMap<String, Class>();
        HashMap<String, ArrayList<Class>> duplicates = new HashMap<String, ArrayList<Class>>();
        for (PolicyClassLoader loader : loaders) {
            List list = DuplicateClasses.getLoadedClasses(loader);
            for (Class cls : list) {
                String name = cls.getName();
                Object prev = names.get(name);
                if (prev == null) {
                    names.put(name, cls);
                    continue;
                }
                ArrayList<Class> dups = (ArrayList<Class>)duplicates.get(name);
                if (dups == null) {
                    dups = new ArrayList<Class>();
                    dups.add((Class)prev);
                    duplicates.put(name, dups);
                }
                dups.add(cls);
            }
        }
        return duplicates;
    }

    private static List getCodeSourcesOf(List loaders) {
        HashSet<SharedCodeSource> set = new HashSet<SharedCodeSource>();
        ArrayList<SharedCodeSource> result = new ArrayList<SharedCodeSource>();
        for (PolicyClassLoader loader : loaders) {
            SharedCodeSource[] sources = loader.getCodeSources(true);
            for (int i = 0; i < sources.length; ++i) {
                SharedCodeSource source = sources[i];
                if (set.contains(source)) continue;
                set.add(source);
                result.add(source);
            }
        }
        return result;
    }

    private void reportHeader(int loadedDuplicatesFound) {
        this.appendln("-------- Duplicate Classes Query Results -------------");
        this.appendln();
        this.append("          Loaders checked: ");
        this.appendln(this.loaders.size());
        this.append("  Loaded duplicates found: ");
        this.appendln(loadedDuplicatesFound);
        this.append("     Code-sources checked: ");
        this.appendln(this.codeSources.size());
        this.appendln();
    }

    private void reportCodeSourcesWithDuplicates(Map duplicateCounts) {
        this.append("Code-sources containing duplicates: ");
        this.appendln(duplicateCounts.size());
        this.appendln();
        int lineNumber = 1;
        for (Map.Entry e : duplicateCounts.entrySet()) {
            SharedCodeSource cs = (SharedCodeSource)e.getKey();
            int[] counts = (int[])e.getValue();
            this.indentLineNumber(lineNumber++);
            this.appendDisplayPath(cs);
            this.append(". Duplicate classes: ");
            this.append(counts[0]);
            this.append(", resources: ");
            this.appendln(counts[1]);
        }
        this.appendln();
    }

    private void reportDuplicateResources(List duplicateResources, Map index) {
        this.append("Duplicate resources by resource path: ");
        this.reportDuplicatesByPath(duplicateResources, index);
    }

    private void reportDuplicateClasses(List duplicateClasses, Map index) {
        this.append("Code-source sets containing duplicate classes: ");
        this.reportDuplicatesByCodeSource(duplicateClasses, index);
    }

    private void reportRedundantCodeSources(List redundantCodeSources) {
        this.append("Code-sources containing identical resource paths: ");
        int duplicateCount = redundantCodeSources.size();
        this.appendln(duplicateCount);
        this.appendln();
        for (int i = 0; i < duplicateCount; ++i) {
            this.indentLineNumber(i + 1);
            SharedCodeSource cs = (SharedCodeSource)redundantCodeSources.get(i);
            this.appendCodeSourceAndLoaders(cs);
            this.appendln();
        }
        this.appendln();
    }

    private void appendCodeSourceAndLoaders(SharedCodeSource cs) {
        this.appendDisplayPath(cs);
        this.append(", in use by: ");
        PolicyClassLoader[] subscribers = cs.getSubscribers().getSubscribers();
        for (int i = 0; i < subscribers.length; ++i) {
            if (subscribers[i] == null) continue;
            if (i > 0) {
                this.append(", ");
            }
            this.append(subscribers[i].getDisplayName());
        }
    }

    private void reportDuplicatesByPath(List duplicatePaths, Map index) {
        int duplicateCount = duplicatePaths.size();
        this.appendln(duplicateCount);
        this.appendln();
        for (int i = 0; i < duplicateCount; ++i) {
            String key = (String)duplicatePaths.get(i);
            this.indentLineNumber(i + 1);
            this.append(key);
            this.append(", found in: ");
            this.appendln();
            List sources = (List)index.get(key);
            for (SharedCodeSource cs : sources) {
                this.indent();
                this.indent();
                if (i + 1 < 10) {
                    this.append(" ");
                }
                this.appendCodeSourceAndLoaders(cs);
                this.appendln();
            }
        }
        this.appendln();
    }

    private void reportDuplicatesByCodeSource(List duplicatePaths, Map index) {
        HashMap<List, ArrayList<String>> codeSources = new HashMap<List, ArrayList<String>>();
        for (int i = 0; i < duplicatePaths.size(); ++i) {
            String key = (String)duplicatePaths.get(i);
            List sources = (List)index.get(key);
            ArrayList<String> paths = (ArrayList<String>)codeSources.get(sources);
            if (paths == null) {
                paths = new ArrayList<String>();
                codeSources.put(sources, paths);
            }
            paths.add(key);
        }
        int duplicateCount = codeSources.size();
        this.appendln(duplicateCount);
        this.appendln();
        int lineNumber = 1;
        for (Map.Entry e : codeSources.entrySet()) {
            List sources = (List)e.getKey();
            List paths = (List)e.getValue();
            int indentCount = 0;
            for (SharedCodeSource cs : sources) {
                if (indentCount == 0) {
                    StringBuffer buffer = this.getReportBuffer();
                    int startLength = buffer.length();
                    this.indentLineNumber(lineNumber++);
                    int endLength = buffer.length();
                    indentCount = endLength - startLength;
                } else {
                    this.appendSpaces(indentCount);
                }
                this.appendCodeSourceAndLoaders(cs);
                this.appendln();
            }
            this.appendln();
            for (String path : paths) {
                this.indent();
                this.indent();
                this.append(path);
                this.appendln();
            }
            this.appendln();
        }
        this.appendln();
    }

    public static int collectResourcePathInfo(List codeSources, Map index, Map duplicateCounts, List duplicateResources, List duplicateClasses, List redundantCodeSources) throws IOException {
        int classesFound = 0;
        for (SharedCodeSource cs : codeSources) {
            if (!DuplicateClasses.shouldInclude(cs)) continue;
            int checkedCount = 0;
            int duplicateCount = 0;
            String[] paths = cs.listFilePaths();
            for (int i = 0; i < paths.length; ++i) {
                ArrayList<SharedCodeSource> list;
                String key = paths[i];
                if (!DuplicateClasses.shouldInclude(key)) continue;
                ++checkedCount;
                boolean isClass = key.endsWith(".class");
                if (isClass) {
                    ++classesFound;
                }
                Object value = index.get(key);
                boolean isDuplicate = false;
                if (value == null) {
                    index.put(key, cs);
                } else if (value instanceof List) {
                    isDuplicate = true;
                    list = (ArrayList<SharedCodeSource>)value;
                    list.add(cs);
                } else {
                    isDuplicate = true;
                    if (isClass) {
                        duplicateClasses.add(key);
                    } else {
                        duplicateResources.add(key);
                    }
                    list = new ArrayList<SharedCodeSource>();
                    list.add((SharedCodeSource)value);
                    list.add(cs);
                    index.put(key, list);
                }
                if (!isDuplicate) continue;
                ++duplicateCount;
                int[] counts = (int[])duplicateCounts.get(cs);
                if (counts == null) {
                    counts = new int[]{0, 0};
                    duplicateCounts.put(cs, counts);
                }
                if (isClass) {
                    counts[0] = counts[0] + 1;
                    continue;
                }
                counts[1] = counts[1] + 1;
            }
            if (duplicateCount != checkedCount) continue;
            redundantCodeSources.add(cs);
        }
        return classesFound;
    }

    private static boolean shouldInclude(SharedCodeSource cs) {
        return !cs.nativeOnly();
    }

    private static boolean shouldInclude(String path) {
        String fileName;
        if (path.endsWith("/")) {
            return false;
        }
        int index = path.lastIndexOf("/");
        return index < 0 || !(fileName = path.substring(index + 1)).equalsIgnoreCase("manifest.mf");
    }

    private void reportLoadedDuplicates(Map duplicates) {
        this.append("Loaded duplicates: ");
        this.appendln(duplicates.size());
        this.appendln();
        int lineNumber = 1;
        for (Map.Entry e : duplicates.entrySet()) {
            String name = (String)e.getKey();
            List dups = (List)e.getValue();
            this.indentLineNumber(lineNumber++);
            this.append(name);
            this.append(", by: ");
            this.appendln();
            for (Class cls : dups) {
                this.indent(2);
                this.append(DuplicateClasses.getLoaderNameFor(cls));
                this.append(" (from ");
                this.append(DuplicateClasses.getCodeSourceFor(cls));
                this.appendln(").");
            }
            this.appendln();
        }
        this.appendln();
    }

    private static class LoaderVisitor
    implements ClassLoaderVisitor {
        private List loaders = new ArrayList();
        private boolean includeSystem;

        public LoaderVisitor(boolean includeSystem) {
            this.includeSystem = includeSystem;
        }

        public boolean visit(PolicyClassLoader loader) {
            if (this.includeSystem || loader.isApplicationLoader()) {
                this.loaders.add(loader);
            }
            return true;
        }

        public List getLoaders() {
            return this.loaders;
        }
    }
}

