/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.Arrays;
import java.util.List;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;

public class Dependencies
extends ClassLoaderQuery {
    private String className;
    private PolicyClassLoader loader;
    private boolean recurse;
    private String[] ignorePackages;

    public String getDescription() {
        return "List the dependencies of the specified class.\n\nArgs: className [loaderName] [-r].\n\nIf not supplied, loader defaults to the main loader. Use of the recursion flag can cause long execution times.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.parseArgs(args);
        List dependencies = Dependencies.getDependencies(this.className, this.loader, this.recurse, this.ignorePackages);
        Object[] deps = dependencies.toArray();
        Arrays.sort(deps);
        this.append("Class ");
        this.append(this.className);
        this.appendln(" has the following dependencies:");
        int lineNumber = 1;
        for (int i = 0; i < deps.length; ++i) {
            this.indentLineNumber(lineNumber++);
            this.appendln(deps[i]);
        }
    }

    private void parseArgs(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException("className required.");
        }
        this.className = args[0];
        this.ignorePackages = null;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-r")) {
                this.recurse = true;
                continue;
            }
            this.loader = Dependencies.findLoader(args[i]);
            if (this.loader != null) continue;
            throw new IllegalArgumentException("Loader \"" + args[1] + "\" not found.");
        }
        if (this.loader == null) {
            this.loader = Dependencies.getMainLoader();
        }
    }
}

