/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.ArrayList;
import java.util.List;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchMetrics;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadTracing;
import oracle.classloader.util.Clock;

public class ClassLoadMetrics
extends ClassLoaderQuery {
    private static final int DESCRIPTION_COLUMN = 25;
    private int descriptionColumn = 25;
    private boolean verbose;
    private Clock clock;
    private long ticksToMillis;

    public String getDescription() {
        return "Report metrics from specified loader(s) or all if none specified.\n\nArgs: [-verbose] [loaderName] ...";
    }

    public void createQueryReport(String[] args) throws Exception {
        if (SearchMetrics.enabled()) {
            this.clock = Clock.getInstance();
            this.ticksToMillis = this.clock.getFrequency() / 1000L;
            List loaders = this.getLoaderList(args);
            this.reportMetricsFor(loaders);
        } else {
            this.appendln();
            this.appendln("Metrics collection for class loading is disabled. To enable, specify:");
            this.appendln();
            this.append("    -D");
            this.append(ClassLoadEnvironment.getMetricsKey());
            this.appendln("=true");
            this.appendln();
        }
    }

    private List getLoaderList(String[] args) {
        if (args.length > 0) {
            List<PolicyClassLoader> result = new ArrayList();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("-detail") || arg.equals("-verbose")) {
                    this.verbose = true;
                    continue;
                }
                PolicyClassLoader loader = ClassLoadMetrics.findLoader(arg);
                if (loader == null) {
                    throw new IllegalArgumentException("Loader \"" + arg + "\" not found.");
                }
                result.add(loader);
            }
            if (result.isEmpty()) {
                result = ClassLoadMetrics.getAllLoaders();
            }
            return result;
        }
        return ClassLoadMetrics.getAllLoaders();
    }

    private SearchMetrics accumulateMetricsFor(List loaders) {
        SearchMetrics accumulator = SearchMetrics.getInstance("Totals");
        for (PolicyClassLoader loader : loaders) {
            loader.addMetrics(accumulator);
        }
        return accumulator;
    }

    private void reportMetricsFor(List loaders) {
        this.appendln();
        int count = loaders.size();
        if (count > 1) {
            this.descriptionColumn += 4;
            SearchMetrics totals = this.accumulateMetricsFor(loaders);
            this.appendMetrics("Loader search metrics summary", totals, this.verbose);
            this.appendln();
            long upTime = ClassLoadTracing.getUpTime();
            long totalLoaderTime = totals.getTotalMillis(-1);
            long classLoadTime = this.getTime(totals, 0, 5);
            long findCachedTime = totals.getTotalMillis(10);
            long findJRETime = totals.getTotalMillis(9);
            long findLocalClassTime = totals.getTotalMillis(11);
            long definePackageTime = totals.getTotalMillis(12);
            long defineClassTime = totals.getTotalMillis(13);
            long remainderTime = classLoadTime - findCachedTime - findJRETime - findLocalClassTime - definePackageTime - defineClassTime;
            this.append("System uptime: ");
            this.appendMillis(upTime, "");
            this.appendln();
            this.appendln();
            this.appendPercentage("Class and resource loading portion of uptime: ", totalLoaderTime, upTime);
            this.appendln();
            this.append("Total class search time: ");
            this.appendMillis(classLoadTime, "");
            this.appendln();
            this.appendln();
            this.appendPercentage("  findCachedClass() class search component: ", findCachedTime, classLoadTime);
            this.appendPercentage("     findJREClass() class search component: ", findJRETime, classLoadTime);
            this.appendPercentage("   findLocalClass() class search component: ", findLocalClassTime, classLoadTime);
            this.appendPercentage("    definePackage() class search component: ", definePackageTime, classLoadTime);
            this.appendPercentage("      defineClass() class search component: ", defineClassTime, classLoadTime);
            this.appendPercentage("   loader traversal class search component: ", remainderTime, classLoadTime);
            this.appendln();
            this.appendln("Loader search metrics detail: ");
            this.appendln();
            for (int i = 0; i < count; ++i) {
                this.indentLineNumber(i + 1);
                this.appendMetrics(loaders, i);
            }
        } else {
            this.appendMetrics(loaders, 0);
        }
    }

    private long getTime(SearchMetrics metrics, int firstIndex, int lastIndex) {
        long result = 0L;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            result += metrics.getTotalTicks(i);
        }
        return this.clock.toMillis(result);
    }

    private void appendPercentage(String message, long componentTime, long totalTime) {
        String percent = this.getPercent(componentTime, totalTime);
        this.append(message);
        this.append(percent);
        this.append("% (");
        this.appendMillis(componentTime, ")");
        this.appendln();
    }

    private String getPercent(long componentTime, long totalTime) {
        float fraction = (float)componentTime / (float)totalTime;
        int percentTo2DecimalPlaces = Math.round(fraction * 10000.0f);
        float percent = (float)percentTo2DecimalPlaces / 100.0f;
        String percentStr = Float.toString(percent);
        return percentStr;
    }

    private String getAverageMillis(long totalTicks, int count) {
        if (count == 0) {
            return "0";
        }
        double fraction = (double)totalTicks / (double)count;
        double millis = fraction / (double)this.ticksToMillis;
        long percentTo2DecimalPlaces = Math.round(millis * 100.0);
        float percent = (float)percentTo2DecimalPlaces / 100.0f;
        String percentStr = Float.toString(percent);
        return percentStr;
    }

    private void appendMetrics(List loaders, int index) {
        PolicyClassLoader loader = (PolicyClassLoader)loaders.get(index);
        this.appendMetrics("Loader " + loader.getDisplayName(), loader.getMetrics(), this.verbose);
    }

    private void appendMetrics(String description, SearchMetrics metrics, boolean detailed) {
        this.appendMetrics(description, -1, metrics);
        if (detailed) {
            for (int i = 0; i < 14; ++i) {
                if (i == 0) {
                    this.appendln();
                    this.appendln("        --- Search Result Events ---");
                    this.appendln();
                } else if (i == 9) {
                    this.appendln();
                    this.appendln("        --- Class Search Component Events ---");
                    this.appendln();
                }
                this.appendMetrics(null, i, metrics);
            }
            this.appendln();
        }
    }

    private void appendMetrics(String description, int resultType, SearchMetrics metrics) {
        int eventCount = metrics.getCount(resultType);
        long totalTicks = metrics.getTotalTicks(resultType);
        long maxTime = metrics.getMaximumMillis(resultType);
        String average = this.getAverageMillis(totalTicks, eventCount);
        if (description == null) {
            int length;
            description = SearchMetrics.getResultDescription(resultType);
            for (int i = length = description.length(); i < this.descriptionColumn; ++i) {
                this.append(' ');
            }
        }
        this.append(description);
        this.append(": ");
        this.append(eventCount);
        this.append(" events, ");
        this.appendMillis(this.clock.toMillis(totalTicks), " total, ");
        this.appendMillis(maxTime, " max, ");
        this.append(average);
        this.append("ms avg.");
        this.appendln();
    }

    private void appendMillis(long l, String description) {
        StringBuffer buf = this.getReportBuffer();
        buf.append(l);
        buf.append("ms");
        buf.append(description);
    }
}

