/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceURL;
import oracle.classloader.util.ClassLoadLogger;

public class SharedJar
extends SharedCodeSource {
    File file;
    JarFile jar;
    Manifest manifest;

    protected SharedJar(File existingCanonicalFile, URL url) {
        super(url, existingCanonicalFile.lastModified(), existingCanonicalFile.length());
        this.file = existingCanonicalFile;
    }

    public boolean canSubstituteFor(int equalityPolicy, File targetFile, PolicyClassLoader subscriber) {
        if (equalityPolicy == 0) {
            return true;
        }
        boolean result = false;
        if (targetFile.isFile() && this.file.length() == targetFile.length()) {
            try {
                JarFile jar = new JarFile(targetFile);
                Manifest ours = this.getManifest();
                Manifest theirs = jar.getManifest();
                if ((ours == null && theirs == null || ours.equals(theirs)) && this.jar.size() == jar.size()) {
                    result = equalityPolicy == 3 ? SharedJar.entriesEqual(this.jar, jar) : (equalityPolicy == 4 ? SharedJar.bitwiseEqual(this.file, targetFile) : true);
                }
            }
            catch (Throwable e) {
                ClassLoadLogger.log(Level.CONFIG, "comparison.error", e, this, targetFile);
            }
        }
        return result;
    }

    private static boolean entriesEqual(ZipFile left, ZipFile right) {
        boolean result = true;
        try {
            Enumeration<? extends ZipEntry> enumL = left.entries();
            Enumeration<? extends ZipEntry> enumR = right.entries();
            while (enumL.hasMoreElements()) {
                ZipEntry el = enumL.nextElement();
                ZipEntry er = enumR.nextElement();
                if (!el.getName().equals(er.getName())) {
                    result = false;
                } else if (el.getSize() != er.getSize()) {
                    result = false;
                } else {
                    if (el.getCrc() == er.getCrc()) continue;
                    result = false;
                }
                break;
            }
        }
        catch (Throwable e) {
            result = false;
        }
        return result;
    }

    private static boolean bitwiseEqual(File left, File right) {
        boolean result = false;
        FileInputStream leftStream = null;
        FileInputStream rightStream = null;
        byte[] leftBuffer = new byte[4096];
        byte[] rightBuffer = new byte[4096];
        try {
            int rightRead;
            int leftRead;
            leftStream = new FileInputStream(left);
            rightStream = new FileInputStream(right);
            while ((leftRead = leftStream.read(leftBuffer)) > 0 && leftRead == (rightRead = rightStream.read(rightBuffer))) {
                for (int i = 0; i < leftRead && leftBuffer[i] == rightBuffer[i]; ++i) {
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (leftStream != null) {
                leftStream.close();
            }
            if (rightStream != null) {
                rightStream.close();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return result;
    }

    protected void doOpen() throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file + " does not exist.");
        }
        this.jar = new JarFile(this.file);
    }

    protected long doGetLastModifiedTime() throws IOException {
        return this.file.lastModified();
    }

    protected long doGetSize() throws IOException {
        return this.file.length();
    }

    protected Manifest doGetManifest() throws IOException {
        if (this.manifest == null) {
            this.manifest = this.jar.getManifest();
            if (this.manifest != null && !this.manifest.getEntries().isEmpty()) {
                try {
                    JarEntry entry = this.jar.entries().nextElement();
                    this.jar.getInputStream(entry).close();
                }
                catch (Throwable t) {
                    ClassLoadLogger.log(Level.CONFIG, "Jar verifier pre-load: " + t);
                }
            }
        }
        return this.manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RecoverableByteBuffer doGetResourceBytes(int currentMaintenanceTick, String relativePath, RecoverableByteBuffer buffer) throws IOException {
        JarEntry entry = this.jar.getJarEntry(relativePath);
        if (entry != null) {
            int size = (int)entry.getSize();
            if (buffer == null) {
                buffer = new RecoverableByteBuffer(size);
            }
            InputStream in = null;
            try {
                in = this.jar.getInputStream(entry);
                buffer.read(this, currentMaintenanceTick, in, size);
                buffer.setCertificates(entry.getCertificates());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            return buffer;
        }
        return null;
    }

    protected boolean doContainsResource(String relativePath) throws IOException {
        return this.jar.getJarEntry(relativePath) != null;
    }

    protected URL doGetResource(String relativePath) {
        JarEntry entry = this.jar.getJarEntry(relativePath);
        if (entry != null) {
            return SharedCodeSourceURL.create(this.getLocation(), relativePath);
        }
        return null;
    }

    protected long doGetLastModifiedTime(String relativePath) throws IOException {
        JarEntry entry = this.jar.getJarEntry(relativePath);
        if (entry != null) {
            return entry.getTime();
        }
        return 0L;
    }

    protected InputStream doGetStream(String relativePath) throws IOException {
        JarEntry entry = this.jar.getJarEntry(relativePath);
        if (entry != null) {
            return this.jar.getInputStream(entry);
        }
        throw new FileNotFoundException(relativePath + " not found in " + this.getLocation());
    }

    protected long doGetLength(String relativePath) {
        JarEntry entry = this.jar.getJarEntry(relativePath);
        if (entry != null) {
            return entry.getSize();
        }
        return -1L;
    }

    protected File doGetFile(String relativePath) {
        if (relativePath == null) {
            return this.file;
        }
        return null;
    }

    protected void doClose() throws IOException {
        if (this.jar != null) {
            JarFile theJar = this.jar;
            this.jar = null;
            this.manifest = null;
            theJar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdateDigest(MessageDigest digest) throws IOException {
        FileInputStream in = null;
        try {
            byte[] buffer = new byte[4096];
            in = new FileInputStream(this.file);
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer)) > 0) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected boolean addPaths(ArrayList list, boolean includeDirectoryPaths) {
        Enumeration<JarEntry> e = this.jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            if (includeDirectoryPaths) {
                list.add(name);
                continue;
            }
            if (entry.isDirectory()) continue;
            list.add(name);
        }
        return true;
    }

    protected void doAddMetaInfPaths(List list) {
        Enumeration<JarEntry> e = this.jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            if (entry.isDirectory() || !name.startsWith("META-INF/")) continue;
            list.add(name);
        }
    }
}

