/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceURL;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.FileUtils;

public class SharedDirectory
extends SharedCodeSource {
    private File directory;
    private static final byte TRUE_AS_BYTE = 0;
    private static final byte FALSE_AS_BYTE = 1;
    private static final boolean FILE_SCHEME_URLS = ClassLoadEnvironment.useFileSchemeForDirectoryURLs();
    private static final String META_INF = "META-INF";

    protected SharedDirectory(File dir, URL location) {
        super(location, dir.lastModified(), dir.list() == null ? -1L : (long)dir.list().length);
        this.directory = dir;
    }

    public boolean nativeOnly() {
        PolicyClassLoader[] subscribers;
        for (PolicyClassLoader subscriber : subscribers = this.getSubscribers().getSubscribers()) {
            SharedCodeSource[] natives = subscriber.getNativeCodeSources();
            boolean nativeSubscriber = false;
            if (natives != null) {
                for (SharedCodeSource aNative : natives) {
                    if (aNative != this) continue;
                    nativeSubscriber = true;
                    break;
                }
            }
            if (nativeSubscriber) continue;
            return false;
        }
        return true;
    }

    protected void doOpen() throws IOException {
        if (!this.directory.exists()) {
            throw new FileNotFoundException(this.directory + " does not exist.");
        }
        if (this.directory.isFile()) {
            throw new IOException(this.directory + " is not a directory.");
        }
    }

    protected long doGetLastModifiedTime() throws IOException {
        return this.directory.lastModified();
    }

    protected long doGetSize() throws IOException {
        String[] list = this.directory.list();
        if (list == null) {
            return 0L;
        }
        return list.length;
    }

    protected Manifest doGetManifest() throws IOException {
        File manifestFile = this.getFile("META-INF/MANIFEST.MF");
        if (manifestFile != null && manifestFile.exists()) {
            FileInputStream fis = new FileInputStream(manifestFile);
            Manifest m = new Manifest(fis);
            fis.close();
            return m;
        }
        return null;
    }

    protected RecoverableByteBuffer doGetResourceBytes(int currentMaintenanceTick, String relativePath, RecoverableByteBuffer buffer) throws IOException {
        File file = new File(this.directory, relativePath);
        if (file.exists()) {
            FileInputStream stream = new FileInputStream(file);
            int size = ((InputStream)stream).available();
            if (buffer == null) {
                buffer = new RecoverableByteBuffer(size);
            }
            buffer.read(this, currentMaintenanceTick, stream, size);
            return buffer;
        }
        return null;
    }

    protected boolean doContainsResource(String relativePath) {
        File file = new File(this.directory, relativePath);
        return file.exists();
    }

    protected URL doGetResource(String relativePath) throws IOException {
        File file = new File(this.directory, relativePath);
        if (file.exists()) {
            if (FILE_SCHEME_URLS) {
                return FileUtils.toURL(file);
            }
            return SharedCodeSourceURL.create(this.getLocation(), relativePath);
        }
        return null;
    }

    protected long doGetLastModifiedTime(String relativePath) throws IOException {
        File file = new File(this.directory, relativePath);
        if (file.exists()) {
            return file.lastModified();
        }
        return 0L;
    }

    protected InputStream doGetStream(String relativePath) throws IOException {
        return new FileInputStream(new File(this.directory, relativePath));
    }

    protected long doGetLength(String relativePath) {
        File file;
        if (relativePath != null && (file = new File(this.directory, relativePath)).exists()) {
            return file.length();
        }
        return -1L;
    }

    protected File doGetFile(String relativePath) {
        if (relativePath == null) {
            return this.directory;
        }
        File result = new File(this.directory, relativePath);
        if (result.exists()) {
            return result;
        }
        return null;
    }

    protected void doClose() {
    }

    protected void doUpdateDigest(MessageDigest digest) throws IOException {
        byte[] buffer = new byte[4096];
        String[] files = this.directory.list();
        if (files != null) {
            for (String file : files) {
                this.digestFile(this.directory, "", file, buffer, digest);
            }
        }
    }

    protected boolean addPaths(ArrayList list, boolean includeDirectoryPaths) {
        String[] files = this.directory.list();
        if (files != null) {
            for (String file : files) {
                this.appendPaths(this.directory, "", file, list, includeDirectoryPaths);
            }
        }
        return false;
    }

    protected void addPackagePaths(Set set) throws IOException {
        String[] files = this.directory.list();
        if (files != null) {
            for (String file : files) {
                this.addPackagePaths(this.directory, "", file, set);
            }
        }
    }

    protected void doAddMetaInfPaths(List list) {
        if (new File(this.directory, META_INF).exists()) {
            this.appendPaths(this.directory, "", META_INF, list, false);
        }
    }

    private void appendPaths(File rootDir, String rootPath, String fileName, List list, boolean includeDirectoryPaths) {
        String relativePath = rootPath + fileName;
        File absoluteFile = new File(rootDir, fileName);
        if (absoluteFile.isDirectory()) {
            String[] files;
            if (!relativePath.endsWith("/")) {
                relativePath = relativePath + '/';
            }
            if (includeDirectoryPaths) {
                list.add(relativePath);
            }
            if ((files = absoluteFile.list()) != null) {
                for (String file : files) {
                    this.appendPaths(absoluteFile, relativePath, file, list, includeDirectoryPaths);
                }
            }
        } else {
            list.add(relativePath);
        }
    }

    private void addPackagePaths(File rootDir, String rootPath, String fileName, Set set) {
        File absoluteFile = new File(rootDir, fileName);
        if (absoluteFile.isDirectory()) {
            String relativePath = rootPath + fileName;
            set.add(relativePath);
            String[] files = absoluteFile.list();
            if (files != null) {
                if (!relativePath.endsWith("/")) {
                    relativePath = relativePath + '/';
                }
                for (String file : files) {
                    this.addPackagePaths(absoluteFile, relativePath, file, set);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void digestFile(File rootDir, String rootPath, String fileName, byte[] buffer, MessageDigest digest) throws IOException {
        block7: {
            File absoluteFile;
            block6: {
                String relativePath = rootPath + fileName;
                if (!relativePath.endsWith("/")) {
                    relativePath = relativePath + '/';
                }
                absoluteFile = new File(rootDir, fileName);
                boolean isDir = absoluteFile.isDirectory();
                digest.update(relativePath.getBytes());
                long lastModifiedTime = absoluteFile.lastModified();
                digest.update((byte)((lastModifiedTime & 0xF000L) >> 24));
                digest.update((byte)((lastModifiedTime & 0xF00L) >> 16));
                digest.update((byte)((lastModifiedTime & 0xF0L) >> 8));
                digest.update((byte)(lastModifiedTime & 0xFL));
                long size = absoluteFile.length();
                digest.update((byte)((size & 0xF000L) >> 24));
                digest.update((byte)((size & 0xF00L) >> 16));
                digest.update((byte)((size & 0xF0L) >> 8));
                digest.update((byte)(size & 0xFL));
                digest.update(absoluteFile.canRead() ? (byte)0 : 1);
                digest.update(absoluteFile.canWrite() ? (byte)0 : 1);
                digest.update(absoluteFile.isHidden() ? (byte)0 : 1);
                if (!isDir) break block6;
                String[] files = absoluteFile.list();
                if (files == null) break block7;
                for (String file : files) {
                    this.digestFile(absoluteFile, relativePath, file, buffer, digest);
                }
                break block7;
            }
            FileInputStream in = new FileInputStream(absoluteFile);
            try {
                int readSize;
                while ((readSize = in.read(buffer, 0, buffer.length)) != -1) {
                    digest.update(buffer, 0, readSize);
                }
            }
            finally {
                in.close();
            }
        }
    }
}

