/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.EventDispatcher;
import oracle.classloader.ExtensionDeclaration;
import oracle.classloader.ExtensionDependency;
import oracle.classloader.MBean;
import oracle.classloader.MBeanTarget;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.ResourcePathVisitor;
import oracle.classloader.Sharable;
import oracle.classloader.SharedCodeSourceList;
import oracle.classloader.SharedCodeSourceSet;
import oracle.classloader.SharedCodeSourceURL;
import oracle.classloader.SubscriberSet;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassLoadMonitor;
import oracle.classloader.util.URLParseUtil;

public abstract class SharedCodeSource
implements Sharable,
MBeanTarget {
    public static final int CREATED = 0;
    public static final int CLOSED = 1;
    public static final int OPENED = 2;
    public static final int SUSPENDED = 3;
    public static final int ORPHANED = 4;
    public static final int DESTROYED = 5;
    public static final Attributes.Name CUSTOM_CLASS_PATH = new Attributes.Name(ClassLoadEnvironment.getCustomManifestClassPathAtttribute());
    public static final SharedCodeSource NON_EXISTENT = new NonExistent();
    private static final String[] STATE_NAMES = new String[]{"created", "closed", "opened", "suspended", "orphaned", "destroyed"};
    private static final int SUSPEND_WAIT_MILLIS = 5000;
    private static final int SUSPEND_WARNING_MILLIS = 30000;
    private static final int SUSPEND_EXIT_MILLIS = 120000;
    protected static final String META_INF_PREFIX = "META-INF/";
    private URL location;
    private volatile int state;
    private IOException openFailed;
    private int openFailedRethrowCount;
    private int lastAccessTick;
    private int lastReadTick;
    private MBean mBean;
    private String[] paths;
    private String[] metaInfPaths;
    private String[] packagePaths;
    private long lastModifiedTime;
    private long size;
    private boolean manifestProcessed;
    private ExtensionDeclaration extensionDeclaration;
    private ExtensionDependency[] extensionDependencies;
    private File[] classPathDependencies;
    private SubscriberSet subscribers = new SubscriberSet(this, true);

    private SharedCodeSource() {
    }

    protected SharedCodeSource(URL location, long lastModifiedTime, long size) {
        this.location = location;
        this.lastModifiedTime = lastModifiedTime;
        this.size = size;
        this.state = 0;
        this.lastAccessTick = -1;
        this.lastReadTick = -1;
        SharedCodeSourceSet.add(this);
    }

    public synchronized long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public synchronized long getSize() {
        return this.size;
    }

    public int getState() {
        return this.state;
    }

    public static String getStateName(int state) {
        return STATE_NAMES[state];
    }

    public static String[] getStateNames() {
        return STATE_NAMES;
    }

    public int getLastAccessTick() {
        return this.lastAccessTick;
    }

    public int getLastReadTick() {
        return this.lastReadTick;
    }

    public synchronized void refresh() {
        if (this.state == 2) {
            try {
                if (this.doGetLastModifiedTime() != this.lastModifiedTime || this.doGetSize() != this.size) {
                    this.close();
                }
            }
            catch (IOException e) {
                ClassLoadLogger.logException("Could not refresh: " + this, e, false);
            }
        }
    }

    public synchronized ExtensionDeclaration getExtensionDeclaration() {
        try {
            this.processManifest();
        }
        catch (IOException e) {
            ClassLoadLogger.logException("Could not read manifest of: " + this, e, false);
        }
        return this.extensionDeclaration;
    }

    public synchronized ExtensionDependency[] getExtensionDependencies() {
        try {
            this.processManifest();
        }
        catch (IOException e) {
            ClassLoadLogger.logException("Could not read manifest of: " + this, e, false);
        }
        if (this.extensionDependencies != null) {
            return (ExtensionDependency[])this.extensionDependencies.clone();
        }
        return null;
    }

    public synchronized File[] getClassPathDependencies() {
        try {
            this.processManifest();
        }
        catch (IOException e) {
            ClassLoadLogger.logException("Could not read manifest of: " + this, e, false);
        }
        if (this.classPathDependencies != null) {
            return (File[])this.classPathDependencies.clone();
        }
        return null;
    }

    public void suspend() {
        if (this.state == 2) {
            this.close(3);
        } else {
            this.setState(3);
        }
    }

    public synchronized void release() {
        if (this.state == 3) {
            this.setState(1);
            this.notify();
        }
    }

    void destroy() {
        this.close(5);
        if (this.mBean != null) {
            this.mBean.unregister(this);
        }
        if (this.extensionDeclaration != null) {
            this.extensionDeclaration.destroy();
        }
    }

    public URL getLocation() {
        return this.location;
    }

    public SubscriberSet getSubscribers() {
        return this.subscribers;
    }

    public String getDisplayName() {
        return this.toString();
    }

    PolicyClassLoader getVisibleFrom(PolicyClassLoader subscriber, boolean isNative) {
        return this.subscribers.getVisibleFrom(subscriber, isNative);
    }

    public Sharable addSubscriber(PolicyClassLoader subscriber, ConfigurationOrigin origin) {
        return this.subscribers.addSubscriber(subscriber, origin);
    }

    public int removeSubscriber(PolicyClassLoader subscriber) {
        return this.subscribers.removeSubscriber(subscriber);
    }

    public boolean nativeOnly() {
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public boolean canSubstituteFor(int equalityPolicy, File targetFile, PolicyClassLoader subscriber) {
        return false;
    }

    public String toString() {
        return this.toString(this.subscribers.getFirstSubscriber());
    }

    public String toString(PolicyClassLoader subscriber) {
        String path = this.location.getPath();
        int size = path.length();
        ConfigurationOrigin[] origins = this.subscribers.getOriginsFor(subscriber);
        for (int i = 0; i < origins.length; ++i) {
            size += origins[i].getMaxToStringLength();
        }
        StringBuffer buf = new StringBuffer(size + 16);
        SharedCodeSource.append(path, origins, buf);
        return buf.toString();
    }

    public static void append(String locationPath, ConfigurationOrigin[] origins, StringBuffer buffer) {
        buffer.append(locationPath);
        buffer.append(" (");
        for (int i = 0; i < origins.length; ++i) {
            if (i == 0) {
                buffer.append("from ");
            } else {
                buffer.append(" & ");
            }
            buffer.append(origins[i]);
        }
        buffer.append(')');
    }

    synchronized void subscribeManifestClassPath(PolicyClassLoader subscriber, SharedCodeSourceList list, ProtectionPolicy protection) {
        try {
            this.processManifest();
            if (this.classPathDependencies != null && this.classPathDependencies.length > 0) {
                ConfigurationOrigin origin = this.subscribers.getFirstOriginFor(subscriber).createManifestOrigin(this.location);
                for (int i = 0; i < this.classPathDependencies.length; ++i) {
                    File file = this.classPathDependencies[i];
                    try {
                        SharedCodeSource source = SharedCodeSourceSet.subscribe(file, origin, subscriber);
                        if (source == null || source == NON_EXISTENT) continue;
                        list.addFromManifest(source, protection);
                        continue;
                    }
                    catch (IOException e) {
                        ClassLoadLogger.logException("Ignoring manifest entry: " + file + " from " + origin, e, false);
                    }
                }
            }
        }
        catch (IOException e) {
            ClassLoadLogger.logException("Could not read manifest of: " + this, e, false);
        }
    }

    private void processManifest() throws IOException {
        this.ensureOpen();
        if (!this.manifestProcessed) {
            Manifest manifest = this.doGetManifest();
            if (manifest != null) {
                Attributes attributes = manifest.getMainAttributes();
                this.classPathDependencies = this.getManifestClassPath(attributes);
                this.extensionDeclaration = ExtensionDeclaration.getDeclaration(this, attributes);
                this.extensionDependencies = ExtensionDependency.getDependencies(this, attributes);
            }
            this.manifestProcessed = true;
            EventDispatcher.codeSourceManifestProcessed(this, manifest);
        }
    }

    private File[] getManifestClassPath(Attributes attributes) {
        if (attributes != null) {
            String value = attributes.getValue(CUSTOM_CLASS_PATH);
            if (value != null) {
                return this.parseManifestPath(value);
            }
            value = attributes.getValue(Attributes.Name.CLASS_PATH);
            if (value != null) {
                return this.parseManifestPath(value);
            }
        }
        return null;
    }

    private File[] parseManifestPath(String path) {
        String ourPath = URLParseUtil.decode(this.getLocation().getPath());
        File base = new File(ourPath).getParentFile();
        StringTokenizer st = new StringTokenizer(path);
        File[] files = new File[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String relativePath = st.nextToken();
            files[i] = new File(base, relativePath);
            ++i;
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(PolicyClassLoader subscriber) {
        Class<SharedCodeSource> clazz = SharedCodeSource.class;
        synchronized (SharedCodeSource.class) {
            int count = this.removeSubscriber(subscriber);
            if (count == 0) {
                this.close(4);
            } else if (count < 0) {
                ClassLoadLogger.log(Level.WARNING, "SharedCodeSource for " + this.getLocation() + " unsubscribed, but count < 0!");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public byte[] getSHADigest() throws IOException {
        try {
            return this.getDigest("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            IOException error = new IOException();
            error.initCause(e);
            throw error;
        }
    }

    public synchronized byte[] getDigest(String algorithm) throws NoSuchAlgorithmException, IOException {
        if (this.state == 3) {
            this.waitForRelease();
        }
        this.close();
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        this.doUpdateDigest(digest);
        return digest.digest();
    }

    void setState(int newState) {
        if (newState != this.state) {
            switch (this.state) {
                case 4: {
                    SharedCodeSourceSet.removeFromLRU(this);
                    break;
                }
                default: {
                    if (newState != 4) break;
                    SharedCodeSourceSet.addToLRU(this);
                }
            }
            this.state = newState;
            EventDispatcher.codeSourceStateChanged(this, newState);
        }
    }

    private void waitForRelease() {
        int waitMillis = 0;
        while (this.state == 3) {
            if (waitMillis >= 120000) {
                ClassLoadLogger.log(Level.WARNING, "Code-source " + this + " suspended for too long. Unblocking!");
                this.state = 1;
            } else if (waitMillis >= 30000) {
                ClassLoadLogger.log(Level.WARNING, "Code-source " + this + " suspended for suspiciously long time (" + waitMillis + ").");
            }
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            waitMillis += 5000;
        }
    }

    public final synchronized Manifest getManifest() throws IOException {
        this.ensureOpen();
        return this.doGetManifest();
    }

    public final Manifest tryGetManifest() {
        try {
            return this.getManifest();
        }
        catch (IOException e) {
            if (!this.didRethrowOpenFailure()) {
                ClassLoadLogger.logException("Could not read manifest of: " + this + ".", e, false);
            }
            return null;
        }
    }

    public void assertSealedStateValid(Package pkg, String packageName, PolicyClassLoader loader) {
        if (pkg.isSealed()) {
            if (!pkg.isSealed(this.getLocation())) {
                this.throwSealedException(pkg, "sealed.previously", loader);
            }
        } else if (this.isSealed(packageName)) {
            this.throwSealedException(pkg, "not.sealed", loader);
        }
    }

    private void throwSealedException(Package pkg, String key, PolicyClassLoader loader) {
        if (System.getSecurityManager() != null) {
            throw new SecurityException("sealing violation");
        }
        boolean foundLoc = false;
        String origLoc = "<unknown>";
        try {
            Field field = Package.class.getDeclaredField("sealBase");
            field.setAccessible(true);
            origLoc = ((URL)field.get(pkg)).toString();
            foundLoc = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (!foundLoc && key.equals("not.sealed")) {
            String packagePath = pkg.getName().replace('.', '/').concat("/");
            List sources = ClassLoaderQuery.getCodeSourcesVisibleTo(loader, true);
            for (SharedCodeSource cs : sources) {
                try {
                    if (!cs.containsResource(packagePath)) continue;
                    origLoc = cs.getLocation().toString();
                    break;
                }
                catch (IOException e) {
                    if (cs.didRethrowOpenFailure() || !ClassLoadLogger.willLog(Level.WARNING)) continue;
                    ClassLoadLogger.log(Level.WARNING, "Caught " + e + ".");
                }
            }
        }
        String message = ClassLoadLogger.getText().getText(key, pkg.getName(), origLoc, this);
        throw new SecurityException(message);
    }

    private boolean isSealed(String packageName) {
        Manifest man = this.tryGetManifest();
        if (man != null) {
            String path = packageName.replace('.', '/').concat("/");
            Attributes attr = man.getAttributes(path);
            String sealed = null;
            if (attr != null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
            if (sealed == null && (attr = man.getMainAttributes()) != null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
            return "true".equalsIgnoreCase(sealed);
        }
        return false;
    }

    private void ensureOpen() throws IOException {
        if (this.state != 2) {
            this.open();
            this.paths = null;
        }
        this.lastAccessTick = ClassLoadMonitor.getLastMaintenanceTick();
    }

    public URL createURL(String relativePath) {
        return SharedCodeSourceURL.create(this.getLocation(), relativePath);
    }

    public final synchronized long getLastModifiedTime(String relativePath) throws IOException {
        this.ensureOpen();
        long result = this.doGetLastModifiedTime(relativePath);
        if (result >= 0L) {
            this.lastReadTick = this.lastAccessTick;
        } else {
            result = this.lastModifiedTime;
        }
        return result;
    }

    public final synchronized RecoverableByteBuffer getResourceBytes(String relativePath, RecoverableByteBuffer buffer) throws IOException {
        this.ensureOpen();
        RecoverableByteBuffer result = this.doGetResourceBytes(this.lastReadTick, relativePath, buffer);
        if (result != null) {
            this.lastReadTick = this.lastAccessTick;
        }
        return result;
    }

    public final synchronized boolean containsResource(String relativePath) throws IOException {
        this.ensureOpen();
        boolean result = this.doContainsResource(relativePath);
        if (result) {
            this.lastReadTick = this.lastAccessTick;
        }
        return result;
    }

    public final synchronized URL getResource(String relativePath) throws IOException {
        this.ensureOpen();
        URL result = this.doGetResource(relativePath);
        if (result != null) {
            this.lastReadTick = this.lastAccessTick;
        }
        return result;
    }

    public final synchronized InputStream getStream(String relativePath) throws IOException {
        this.ensureOpen();
        InputStream result = this.doGetStream(relativePath);
        if (result != null) {
            this.lastReadTick = this.lastAccessTick;
        }
        return result;
    }

    public final synchronized long getLength(String relativePath) throws IOException {
        this.ensureOpen();
        long result = this.doGetLength(relativePath);
        if (result >= 0L) {
            this.lastReadTick = this.lastAccessTick;
        }
        return result;
    }

    public final synchronized File getFile() {
        return this.doGetFile(null);
    }

    public final synchronized File getFile(String relativePath) throws IOException {
        this.ensureOpen();
        File result = this.doGetFile(relativePath);
        if (result != null) {
            this.lastReadTick = this.lastAccessTick;
        }
        return result;
    }

    public final boolean visitAllPaths(ResourcePathVisitor visitor, PolicyClassLoader subscriber) throws IOException {
        String[] paths = this.listPaths(false);
        for (int i = 0; i < paths.length; ++i) {
            if (visitor.visit(paths[i], this, subscriber)) continue;
            return false;
        }
        return true;
    }

    public final boolean visitMetaInfPaths(ResourcePathVisitor visitor, PolicyClassLoader subscriber) throws IOException {
        String[] paths = this.listMetaInfPaths();
        for (int i = 0; i < paths.length; ++i) {
            if (visitor.visit(paths[i], this, subscriber)) continue;
            return false;
        }
        return true;
    }

    public final String[] list() throws IOException {
        return this.listPaths(true);
    }

    public final String[] listFilePaths() throws IOException {
        return this.listPaths(false);
    }

    public final synchronized String[] listPackagePaths() throws IOException {
        this.ensureOpen();
        if (this.packagePaths == null) {
            HashSet set = new HashSet();
            this.addPackagePaths(set);
            String[] result = new String[set.size()];
            this.packagePaths = set.toArray(result);
        }
        return this.packagePaths;
    }

    public final void close() {
        this.close(1);
    }

    public boolean didRethrowOpenFailure() {
        return this.openFailedRethrowCount > 0;
    }

    private final synchronized void close(int newState) {
        block3: {
            if (this.state != 1) {
                try {
                    this.doClose();
                }
                catch (IOException e) {
                    if (!ClassLoadLogger.willLog(Level.WARNING)) break block3;
                    ClassLoadLogger.log(Level.WARNING, "Caught " + e + " trying to close " + this + ".");
                }
            }
        }
        this.setState(newState);
    }

    private void open() throws IOException {
        if (this.state == 3) {
            this.waitForRelease();
        }
        if (this.openFailed != null) {
            ++this.openFailedRethrowCount;
            throw this.openFailed;
        }
        try {
            this.doOpen();
            long size = this.doGetSize();
            long lastModifiedTime = this.doGetLastModifiedTime();
            if (this.size != size || this.lastModifiedTime != lastModifiedTime) {
                this.size = size;
                this.lastModifiedTime = lastModifiedTime;
                if (this.extensionDeclaration != null) {
                    this.extensionDeclaration.destroy();
                }
                this.extensionDeclaration = null;
                this.extensionDependencies = null;
                this.classPathDependencies = null;
                this.manifestProcessed = false;
                this.paths = null;
                this.metaInfPaths = null;
                this.packagePaths = null;
            }
            this.setState(2);
        }
        catch (IOException e) {
            if (this.getSubscribers().getCount() == 0) {
                SharedCodeSourceSet.flushCodeSource(this);
            } else {
                this.setState(1);
            }
            this.openFailed = e;
            throw e;
        }
    }

    private final synchronized String[] listPaths(boolean includeDirectories) throws IOException {
        this.ensureOpen();
        if (this.paths == null) {
            ArrayList list = new ArrayList(256);
            boolean expandPathList = this.addPaths(list, includeDirectories);
            if (!includeDirectories) {
                expandPathList = false;
            }
            this.paths = SharedCodeSource.pathListToArray(list, expandPathList);
        }
        return this.paths;
    }

    private final synchronized String[] listMetaInfPaths() throws IOException {
        this.ensureOpen();
        if (this.metaInfPaths == null) {
            ArrayList list = new ArrayList(32);
            this.doAddMetaInfPaths(list);
            this.metaInfPaths = new String[list.size()];
            list.toArray(this.metaInfPaths);
        }
        return this.metaInfPaths;
    }

    private static String[] pathListToArray(ArrayList list, boolean expandDirectories) {
        int count = list.size();
        String[] result = new String[count];
        list.toArray(result);
        if (expandDirectories) {
            HashMap map = new HashMap(count * 2);
            for (int i = 0; i < result.length; ++i) {
                String path = result[i];
                if (!path.endsWith("/")) continue;
                map.put(path, null);
            }
            boolean missing = false;
            for (int i = 0; i < result.length; ++i) {
                int lastSlash;
                String path = result[i];
                if (path.endsWith("/") || (lastSlash = path.lastIndexOf(47)) < 0 || map.containsKey(path = path.substring(0, lastSlash + 1))) continue;
                list.add(path);
                map.put(path, null);
                missing = true;
            }
            if (missing) {
                count = list.size();
                result = new String[count];
                list.toArray(result);
            }
        }
        return result;
    }

    public void setMBean(MBean mBean) {
        this.mBean = mBean;
    }

    public MBean getMBean() {
        return this.mBean;
    }

    protected abstract void doOpen() throws IOException;

    protected abstract long doGetLastModifiedTime() throws IOException;

    protected abstract long doGetSize() throws IOException;

    protected abstract boolean addPaths(ArrayList var1, boolean var2);

    protected void addPackagePaths(Set set) throws IOException {
        ArrayList list = new ArrayList(256);
        this.addPaths(list, false);
        for (String path : list) {
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash < 0) continue;
            String packagePath = path.substring(0, lastSlash);
            set.add(packagePath);
        }
    }

    protected abstract Manifest doGetManifest() throws IOException;

    protected abstract RecoverableByteBuffer doGetResourceBytes(int var1, String var2, RecoverableByteBuffer var3) throws IOException;

    protected abstract boolean doContainsResource(String var1) throws IOException;

    protected long doGetLastModifiedTime(String relativePath) throws IOException {
        if (this.doContainsResource(relativePath)) {
            return this.lastModifiedTime;
        }
        return 0L;
    }

    protected abstract URL doGetResource(String var1) throws IOException;

    protected abstract InputStream doGetStream(String var1) throws IOException;

    protected abstract long doGetLength(String var1) throws IOException;

    protected abstract File doGetFile(String var1);

    protected abstract void doUpdateDigest(MessageDigest var1) throws IOException;

    protected abstract void doClose() throws IOException;

    protected void doAddMetaInfPaths(List list) throws IOException {
        String[] paths = this.listPaths(false);
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (!path.startsWith(META_INF_PREFIX)) continue;
            list.add(path);
        }
    }

    static class NonExistent
    extends SharedCodeSource {
        NonExistent() {
        }

        protected void doOpen() {
        }

        protected long doGetLastModifiedTime() {
            return 0L;
        }

        protected long doGetSize() {
            return 0L;
        }

        protected boolean addPaths(ArrayList list, boolean includeDirectoryPaths) {
            return false;
        }

        protected boolean visitPaths(ResourcePathVisitor visitor, boolean includeDirectoryPaths) {
            return true;
        }

        protected Manifest doGetManifest() {
            return null;
        }

        protected RecoverableByteBuffer doGetResourceBytes(int currentMaintenanceTick, String relativePath, RecoverableByteBuffer buffer) {
            return null;
        }

        protected boolean doContainsResource(String relativePath) {
            return false;
        }

        protected URL doGetResource(String relativePath) {
            return null;
        }

        protected InputStream doGetStream(String relativePath) {
            return null;
        }

        protected long doGetLength(String relativePath) {
            return -1L;
        }

        protected File doGetFile(String relativePath) {
            return null;
        }

        protected void doUpdateDigest(MessageDigest digest) {
        }

        protected void doClose() {
        }
    }
}

