/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.ResourceAccessor;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ClassLoadLogger;

public class ResourceDataAccessor
extends ResourceAccessor {
    private byte[] data;
    private int dataSize;
    private boolean dataTrimmed;

    ResourceDataAccessor(String resourcePath, boolean includeManifestSources) {
        super(resourcePath, includeManifestSources);
    }

    public byte[] getData() {
        if (!this.dataTrimmed) {
            if (this.data.length != this.dataSize) {
                byte[] newArray = new byte[this.dataSize];
                System.arraycopy(this.data, 0, newArray, 0, this.dataSize);
                this.data = newArray;
            }
            this.dataTrimmed = true;
        }
        return this.data;
    }

    public long getLastModifiedTime() {
        return this.getCodeSource().getLastModifiedTime();
    }

    public boolean visit(SharedCodeSource codeSource, PolicyClassLoader subscriber) {
        try {
            RecoverableByteBuffer buffer = codeSource.getResourceBytes(this.getResourcePath(), null);
            if (buffer != null) {
                this.setCodeSource(codeSource);
                this.data = buffer.getArray();
                this.dataSize = buffer.getBytesUsed();
                return false;
            }
        }
        catch (IOException e) {
            ClassLoadLogger.logException("Unable to access code-source: " + codeSource + ".", e, false);
        }
        return true;
    }
}

