/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.CodeSourceVisitor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.Resource;
import oracle.classloader.ResourcePathVisitor;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ResourceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCollector
implements ResourcePathVisitor,
CodeSourceVisitor,
ClassLoaderVisitor,
Iterable<Resource> {
    private List<Resource> list = new ArrayList<Resource>();
    private ResourceFilter filter;
    private int minLevel;
    private int maxLevel;

    public ResourceCollector() {
        this(new ResourceFilter(){

            public boolean accept(String resourcePath, URL codeSource, ClassLoader loader) {
                return true;
            }
        });
    }

    public ResourceCollector(final String resourceSuffix) {
        this(new ResourceFilter(){

            public boolean accept(String resourcePath, URL codeSource, ClassLoader loader) {
                return resourceSuffix != null && resourcePath.endsWith(resourceSuffix);
            }
        });
    }

    public ResourceCollector(ResourceFilter filter) {
        this.filter = filter;
    }

    public void visitAllLoadersInSearchOrder(PolicyClassLoader initialLoader) {
        this.visitLoaders(initialLoader, 0, Integer.MAX_VALUE);
    }

    public void visitApplicationAndGlobalLoadersInSearchOrder(PolicyClassLoader initialLoader) {
        this.visitLoaders(initialLoader, ClassLoaderScope.GLOBAL.getLevel(), ClassLoaderScope.MAIN.getLevel() - 1);
    }

    public void visitLoadersInSearchOrder(PolicyClassLoader initialLoader, ClassLoaderScope minScope, ClassLoaderScope maxScope) {
        this.visitLoaders(initialLoader, minScope.getLevel(), maxScope.getLevel());
    }

    private void visitLoaders(PolicyClassLoader initialLoader, int minLevel, int maxLevel) {
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        initialLoader.visitUsingPolicy(this, true, false);
        this.minLevel = 0;
        this.maxLevel = Integer.MAX_VALUE;
    }

    @Override
    public boolean visit(PolicyClassLoader loader) {
        int level = loader.getScope().getLevel();
        if (level >= this.minLevel && level <= this.maxLevel) {
            return loader.visitCodeSources(this, true);
        }
        return true;
    }

    @Override
    public boolean visit(SharedCodeSource codeSource, PolicyClassLoader subscriber) {
        try {
            return codeSource.visitAllPaths(this, subscriber);
        }
        catch (IOException e) {
            ClassLoadLogger.logException("Unable to access code-source: " + codeSource + ".", e, false);
            return true;
        }
    }

    @Override
    public boolean visit(String resourcePath, SharedCodeSource codeSource, PolicyClassLoader subscriber) {
        if (this.filter.accept(resourcePath, codeSource.getLocation(), subscriber)) {
            Resource res = new Resource(resourcePath, codeSource, subscriber);
            this.list.add(res);
        }
        return true;
    }

    public void clear() {
        this.list.clear();
    }

    public List<Resource> getList() {
        return this.list;
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.list.iterator();
    }
}

