/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.util.StringTokenizer;
import java.util.jar.Attributes;
import oracle.classloader.ExtensionDeclaration;
import oracle.classloader.ExtensionDependencyQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.PropertyUtils;
import oracle.classloader.util.VersionNumber;

public class ExtensionDependency
extends ExtensionDeclaration {
    public static final int COMPATIBLE = 0;
    public static final int MATCHING_EXTENSION_NAME_NOT_FOUND = 1;
    public static final int SPECIFICATION_VERSION_REQUIRED = 2;
    public static final int IMPLEMENTATION_VENDOR_ID_REQUIRED = 3;
    public static final int IMPLEMENTATION_VERSION_REQUIRED = 4;
    public static final int INVALID_SPECIFICATION_VERSION = 5;
    public static final int SPECIFICATION_UPGRADE_REQUIRED = 6;
    public static final int VENDOR_SWITCH_REQUIRED = 7;
    public static final int INVALID_IMPLEMENTATION_VERSION = 8;
    public static final int IMPLEMENTATION_UPGRADE_REQUIRED = 9;

    private ExtensionDependency(SharedCodeSource source, String extensionName, Attributes attrs) {
        super(source, extensionName, attrs);
    }

    public static ExtensionDependency[] getDependencies(SharedCodeSource source, Attributes attributes) {
        String list;
        Object[] result = null;
        if (attributes != null && (list = attributes.getValue(Attributes.Name.EXTENSION_LIST)) != null) {
            int count = 0;
            result = new ExtensionDependency[8];
            StringTokenizer st = new StringTokenizer(list);
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                ExtensionDependency dep = new ExtensionDependency(source, name, attributes);
                result = (ExtensionDependency[])ArrayUtils.append(ExtensionDependency.class, result, count++, dep);
            }
            result = (ExtensionDependency[])ArrayUtils.trim(result, count);
        }
        return result;
    }

    public static synchronized void resolveAll(SharedCodeSource source, PolicyClassLoader loader) {
        ExtensionDependency[] deps = source.getExtensionDependencies();
        if (deps != null) {
            boolean warnIfDependencyNotSatisfied = PropertyUtils.getBooleanProperty("manifest.dependencies.warn.only", false);
            for (int i = 0; i < deps.length; ++i) {
                new ExtensionDependencyQuery(loader, deps[i], !warnIfDependencyNotSatisfied);
            }
        }
    }

    int getCompatibilityWith(ExtensionDeclaration candidate) {
        String ourID;
        if (!this.getExtensionName().equalsIgnoreCase(candidate.getExtensionName())) {
            return 1;
        }
        VersionNumber ourVersion = this.getSpecificationVersion();
        if (ourVersion != null) {
            if (!ourVersion.isValid()) {
                return 5;
            }
            VersionNumber candidateVersion = candidate.getSpecificationVersion();
            if (candidateVersion == null) {
                return 2;
            }
            if (!candidateVersion.isValid()) {
                return 5;
            }
            if (ourVersion.compare(candidateVersion) > 0) {
                return 6;
            }
        }
        if ((ourID = this.getImplementationVendorID()) != null) {
            String candidateID = candidate.getImplementationVendorID();
            if (candidateID == null) {
                return 3;
            }
            if (!ourID.equals(candidateID)) {
                return 7;
            }
        }
        if ((ourVersion = this.getImplementationVersion()) != null) {
            if (!ourVersion.isValid()) {
                return 8;
            }
            VersionNumber candidateVersion = candidate.getImplementationVersion();
            if (candidateVersion == null) {
                return 4;
            }
            if (!candidateVersion.isValid()) {
                return 8;
            }
            if (ourVersion.compare(candidateVersion) > 0) {
                return 9;
            }
        }
        return 0;
    }
}

