/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchMetrics;
import oracle.classloader.SearchPolicy;

public class DelegatingSearchPolicy
extends SearchPolicy {
    private ClassLoader delegate;

    public DelegatingSearchPolicy(String policyName, ClassLoader delegate) {
        super(policyName);
        this.delegate = delegate;
    }

    protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        try {
            return this.delegate.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChildr) {
        return this.delegate.getResource(resourceName);
    }

    public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        try {
            Enumeration<URL> e = this.delegate.getResources(resourceName);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
        return true;
    }
}

