/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.util.IdentityHashMap;
import java.util.Map;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.util.ClassLoadEnvironment;

public class ConfigurationType {
    public static final ConfigurationType JRE_BOOT_SUN_BOOT_CLASS_PATH_PROPERTY = ConfigurationType.create(ClassLoaderScope.ROOT, "system property", "", "sun.boot.class.path", false);
    public static final ConfigurationType JRE_BOOT_JAVA_LIBRARY_PATH_PROPERTY = ConfigurationType.createNative(ClassLoaderScope.ROOT, "system property", "", "java.library.path");
    public static final ConfigurationType JRE_EXTENSION_JRE_EXT_DIRS_PROPERTY = ConfigurationType.create(ClassLoaderScope.EXTENSION, "system property", "", "jre.ext.dirs", false);
    public static final ConfigurationType JRE_EXTENSION_JRE_EXT_DIRS_NATIVE_PROPERTY = ConfigurationType.createNative(ClassLoaderScope.EXTENSION, "system property", "", "jre.ext.dirs");
    public static final ConfigurationType JRE_EXTENSION_CODE_SOURCE_ELEMENT = ConfigurationType.create(ClassLoaderScope.EXTENSION, "<code-source>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), true);
    public static final ConfigurationType API_CODE_SOURCE_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<code-source>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), true);
    public static final ConfigurationType API_CODE_SOURCE_ELEMENT_NO_MANIFEST = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<code-source> (ignore manifest Class-Path)", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), false);
    public static final ConfigurationType API_IMPORT_SHARED_LIBRARY_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<import-shared-library>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), true);
    public static final ConfigurationType API_EXTENSION_LIBRARY_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "system property", "", ClassLoadEnvironment.getDefaultApiExtensionKey(), true);
    public static final ConfigurationType API_CLASS_PATH_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "system property", "", "java.class.path", true);
    public static final ConfigurationType BOOT_SHARED_CODE_SOURCE_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<code-source>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), true);
    public static final ConfigurationType BOOT_SHARED_CODE_SOURCE_ELEMENT_NO_MANIFEST = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<code-source> (ignore manifest Class-Path)", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), false);
    public static final ConfigurationType BOOT_SHARED_IMPORT_SHARED_LIBRARY_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<import-shared-library>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), true);
    public static final ConfigurationType SHARED_CODE_SOURCE_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<code-source>", "in", ClassLoadEnvironment.getDefaultSharedCodeSourceOrigin(), true);
    public static final ConfigurationType SHARED_CODE_SOURCE_ELEMENT_NO_MANIFEST = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<code-source> (ignore manifest Class-Path)", "in", ClassLoadEnvironment.getDefaultSharedCodeSourceOrigin(), false);
    public static final ConfigurationType SHARED_IMPORT_SHARED_LIBRARY_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<import-shared-library>", "in", ClassLoadEnvironment.getDefaultSharedCodeSourceOrigin(), true);
    public static final ConfigurationType MAIN_CODE_SOURCE_ELEMENT = ConfigurationType.create(ClassLoaderScope.MAIN, "<code-source>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), true);
    public static final ConfigurationType MAIN_CODE_SOURCE_ELEMENT_NO_MANIFEST = ConfigurationType.create(ClassLoaderScope.MAIN, "<code-source>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), false);
    public static final ConfigurationType MAIN_IMPORT_SHARED_LIBRARY_ELEMENT = ConfigurationType.create(ClassLoaderScope.MAIN, "<import-shared-library>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), true);
    public static final ConfigurationType MAIN_EXTENSION_LIBRARY_ELEMENT = ConfigurationType.create(ClassLoaderScope.MAIN, "system property", "", ClassLoadEnvironment.getDefaultExtensionKey(), true);
    public static final ConfigurationType MAIN_CLASS_PATH_ELEMENT = ConfigurationType.create(ClassLoaderScope.MAIN, "system property", "", "java.class.path", true);
    public static final ConfigurationType JRE_BOOT_LOADER = ConfigurationType.create(ClassLoaderScope.ROOT, "JRE", "in", "java.home", false);
    public static final ConfigurationType JRE_EXTENSION_LOADER = ConfigurationType.create(ClassLoaderScope.EXTENSION, "JRE", "in", "java.home", false);
    public static final ConfigurationType BOOT_SYSTEM_CLASS_LOADER_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<system-class-loader>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), false);
    public static final ConfigurationType BOOT_SHARED_CLASS_LOADER_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<shared-class-loader>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), false);
    public static final ConfigurationType BOOT_MAIN_CLASS_LOADER_ELEMENT = ConfigurationType.create(ClassLoaderScope.MAIN, "<main-class-loader>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), false);
    public static final ConfigurationType RAW = ConfigurationType.create(ClassLoaderScope.MAIN, "byte[]", "in", "method call", false);
    public static final ConfigurationType AUTO_IMPORTED_LOADER = ConfigurationType.create(ClassLoaderScope.GLOBAL, "Extension-List", "in", "manifest", false);
    public static final ConfigurationType INHERITED_SHARED_LIBRARIES = ConfigurationType.create(ClassLoaderScope.APPLICATION, "inherit-shared-libraries", "in", "orion-application.xml", false);
    public static final ConfigurationType API_SET_POLICY_ELEMENT = ConfigurationType.create(ClassLoaderScope.GLOBAL, "<external-classes>", "in", ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin(), false);
    public static final ConfigurationType[] JRE_BOOT = new ConfigurationType[]{JRE_BOOT_SUN_BOOT_CLASS_PATH_PROPERTY, JRE_BOOT_JAVA_LIBRARY_PATH_PROPERTY};
    public static final ConfigurationType[] JRE_EXTENSION = new ConfigurationType[]{JRE_EXTENSION_JRE_EXT_DIRS_PROPERTY, JRE_EXTENSION_JRE_EXT_DIRS_NATIVE_PROPERTY, JRE_EXTENSION_CODE_SOURCE_ELEMENT};
    public static final ConfigurationType[] API = new ConfigurationType[]{API_CODE_SOURCE_ELEMENT, API_CODE_SOURCE_ELEMENT_NO_MANIFEST, API_IMPORT_SHARED_LIBRARY_ELEMENT, API_EXTENSION_LIBRARY_ELEMENT, API_CLASS_PATH_ELEMENT};
    public static final ConfigurationType[] SHARED_BOOT = new ConfigurationType[]{BOOT_SHARED_CODE_SOURCE_ELEMENT, BOOT_SHARED_CODE_SOURCE_ELEMENT_NO_MANIFEST, BOOT_SHARED_IMPORT_SHARED_LIBRARY_ELEMENT};
    public static final ConfigurationType[] SHARED = new ConfigurationType[]{SHARED_CODE_SOURCE_ELEMENT, SHARED_CODE_SOURCE_ELEMENT_NO_MANIFEST, SHARED_IMPORT_SHARED_LIBRARY_ELEMENT};
    public static final ConfigurationType[] MAIN = new ConfigurationType[]{MAIN_CODE_SOURCE_ELEMENT, MAIN_CODE_SOURCE_ELEMENT_NO_MANIFEST, MAIN_IMPORT_SHARED_LIBRARY_ELEMENT, MAIN_EXTENSION_LIBRARY_ELEMENT, MAIN_CLASS_PATH_ELEMENT};
    public static final ConfigurationType[] NO_CODE_SOURCES = new ConfigurationType[0];
    private static Map manifestTypes;
    private static int nextID;
    private ClassLoaderScope scope;
    private String name;
    private String relationToContext;
    private String exampleContext;
    private boolean checkManifest;
    private boolean isNative;
    private int id;

    protected static ConfigurationType create(ClassLoaderScope scope, String name, String relationToContext, String exampleContext, boolean checkManifest) {
        return new ConfigurationType(scope, name, relationToContext, exampleContext, checkManifest, false);
    }

    protected static ConfigurationType createNative(ClassLoaderScope scope, String name, String relationToContext, String exampleContext) {
        return new ConfigurationType(scope, name, relationToContext, exampleContext, false, true);
    }

    private ConfigurationType(ClassLoaderScope scope, String name, String relationToContext, String exampleContext, boolean checkManifest, boolean isNative) {
        this.scope = scope;
        this.name = name;
        this.relationToContext = relationToContext;
        this.exampleContext = exampleContext;
        this.checkManifest = checkManifest;
        this.isNative = isNative;
        if (nextID == 0) {
            nextID = 1;
        }
        this.id = nextID++;
    }

    protected ConfigurationType() {
    }

    ConfigurationType getManifestType() {
        return (ConfigurationType)manifestTypes.get(this.scope);
    }

    int getID() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public ClassLoaderScope getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.toString();
    }

    public String getRelationToContext() {
        return this.relationToContext;
    }

    public String getExampleContext() {
        return this.exampleContext;
    }

    public boolean shouldManifestBeChecked() {
        return this.checkManifest;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public String toString() {
        return this.name + " (e.g. " + this.exampleContext + ")";
    }

    static void createManifestTypeFor(ClassLoaderScope scope) {
        ConfigurationType type = new ConfigurationType(scope, "manifest", "of", ".jar file", true, false);
        if (manifestTypes == null) {
            manifestTypes = new IdentityHashMap();
        }
        manifestTypes.put(scope, type);
    }
}

