/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import oracle.classloader.ConfigurationType;
import oracle.classloader.util.ClassLoadEnvironment;

public class ClassLoaderScope
implements Comparable {
    public static final int ROOT_LEVEL = 0;
    public static final ClassLoaderScope ROOT = new ClassLoaderScope(0, "JRE: Bootstrap");
    public static final ClassLoaderScope EXTENSION = new ClassLoaderScope(ROOT.getLevel() + 1, "JRE: Extensions");
    public static final ClassLoaderScope GLOBAL = new ClassLoaderScope(EXTENSION.getLevel() + 1, "Global: API & Shared");
    public static final ClassLoaderScope APPLICATION = new ClassLoaderScope(GLOBAL.getLevel() + 1, "Application");
    public static final ClassLoaderScope MAIN = new ClassLoaderScope(ClassLoadEnvironment.getMainScopeLevel(), "MAIN: Implementation");
    private String name;
    private int level;

    protected ClassLoaderScope(int level, String name) {
        this.level = level;
        this.name = name;
        ConfigurationType.createManifestTypeFor(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.level == 0;
    }

    public boolean isApplication() {
        return this == APPLICATION;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object o) {
        return this.compareTo((ClassLoaderScope)o);
    }

    public int compareTo(ClassLoaderScope other) {
        if (this.level < other.level) {
            return -1;
        }
        if (this.level == other.level) {
            return 0;
        }
        return 1;
    }
}

