/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.classloader.ClassLoaderFilter;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.ClassPathAccessor;
import oracle.classloader.ClassPathListAccessor;
import oracle.classloader.CodeSourceListAccessor;
import oracle.classloader.CodeSourceVisitor;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ExtensionDeclaration;
import oracle.classloader.FindVisitedLoaders;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.PolicyClassLoaderSet;
import oracle.classloader.ResourceAccessor;
import oracle.classloader.ResourceDataAccessor;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceSet;
import oracle.classloader.SubscriberSet;
import oracle.classloader.query.ReportQuery;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassDependencies;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.FileUtils;
import oracle.classloader.util.InitialLoadersFactory;
import oracle.classloader.util.LoadedClasses;
import oracle.classloader.util.LoadedPackages;
import oracle.classloader.util.URLParseUtil;
import oracle.classloader.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoaderQuery
extends ReportQuery {
    private static PolicyClassLoader rootLoader;
    private static PolicyClassLoader apiLoader;
    private static PolicyClassLoader mainLoader;
    private static PolicyClassLoader systemLoader;
    private static List internalClassPath;
    private static int apiVersion;

    public static List getInternalClassPath() {
        return internalClassPath;
    }

    public static int getAPIVersion() {
        return apiVersion;
    }

    public static File getHomeDirectory() {
        return InitialLoadersFactory.getHomeDirectory();
    }

    public static SharedCodeSource getFrameworkCodeSource() {
        return InitialLoadersFactory.getFrameworkCodeSource();
    }

    public static PolicyClassLoader getRootLoader() {
        if (rootLoader == null) {
            rootLoader = ClassLoaderQuery.findLatestLoader(ClassLoadEnvironment.getRootLoaderName());
        }
        return rootLoader;
    }

    public static PolicyClassLoader getAPILoader() {
        if (apiLoader == null) {
            apiLoader = ClassLoaderQuery.findLatestLoader(ClassLoadEnvironment.getAPILoaderName());
        }
        return apiLoader;
    }

    public static PolicyClassLoader getMainLoader() {
        if (mainLoader == null) {
            mainLoader = ClassLoaderQuery.findLatestLoader(ClassLoadEnvironment.getMainLoaderName());
        }
        return mainLoader;
    }

    public static void setSystemLoader(PolicyClassLoader system) {
        systemLoader = system;
    }

    public static PolicyClassLoader getSystemLoader() {
        return systemLoader;
    }

    public static List getAllLoaders() {
        return PolicyClassLoaderSet.getAllLoaders(null);
    }

    public static List getAllLoaders(ClassLoaderFilter filter) {
        return PolicyClassLoaderSet.getAllLoaders(filter);
    }

    public static PolicyClassLoader findLatestLoader(String name) {
        return PolicyClassLoaderSet.find(name, null, null);
    }

    public static PolicyClassLoader findLoader(String name) {
        String loaderName = name;
        VersionNumber version = null;
        int index = name.indexOf(58);
        if (index >= 0) {
            loaderName = name.substring(0, index);
            version = new VersionNumber(name.substring(index + 1), false, true);
        }
        return PolicyClassLoaderSet.find(loaderName, version, version);
    }

    public static PolicyClassLoader[] findLoaders(String name) {
        return PolicyClassLoaderSet.findAll(name);
    }

    public static PolicyClassLoader findLoader(String name, VersionNumber minVersion, VersionNumber maxVersion) {
        return PolicyClassLoaderSet.find(name, minVersion, maxVersion);
    }

    public static List findLoadersVisitedBy(PolicyClassLoader loader) {
        FindVisitedLoaders visitor = new FindVisitedLoaders();
        ClassLoaderQuery.visitLoadersInSearchOrder(loader, visitor);
        return visitor.getVisitedLoaders();
    }

    public static List findLoadersNotVisitedBy(PolicyClassLoader loader) {
        List visited = ClassLoaderQuery.findLoadersVisitedBy(loader);
        return ClassLoaderQuery.findAllLoadersNotInList(visited);
    }

    public static List findAllLoadersNotInList(final List loaders) {
        ClassLoaderFilter filter = new ClassLoaderFilter(){

            public boolean match(PolicyClassLoader loader) {
                return !loaders.contains(loader);
            }
        };
        return ClassLoaderQuery.getAllLoaders(filter);
    }

    public static SharedCodeSource findCodeSource(String codeSourcePath) {
        return ClassLoaderQuery.findCodeSource(new File(URLParseUtil.decode(codeSourcePath)));
    }

    public static SharedCodeSource findCodeSource(File codeSource) {
        URL url;
        File file = FileUtils.getCanonicalFile(codeSource);
        try {
            url = FileUtils.toURL(file);
        }
        catch (MalformedURLException ex) {
            return null;
        }
        return SharedCodeSourceSet.find(url.getPath());
    }

    public static SharedCodeSource[] findCodeSourcesNotVisitedBy(List visitedLoaders) {
        HashSet allCodeSources = new HashSet();
        ClassLoaderQuery.addAllCodeSources(allCodeSources);
        for (PolicyClassLoader loader : visitedLoaders) {
            SharedCodeSource[] sources = loader.getCodeSourcesWhileAnalyzingFailure(true);
            for (int i = 0; i < sources.length; ++i) {
                allCodeSources.remove(sources[i]);
            }
        }
        return (SharedCodeSource[])ArrayUtils.toArray(SharedCodeSource.class, allCodeSources, true);
    }

    public static PolicyClassLoader findSharedLoader(String name, VersionNumber minVersion, VersionNumber maxVersion) {
        PolicyClassLoader result = PolicyClassLoaderSet.find(name, minVersion, maxVersion);
        if (result != null && !result.isSharedLoader()) {
            result = null;
        }
        return result;
    }

    public static PolicyClassLoader[] getSystemSharedLoaders(final boolean includePrivate) {
        ClassLoaderFilter filter = new ClassLoaderFilter(){

            public boolean match(PolicyClassLoader loader) {
                if (loader.isSystemSharedLoader()) {
                    return includePrivate ? true : !loader.isPrivateSystemSharedLoader();
                }
                return false;
            }
        };
        List list = ClassLoaderQuery.getAllLoaders(filter);
        return (PolicyClassLoader[])ArrayUtils.toArray(PolicyClassLoader.class, list, true);
    }

    public static Class loadClassFromThreadOrMainLoader(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException ex) {
            if (ClassLoaderQuery.getMainLoader() != null) {
                clazz = Class.forName(className, true, ClassLoaderQuery.getMainLoader());
            }
            throw ex;
        }
        return clazz;
    }

    public static Class loadClassFromUserDefinedOrMainLoader(String className, Class callerClass, ClassLoader userDefinedLoader) throws ClassNotFoundException {
        ClassNotFoundException origEx = null;
        try {
            if (userDefinedLoader != null) {
                return Class.forName(className, true, userDefinedLoader);
            }
            if (callerClass.getClassLoader() != null) {
                return Class.forName(className, true, callerClass.getClassLoader());
            }
        }
        catch (ClassNotFoundException ex) {
            origEx = ex;
        }
        if (ClassLoaderQuery.getMainLoader() != null) {
            return Class.forName(className, true, ClassLoaderQuery.getMainLoader());
        }
        if (origEx != null) {
            throw origEx;
        }
        throw new ClassNotFoundException(className);
    }

    public static boolean isSystemSharedLoader(String loaderName, String loaderVersion) {
        VersionNumber vn = new VersionNumber(loaderVersion);
        PolicyClassLoader loader = ClassLoaderQuery.findLoader(loaderName, vn, vn);
        if (loader != null) {
            return loader.isSystemSharedLoader();
        }
        return false;
    }

    public static VersionNumber getNextUnusedVersionFor(String loaderName) {
        PolicyClassLoader latest = PolicyClassLoaderSet.find(loaderName, null, null);
        if (latest != null) {
            return ClassLoaderQuery.next(latest.getVersionNumber());
        }
        return VersionNumber.ZERO;
    }

    public static List getAllCodeSources() {
        return SharedCodeSourceSet.getAllCodeSources();
    }

    public static List getAllCodeSourcesInScope(ClassLoaderScope scope) {
        List sources = ClassLoaderQuery.getAllCodeSources();
        ClassLoaderQuery.removeCodeSourcesAboveScope(scope, sources);
        return sources;
    }

    public static void removeCodeSourcesAboveScope(ClassLoaderScope scope, List sources) {
        int scopeLevel = scope.getLevel();
        Iterator iterator = sources.iterator();
        while (iterator.hasNext()) {
            SharedCodeSource cs = (SharedCodeSource)iterator.next();
            ClassLoaderScope csScope = cs.getSubscribers().getMinimumScope();
            if (csScope == null || csScope.getLevel() >= scopeLevel) continue;
            iterator.remove();
        }
    }

    public static void addAllCodeSources(Collection collection) {
        SharedCodeSourceSet.addAllCodeSources(collection);
    }

    public static List getCodeSourcesVisibleTo(PolicyClassLoader initialLoader, boolean includeManifestSources) {
        ArrayList list = new ArrayList();
        CodeSourceListAccessor accessor = new CodeSourceListAccessor(list, includeManifestSources);
        initialLoader.visitUsingPolicy(accessor, true, false);
        return list;
    }

    public static Map getAllExtensionDeclarations() {
        return ExtensionDeclaration.getDeclarations();
    }

    public static String getFirstOriginDescriptionFor(Class clz) {
        String result = "unknown";
        if (clz != null) {
            try {
                CodeSource cs = clz.getProtectionDomain().getCodeSource();
                if (cs == null) {
                    if (clz.getClassLoader() == null) {
                        result = "jre bootstrap";
                    }
                } else {
                    String path = cs.getLocation().getPath();
                    SharedCodeSource scs = SharedCodeSourceSet.find(path);
                    if (scs != null) {
                        PolicyClassLoader loader = ClassLoaderQuery.getLoaderFor(clz);
                        result = ClassLoaderQuery.getFirstOrigin(scs, loader).toString();
                    } else {
                        result = path;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return result;
    }

    public static SharedCodeSource getCodeSourceFor(Class clz) {
        if (clz != null) {
            try {
                CodeSource cs = clz.getProtectionDomain().getCodeSource();
                if (cs != null) {
                    String path = cs.getLocation().getPath();
                    return SharedCodeSourceSet.find(path);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public static URL getCodeSourceLocationFor(Class clz) {
        if (clz != null) {
            try {
                CodeSource cs = clz.getProtectionDomain().getCodeSource();
                if (cs != null) {
                    return cs.getLocation();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCodeSourcePathFor(Class clz, String defaultResult) {
        if (clz != null) {
            return ClassLoaderQuery.getCodeSourcePath(clz.getProtectionDomain().getCodeSource(), defaultResult);
        }
        return defaultResult;
    }

    public static String getPath(URL url) throws UnsupportedEncodingException {
        String path = url.getPath();
        int firstEscape = path.indexOf(37);
        if (firstEscape >= 0) {
            path = URLDecoder.decode(path, "UTF-8");
        }
        return path;
    }

    private static String getCodeSourcePath(CodeSource cs, String defaultResult) {
        if (cs != null) {
            try {
                return ClassLoaderQuery.getPath(cs.getLocation());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultResult;
    }

    public static File getCodeSourceFileFor(Class clz) {
        String path = ClassLoaderQuery.getCodeSourcePathFor(clz, null);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    public static String getCodeSourceDescriptionFor(Class clz) {
        String result = "unknown";
        if (clz != null) {
            try {
                CodeSource cs = clz.getProtectionDomain().getCodeSource();
                if (cs == null) {
                    if (clz.getClassLoader() == null) {
                        result = "jre bootstrap";
                    }
                } else {
                    String path = cs.getLocation().getPath();
                    SharedCodeSource scs = SharedCodeSourceSet.find(path);
                    result = scs != null ? scs.toString() : path;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return result;
    }

    public static PolicyClassLoader getLoaderFor(Class clz) {
        PolicyClassLoader result = null;
        if (clz != null) {
            ClassLoader loader = clz.getClassLoader();
            if (loader == null) {
                result = ClassLoaderQuery.getRootLoader();
            } else if (loader instanceof PolicyClassLoader) {
                result = (PolicyClassLoader)loader;
            }
        }
        return result;
    }

    public static boolean isAncestor(ClassLoader potentialAncestor, ClassLoader loader) {
        for (ClassLoader current = loader; current != null; current = current.getParent()) {
            if (current != potentialAncestor) continue;
            return true;
        }
        return false;
    }

    public static String getLoaderNameFor(Class clz) {
        return ClassLoaderQuery.getLoaderNameFor(clz, ClassLoaderQuery.getLoaderFor(clz));
    }

    public static String getLoaderNameFor(Class clz, PolicyClassLoader policyLoader) {
        if (clz != null) {
            if (policyLoader == null) {
                ClassLoader loader = clz.getClassLoader();
                if (loader == null) {
                    return ClassLoadEnvironment.getRootLoaderName();
                }
                return loader.getClass().getName() + "@" + System.identityHashCode(loader);
            }
            return policyLoader.getUniqueName();
        }
        return "unknown";
    }

    public static String getDisplayNameFor(ClassLoader loader, boolean addIdentityHash) {
        String result;
        if (loader instanceof PolicyClassLoader) {
            result = ((PolicyClassLoader)loader).getDisplayName();
        } else {
            result = loader.getClass().getName();
            addIdentityHash = true;
        }
        if (addIdentityHash) {
            result = result + "@" + Integer.toHexString(System.identityHashCode(loader));
        }
        return result;
    }

    public static ConfigurationOrigin[] getOrigins(SharedCodeSource source, PolicyClassLoader loader) {
        SubscriberSet set = source.getSubscribers();
        return set.getOriginsFor(loader);
    }

    public static ConfigurationOrigin getFirstOrigin(SharedCodeSource source, PolicyClassLoader loader) {
        SubscriberSet set = source.getSubscribers();
        return set.getFirstOriginFor(loader);
    }

    public static String getFirstOriginDescription(SharedCodeSource source, PolicyClassLoader loader) {
        ConfigurationOrigin origin = ClassLoaderQuery.getFirstOrigin(source, loader);
        if (origin != null) {
            return origin.toString();
        }
        return "unknown";
    }

    public static Map getLoadedPackages(ClassLoader loader) {
        return LoadedPackages.getPackagesLoadedBy(loader);
    }

    public static List getLoadedClasses(ClassLoader loader) {
        return LoadedClasses.getClassesLoadedBy(loader);
    }

    public static List getDependencies(Class clz) throws IOException {
        return ClassDependencies.getDependencies(clz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getDependencies(String className, PolicyClassLoader loader) throws IOException {
        List result = null;
        String path = className.replace('.', '/').concat(".class");
        InputStream stream = loader.getResourceAsStream(path);
        if (stream != null) {
            try {
                result = ClassDependencies.getDependencies(stream);
            }
            finally {
                stream.close();
            }
        }
        return result;
    }

    public static List getDependencies(String className, ClassLoader loader, boolean recurse, String[] ignorePackages) throws IOException {
        return ClassDependencies.getDependencies(className, loader, recurse, ignorePackages);
    }

    public static void visitLoadersInSearchOrder(PolicyClassLoader initialLoader, ClassLoaderVisitor visitor) {
        initialLoader.visitUsingPolicy(visitor, true, false);
    }

    public static void visitCodeSourcesInSearchOrder(PolicyClassLoader initialLoader, final CodeSourceVisitor visitor, boolean visitNonSharedParents, final boolean includeManifestSources) {
        initialLoader.visitUsingPolicy(new ClassLoaderVisitor(){

            public boolean visit(PolicyClassLoader loader) {
                return loader.visitCodeSources(visitor, includeManifestSources);
            }
        }, visitNonSharedParents, false);
    }

    public static String getClassPath(PolicyClassLoader initialLoader) {
        return ClassLoaderQuery.getClassPath(initialLoader, true);
    }

    public static String getFullClassPath(PolicyClassLoader initialLoader) {
        String cp = ClassLoaderQuery.getClassPath(initialLoader);
        return ClassLoaderQuery.appendInternalClassPathIfNotMainLoader(cp);
    }

    public static String appendInternalClassPathIfNotMainLoader(String cp) {
        if (ClassLoaderQuery.getSystemLoader() != ClassLoaderQuery.getMainLoader()) {
            StringBuffer buff = new StringBuffer();
            buff.append(cp);
            List list = ClassLoaderQuery.getInternalClassPath();
            for (int i = 0; i < list.size(); ++i) {
                SharedCodeSource codeSource;
                String path = (String)list.get(i);
                if (path == null || (codeSource = ClassLoaderQuery.findCodeSource(path)) == null) continue;
                buff.append(File.pathSeparatorChar + codeSource.getLocation().getPath());
            }
            return buff.toString();
        }
        return cp;
    }

    public static String getClassPath(PolicyClassLoader initialLoader, boolean includeManifestSources) {
        StringBuffer buffer = new StringBuffer(4096);
        ClassLoaderQuery.appendClassPath(initialLoader, true, includeManifestSources, buffer);
        return buffer.toString();
    }

    public static List getClassPathAsList(PolicyClassLoader initialLoader, boolean includeManifestSources) {
        ArrayList list = new ArrayList();
        ClassPathListAccessor accessor = new ClassPathListAccessor(list, includeManifestSources);
        initialLoader.visitUsingPolicy(accessor, true, false);
        return list;
    }

    public static String getLocalClassPath(PolicyClassLoader loader) {
        StringBuffer buffer = new StringBuffer(4096);
        ClassLoaderQuery.appendClassPath(loader, false, false, buffer);
        return buffer.toString();
    }

    public static void appendClassPath(PolicyClassLoader initialLoader, boolean visitNonSharedParents, boolean includeManifestSources, StringBuffer buffer) {
        ClassPathAccessor accessor = new ClassPathAccessor(buffer, includeManifestSources);
        initialLoader.visitUsingPolicy(accessor, visitNonSharedParents, false);
    }

    public static SharedCodeSource getCodeSource(PolicyClassLoader loader, boolean visitNonSharedParents, String resourcePath) {
        ResourceAccessor accessor = new ResourceAccessor(resourcePath, true);
        loader.visitUsingPolicy(accessor, visitNonSharedParents, false);
        return accessor.getCodeSource();
    }

    public static File getResourceAsFile(PolicyClassLoader loader, boolean visitNonSharedParents, String resourcePath) {
        SharedCodeSource source = ClassLoaderQuery.getCodeSource(loader, visitNonSharedParents, resourcePath);
        if (source != null) {
            try {
                return source.getFile(resourcePath);
            }
            catch (IOException e) {
                ClassLoadLogger.logException("Unable to access code-source: " + source + ".", e, false);
            }
        }
        return null;
    }

    public static ResourceDataAccessor getResource(PolicyClassLoader loader, boolean visitNonSharedParents, String resourcePath) {
        ResourceDataAccessor accessor = new ResourceDataAccessor(resourcePath, true);
        loader.visitUsingPolicy(accessor, visitNonSharedParents, false);
        if (accessor.getCodeSource() != null) {
            return accessor;
        }
        return null;
    }

    public static boolean isImportedBy(PolicyClassLoader sharedLibrary, PolicyClassLoader loader) {
        SubscriberSet subs = sharedLibrary.getSubscribers();
        return subs.containsSubscriber(loader);
    }

    public static String getApplicationName(PolicyClassLoader loader) {
        String name;
        int firstDot;
        String result = null;
        if (loader.isApplicationLoader() && (firstDot = (name = loader.getName()).indexOf(46)) >= 0) {
            result = name.substring(0, firstDot);
        }
        return result;
    }

    public static int getCategory(PolicyClassLoader loader) {
        return loader.getConfigurationPolicy().getCategory();
    }

    public static String getCategoryName(PolicyClassLoader loader) {
        return loader.getConfigurationPolicy().getCategoryName();
    }

    public static VersionNumber next(VersionNumber vn) {
        return new VersionNumber(vn.getVersionAt(0), vn.getVersionAt(1), vn.getVersionAt(2) + 1, vn.getVersionAt(3), vn.getVersionAt(4));
    }

    public static void reset() {
        rootLoader = null;
        apiLoader = null;
        mainLoader = null;
        systemLoader = null;
    }

    public static Map<String, Class> getExternalClasses() {
        return SearchPolicy.getExternalClasses();
    }

    static {
        internalClassPath = new ArrayList();
        apiVersion = 1;
    }
}

