/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.tasks;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.standalone.tasks.Messages;
import oracle.dbtools.raptor.standalone.tasks.TaskProgressDockable;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;

public class TaskProgressAddin
implements Addin,
DockableFactory {
    private int _viewActionId;
    private TaskProgressDockable _dockable;

    public Dockable getDockable(ViewId viewId) {
        return this.getQueryProgressDockable();
    }

    private TaskProgressDockable getQueryProgressDockable() {
        if (this._dockable == null) {
            this._dockable = new TaskProgressDockable();
        }
        return this._dockable;
    }

    public void install() {
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(3);
        DockStation dockStation = DockStation.getDockStation();
        dockStation.dock((Dockable)this.getQueryProgressDockable(), dockingParam);
    }

    public void initialize() {
        this.createActions();
        try {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory("TASK_PROGRESS_VIEW_TYPE", (DockableFactory)this);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.linkWithIDEStatusBar();
    }

    private void linkWithIDEStatusBar() {
        JComponent jComponent = Ide.getStatusBar().getGUI();
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DockUtil.showDockableWindow((DockableView)TaskProgressAddin.this.getQueryProgressDockable());
                }
            }
        };
        ContainerListener containerListener = new ContainerListener(){

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
            }

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                if (containerEvent.getChild() instanceof JProgressBar) {
                    containerEvent.getChild().addMouseListener(mouseAdapter);
                }
            }
        };
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).addContainerListener(containerListener);
        }
    }

    private void createActions() {
        this._viewActionId = Ide.findOrCreateCmdID((String)"TaskProgressCmdId");
        String string = Messages.getString("TaskProgress.1");
        IdeAction ideAction = IdeAction.get((int)this._viewActionId, null, (String)StringUtils.stripMnemonic((String)string), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)StringUtils.getMnemonicKeyCode((String)string), (Icon)RaptorImagesArb.getIcon((String)"TASK_PROGRESS"), null, (boolean)true);
        ideAction.addController((Controller)new SController());
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_COMPONENT_PALETTE + 0.001f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"));
    }

    private class SController
    implements Controller {
        private SController() {
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n != TaskProgressAddin.this._viewActionId) {
                return false;
            }
            DockUtil.showDockableWindow((DockableView)TaskProgressAddin.this.getQueryProgressDockable());
            return true;
        }
    }
}

