/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.raptor.ExtrasMessages;
import oracle.dbtools.raptor.RaptorExtrasResources;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.folders.DatabasesFilter;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.FolderNamePanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.javatools.dialogs.MessageDialog;

public class DatabasesFoldersController
implements Controller {
    public static final String CONNECTION_CATEGORY = "DatabaseNavigator.CategorizeConnection";
    public static final int CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.CategorizeConnection");
    public static final String NEW_CONNECTION_CATEGORY = "DatabaseNavigator.NewCategory";
    public static final int NEW_CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewCategory");
    public static final String REMOVE_CONNECTION_CATEGORY = "DatabaseNavigator.RemoveCategory";
    public static final int REMOVE_CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RemoveCategory");
    public static final String REMOVE_FROM_FOLDER = "DatabaseNavigator.RemoveConnFromFolder";
    public static final int REMOVE_FROM_FOLDER_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RemoveConnFromFolder");
    public static final String RENAME_CONNECTION_CATEGORY = "DatabaseNavigator.RenameCategory";
    public static final int RENAME_CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RenameCategory");
    public static final String DISCONNECT_CONNECTION_FROM_FOLDER = "DatabaseNavigator.Disconn_Database";
    public static final int DISCONNECT_CONNECTION_FROM_FOLDER_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.Disconn_Database");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        Element[] elementArray = context.getSelection();
        if (NEW_CONNECTION_CATEGORY_ID == n) {
            TNode tNode = ExplorerContext.getFirstTNode((Context)context);
            TNode tNode2 = tNode.getAncestorTNode(Databases.class, false);
            DatabasesFilter databasesFilter = (DatabasesFilter)tNode2.getChildFilter();
            String[] stringArray = databasesFilter.getFolderNames();
            String string = this.getFolderName(stringArray, null);
            if (string != null) {
                databasesFilter.updateFolder(string, elementArray);
            }
            return true;
        }
        if (REMOVE_FROM_FOLDER_ID == n) {
            TNode tNode = ExplorerContext.getFirstTNode((Context)context);
            TNode tNode3 = tNode.getAncestorTNode(Databases.class, false);
            DatabasesFilter databasesFilter = (DatabasesFilter)tNode3.getChildFilter();
            databasesFilter.updateFolder(null, elementArray);
        } else if (RENAME_CONNECTION_CATEGORY_ID == n) {
            DatabasesFolder databasesFolder = (DatabasesFolder)elementArray[0];
            TNode tNode = ExplorerContext.getFirstTNode((Context)context);
            TNode tNode4 = tNode.getAncestorTNode(Databases.class, false);
            DatabasesFilter databasesFilter = (DatabasesFilter)tNode4.getChildFilter();
            String[] stringArray = databasesFilter.getFolderNames();
            String string = this.getFolderName(stringArray, databasesFolder.getName());
            if (string != null) {
                databasesFilter.renameFolder(databasesFolder.getName(), string);
            }
        } else if (REMOVE_CONNECTION_CATEGORY_ID == n) {
            DatabasesFolder databasesFolder = (DatabasesFolder)elementArray[0];
            TNode tNode = ExplorerContext.getFirstTNode((Context)context);
            TNode tNode5 = tNode.getAncestorTNode(Databases.class, false);
            DatabasesFilter databasesFilter = (DatabasesFilter)tNode5.getChildFilter();
            databasesFilter.removeFolder(databasesFolder.getName());
        } else if (n == DISCONNECT_CONNECTION_FROM_FOLDER_ID) {
            if (elementArray[0] instanceof Databases) {
                RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>("Disconnect Connections", false, IRaptorTaskRunMode.TASKVIEWER){

                    protected Boolean doWork() throws TaskException {
                        String[] stringArray = Connections.getInstance().getConnNames();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!Connections.getInstance().isConnectionOpen(stringArray[i])) continue;
                            Connections.getInstance().closeConnection(stringArray[i], true);
                        }
                        return true;
                    }
                };
                raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)RaptorExtrasResources.getString("CONN_CLOSED_LABEL"), null, null);
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            } else if (elementArray[0] instanceof DatabasesFolder) {
                final DatabasesFolder databasesFolder = (DatabasesFolder)elementArray[0];
                RaptorTask<Boolean> raptorTask = new RaptorTask<Boolean>("Disconnect Connections", false, IRaptorTaskRunMode.TASKVIEWER){

                    protected Boolean doWork() throws TaskException {
                        Iterator iterator = databasesFolder.getChildren();
                        while (iterator.hasNext()) {
                            String string = ((DatabaseConnection)iterator.next()).getQualifiedConnectionName();
                            if (!Connections.getInstance().isConnectionOpen(string)) continue;
                            Connections.getInstance().closeConnection(string, true);
                        }
                        return true;
                    }
                };
                raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(RaptorExtrasResources.getString("CONNS_CLOSED_MESSAGE"), databasesFolder.getName()), null, null);
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            }
        }
        return false;
    }

    private String getFolderName(String[] stringArray, String string) {
        FolderNamePanel folderNamePanel = new FolderNamePanel();
        Namespace namespace = new Namespace();
        namespace.put("FolderName", (Object)string);
        namespace.put("OtherFolderNames", (Object)stringArray);
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), ExtrasMessages.getString("DatabasesFoldersController.5"), (Traversable)folderNamePanel, namespace);
        tDialogLauncher.setPackDialog(true);
        tDialogLauncher.initDialog();
        string = tDialogLauncher.showDialog() ? (String)namespace.find("FolderName") : null;
        return string;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }
}

