/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryCategory;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryItem;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class SummaryPageMigration
extends DefaultTraversablePanel {
    private SummaryCategory _root;
    private SummaryTreeTable tt;
    private HashSet<String> expTp = new HashSet();

    SummaryPageMigration() {
        this.initGUI();
    }

    public void onEntry(TraversableContext traversableContext) {
        SummaryTreeTableModel summaryTreeTableModel = this.createModel();
        this.tt.getTree().setModel((TreeModel)((Object)summaryTreeTableModel));
        this.expandTree(this.tt.getTree());
        this.tt.revalidate();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
    }

    private void expandTree(JTree jTree) {
        TreePath treePath = null;
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            treePath = jTree.getPathForRow(i);
            int n = treePath.getPathCount();
            if (n >= 3 && !this.expTp.contains(treePath.toString())) continue;
            jTree.expandRow(i);
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        SummaryTreeTableModel summaryTreeTableModel = this.createBaseModel();
        this.tt = new SummaryTreeTable(summaryTreeTableModel);
        JTree jTree = this.tt.getTree();
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                SummaryPageMigration.this.expTp.add(treeExpansionEvent.getPath().toString());
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                SummaryPageMigration.this.expTp.remove(treeExpansionEvent.getPath().toString());
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.tt));
        jScrollPane.getViewport().setBackground(this.tt.getBackground());
        this.add(jScrollPane);
    }

    private SummaryTreeTableModel createBaseModel() {
        this._root = new SummaryCategory("root", null);
        SummaryTreeTableModel summaryTreeTableModel = new SummaryTreeTableModel(this._root);
        return summaryTreeTableModel;
    }

    private SummaryTreeTableModel createModel() {
        this._root = new SummaryCategory("root", null);
        this._root.addChild(this.projectCategory());
        this._root.addChild(this.repositoryCategory());
        this._root.addChild(this.actionsCategory());
        SummaryTreeTableModel summaryTreeTableModel = new SummaryTreeTableModel(this._root);
        return summaryTreeTableModel;
    }

    SummaryCategory projectCategory() {
        SummaryCategory summaryCategory = null;
        SummaryProvider summaryProvider = QMWizard.ContextHelper.getProjectSummaryProvider(QMWizard.PROJ_PAGE_ID);
        summaryCategory = (SummaryCategory)summaryProvider.getSummary(null);
        return summaryCategory;
    }

    SummaryCategory repositoryCategory() {
        SummaryCategory summaryCategory = null;
        SummaryProvider summaryProvider = QMWizard.ContextHelper.getProjectSummaryProvider(QMWizard.REPO_PAGE_ID);
        summaryCategory = (SummaryCategory)summaryProvider.getSummary(null);
        return summaryCategory;
    }

    SummaryCategory actionsCategory() {
        SummaryCategory summaryCategory = null;
        SummaryCategory summaryCategory2 = null;
        SummaryCategory summaryCategory3 = null;
        SummaryCategory summaryCategory4 = null;
        SummaryCategory summaryCategory5 = null;
        SummaryProvider summaryProvider = null;
        summaryCategory5 = new SummaryCategory(QMWizardArb.getString("Actions"), null);
        if (QMWizard.ContextHelper.isActiveCommitPage(QMWizard.REPO_PAGE_ID)) {
            summaryProvider = QMWizard.ContextHelper.getProjectSummaryProvider(QMWizard.REPO_PAGE_ID);
            summaryCategory5 = (SummaryCategory)summaryProvider.getSummary(summaryCategory5);
        }
        if (QMWizard.ContextHelper.isActiveCommitPage(QMWizard.PROJ_PAGE_ID)) {
            summaryProvider = QMWizard.ContextHelper.getProjectSummaryProvider(QMWizard.PROJ_PAGE_ID);
            summaryCategory5 = (SummaryCategory)summaryProvider.getSummary(summaryCategory5);
        }
        if (QMWizard.ContextHelper.isActiveCommitPage(QMWizard.CAPT_PAGE_ID)) {
            summaryCategory2 = new SummaryCategory(QMWizardArb.getString("STEP4"), null);
            summaryProvider = QMWizard.ContextHelper.getProjectSummaryProvider(QMWizard.SRCDB_PAGE_ID);
            summaryCategory2 = (SummaryCategory)summaryProvider.getSummary(summaryCategory2);
            summaryProvider = QMWizard.ContextHelper.getProjectSummaryProvider(QMWizard.CAPT_PAGE_ID);
            summaryCategory2 = (SummaryCategory)summaryProvider.getSummary(summaryCategory2);
            summaryCategory5.addChild(summaryCategory2);
        }
        if (QMWizard.ContextHelper.isActiveCommitPage(QMWizard.CONV_PAGE_ID)) {
            summaryCategory = new SummaryCategory(QMWizardArb.getString("STEP5"), null);
            summaryProvider = QMWizard.ContextHelper.getProjectSummaryProvider(QMWizard.CONV_PAGE_ID);
            summaryCategory = (SummaryCategory)summaryProvider.getSummary(summaryCategory);
            summaryCategory5.addChild(summaryCategory);
        }
        if (QMWizard.ContextHelper.isActiveCommitPage(QMWizard.TGTDB_PAGE_ID)) {
            summaryCategory3 = new SummaryCategory(QMWizardArb.getString("STEP6"), null);
            summaryProvider = QMWizard.ContextHelper.getProjectSummaryProvider(QMWizard.TGTDB_PAGE_ID);
            summaryCategory3 = (SummaryCategory)summaryProvider.getSummary(summaryCategory3);
            summaryCategory5.addChild(summaryCategory3);
        }
        if (QMWizard.ContextHelper.isActiveCommitPage(QMWizard.MVDAT_PAGE_ID)) {
            summaryCategory4 = new SummaryCategory(QMWizardArb.getString("STEP8"), null);
            summaryProvider = QMWizard.ContextHelper.getProjectSummaryProvider(QMWizard.MVDAT_PAGE_ID);
            summaryCategory4 = (SummaryCategory)summaryProvider.getSummary(summaryCategory4);
            summaryCategory5.addChild(summaryCategory4);
        }
        return summaryCategory5;
    }

    class SummaryTreeTableModel
    extends AbstractTreeTableModel {
        public SummaryTreeTableModel(SummaryCategory summaryCategory) {
            super((Object)summaryCategory);
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return "";
        }

        public Object getValueAt(Object object, int n) {
            String string = null;
            if (object instanceof SummaryItem) {
                SummaryItem summaryItem = (SummaryItem)object;
                string = n == 0 ? summaryItem.getName() : summaryItem.getValue();
            }
            return string;
        }

        public Object getChild(Object object, int n) {
            SummaryItem summaryItem = null;
            if (object instanceof SummaryCategory) {
                SummaryCategory summaryCategory = (SummaryCategory)object;
                summaryItem = summaryCategory.getChildAt(n);
            }
            return summaryItem;
        }

        public int getChildCount(Object object) {
            int n = 0;
            if (object instanceof SummaryCategory) {
                SummaryCategory summaryCategory = (SummaryCategory)object;
                n = summaryCategory.getChildCount();
            }
            return n;
        }

        public Class<?> getColumnClass(int n) {
            return n == 0 ? TreeTableModel.class : String.class;
        }
    }

    class SummaryTreeTable
    extends JFastTreeTable {
        SummaryTreeTable(SummaryTreeTableModel summaryTreeTableModel) {
            super((TreeTableModel)summaryTreeTableModel);
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.setAutoResizeMode(1);
            this.setSelectionMode(0);
            this.setTableHeader(null);
            this.setShowGrid(false);
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(false);
            this.tree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

                @Override
                public Icon getIcon() {
                    return null;
                }

                @Override
                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                    if (object instanceof SummaryCategory) {
                        Font font = this.getFont();
                        this.setFont(font.deriveFont(1));
                    } else {
                        this.setFont(null);
                    }
                    return this;
                }
            });
        }
    }
}

