/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationWizardFinisher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryCategory;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryItem;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.dbtools.raptor.DBDevExtensionResource;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.RaptorExtrasResources;
import oracle.dbtools.raptor.connections.ConnectionTypeRegistry;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.controls.ConnectionPanelUI;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.dialogs.MessageDialog;

public class SourceDBPageMigration
extends DefaultTraversablePanel
implements CommitListener,
LayoutControl,
SummaryProvider {
    private final String[] m_ignorePlatforms = new String[]{"Oracle", "TimesTen", "Access"};
    static final String ONLINEPANEL = "Online Capture";
    static final String OFFLINEPANEL = "Offline Capture";
    private final MultiLineLabel _lblOverview = new MultiLineLabel(QMWizardArb.getString("SourceDBSelectionOverviewOn"));
    private final MultiLineLabel _lblOverview2 = new MultiLineLabel(QMWizardArb.getString("SourceDBSelectionOverviewOff"));
    private final JRadioButton _rbtnOnlineCapture = new JRadioButton("", true);
    private final JRadioButton _rbtnOfflineCapture = new JRadioButton();
    private final JRadioButton _rbtnUnknown = new JRadioButton();
    private final JPanel _topPanel = new JPanel();
    private final CardLayout _cl = new CardLayout();
    private final MultiLineLabel _lblAccessOverview = new MultiLineLabel(QMWizardArb.getString("AccessMigrOverview"));
    private final HyperlinkButton _btnAccess = new HyperlinkButton("Access");
    private final HyperlinkButton _btnAccessOff = new HyperlinkButton("Access");
    private final MultiLineLabel _lblAvailableDatabases = new MultiLineLabel();
    private ConnectionPanelUI _connPanel = null;
    private final URLFileChooser.URLFileChooserPanel _chooser = URLFileChooser.createURLFileChooserPanel((int)0, (String)QMWizardArb.getString("OfflineFile"));
    private final JLabel _supPlat = new JLabel(QMWizardArb.getString("SupportedPlatforms"));
    private final MultiLineLabel _checkForUpdate = new MultiLineLabel(QMWizardArb.getString("CheckForUpdate"));
    private final HyperlinkButton _prefDlgActivate = new HyperlinkButton(QMWizardArb.getString("AddPlatform").trim());
    private boolean _skip = true;
    private boolean _pageLocked = false;

    SourceDBPageMigration() {
        ResourceUtils.resButton((AbstractButton)this._rbtnOnlineCapture, (String)QMWizardArb.getString("OnlineCapture"));
        ResourceUtils.resButton((AbstractButton)this._rbtnOfflineCapture, (String)QMWizardArb.getString("OfflineCapture"));
        this.putClientProperty("pagetitle", QMWizard.SRCDB_PAGE_ID);
        QMWizard.ContextHelper.addSummaryProvider(QMWizard.SRCDB_PAGE_ID, this);
        this.initGUI();
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (this._connPanel != null) {
            this._connPanel.resetConnections();
        }
        this.skipIfNeeded(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateAndAbsorbPage(traversableContext);
        }
        if (!this._pageLocked) {
            if (traversableContext.getDirection() == 2) {
                QMWizard.ContextHelper.removeCommitPage(QMWizardArb.getString("STEP3"));
            } else if (traversableContext.getDirection() == 1) {
                QMWizard.ContextHelper.addCommitPage(QMWizardArb.getString("STEP3"));
            }
        }
    }

    public Object getExitTransition() {
        return null;
    }

    @Override
    public SummaryItem getSummary(SummaryCategory summaryCategory) {
        SummaryCategory summaryCategory2 = null;
        SummaryItem summaryItem = null;
        SummaryItem summaryItem2 = null;
        SummaryItem summaryItem3 = null;
        SummaryItem summaryItem4 = null;
        if (summaryCategory != null) {
            summaryCategory2 = summaryCategory;
            if (this._rbtnOnlineCapture.isSelected()) {
                summaryItem = new SummaryItem(QMWizardArb.getString("SourceConnection"), Connections.getDisplayName((String)this._connPanel.getConnectionName()));
                summaryItem3 = new SummaryItem(QMWizardArb.getString("Mode"), StringUtils.stripMnemonic((String)this._rbtnOnlineCapture.getText()));
                summaryCategory.addChild(summaryItem);
                summaryCategory.addChild(summaryItem3);
            }
            if (this._rbtnOfflineCapture.isSelected()) {
                summaryItem2 = new SummaryItem(StringUtils.stripMnemonic((String)QMWizardArb.getString("ProjectOutDirLabel")), this._chooser.getText().trim());
                summaryItem3 = new SummaryItem(QMWizardArb.getString("Mode"), StringUtils.stripMnemonic((String)this._rbtnOfflineCapture.getText()));
                summaryItem4 = new SummaryItem(QMWizardArb.getString("Encoding"), this._chooser.getEncoding());
                summaryCategory.addChild(summaryItem2);
                summaryCategory.addChild(summaryItem3);
                summaryCategory.addChild(summaryItem4);
            }
        }
        return summaryCategory2;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        TraversableContext traversableContext = applyEvent.getTraversableContext();
        String string = (String)this.getClientProperty("pagetitle");
        if (QMWizard.ContextHelper.isActiveCommitPage(string)) {
            Properties properties = new Properties();
            MigrationWizardFinisher migrationWizardFinisher = null;
            if (this._rbtnOnlineCapture.isSelected()) {
                properties.setProperty("CAPT_MODE", "Online");
                properties.setProperty("CAPT_SRCCONN", this._connPanel.getConnectionName());
            } else if (this._rbtnOfflineCapture.isSelected()) {
                properties.setProperty("CAPT_MODE", "Offline");
                properties.setProperty("CAPT_OCPPATH", this._chooser.getText().trim());
                properties.setProperty("CAPT_ENCODING", this._chooser.getEncoding());
            }
            migrationWizardFinisher = QMWizard.ContextHelper.getWizardFinisher();
            migrationWizardFinisher.setParamAndFinish(properties, 0);
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        ModeActionListener modeActionListener = new ModeActionListener();
        jPanel3.setLayout(new FlowLayout(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbtnOnlineCapture);
        buttonGroup.add(this._rbtnOfflineCapture);
        buttonGroup.add(this._rbtnUnknown);
        this._rbtnOnlineCapture.addActionListener(modeActionListener);
        this._rbtnOfflineCapture.addActionListener(modeActionListener);
        jPanel3.add(this._rbtnOnlineCapture);
        jPanel3.add(this._rbtnOfflineCapture);
        jPanel3.setBorder(BorderFactory.createTitledBorder(QMWizardArb.getString("Mode")));
        this._topPanel.setLayout(this._cl);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        PlatformListBuilder platformListBuilder = new PlatformListBuilder();
        String string = platformListBuilder.getPlatformList();
        this._lblAvailableDatabases.setText(string);
        String[] stringArray = this.getThirdPartyConnectionSubtypes();
        this._connPanel = new ConnectionPanelUI(stringArray, false);
        this._connPanel.setConnectionPrompt(QMWizardArb.getString("SourceDBSelectionOverviewOn"));
        jPanel4.add((Component)this._connPanel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this._supPlat, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this._lblAvailableDatabases, new GridBagConstraints(0, 4, 0, 1, 0.0, 0.0, 11, 1, new Insets(0, 15, 10, 0), 0, 0));
        jPanel4.add((Component)this._checkForUpdate, new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._prefDlgActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IdeSettings ideSettings = Ide.getSettings();
                String[] stringArray = new String[]{DBDevExtensionResource.getString((String)"DATABASE_INFO"), RaptorExtrasResources.getString((String)"TP_INFO")};
                ideSettings.showDialog((Frame)Ide.getMainWindow(), stringArray);
                IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PlatformListBuilder platformListBuilder = new PlatformListBuilder();
                        String string = platformListBuilder.getPlatformList();
                        SourceDBPageMigration.this._lblAvailableDatabases.setText(string);
                    }
                });
            }
        });
        jPanel5.setLayout(new GridBagLayout());
        jPanel5.add((Component)this._lblOverview2, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 10, 0), 0, 0));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        jPanel6.add((Component)this._lblAccessOverview, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 0, 10, 0), 0, 0));
        jPanel6.add((Component)this._btnAccessOff, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 3, 10, 0), 0, 0));
        jPanel6.add((Component)new JLabel(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 10, 0), 0, 0));
        jPanel5.add((Component)jPanel6, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 10, 0), 0, 0));
        jPanel5.add((Component)this._chooser, LayoutControl.GBC.gbc((int)0, (int)2, (int)0, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel5.add((Component)new JLabel(), new GridBagConstraints(0, 3, 0, 0, 1.0, 1.0, 11, 1, new Insets(0, 10, 10, 0), 0, 0));
        this._topPanel.add((Component)jPanel4, ONLINEPANEL);
        this._topPanel.add((Component)jPanel5, OFFLINEPANEL);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)new JLabel(QMWizardArb.getString("NoInfomationAvailable")), "Center");
        this._topPanel.add((Component)jPanel7, "unknown");
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)this._topPanel, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)this._prefDlgActivate, "East");
        jPanel2.add((Component)jPanel8, "South");
        this.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel8, "South");
        this.add(jPanel, "Center");
        this._chooser.addChooseableURLFilter((URLFilter)new WildcardURLFilter("*.ocp", URLFileSystem.isLocalFileSystemCaseSensitive(), QMWizardArb.getString("OcpExtension")));
        this._chooser.addChooseableURLFilter((URLFilter)new WildcardURLFilter("*.xml", URLFileSystem.isLocalFileSystemCaseSensitive(), QMWizardArb.getString("AccessExtension")));
        this._chooser.setSelectionScope(0);
        this._chooser.setSelectionMode(0);
        this._chooser.setCheckIfFileExists(true);
        this._chooser.showEncodings(true);
        HelpUtils.setHelpID((JComponent)this._btnAccess, (String)"f1_qmhelp_id_for_step3");
        HelpUtils.setHelpID((JComponent)this._btnAccess, (String)"f1_qmhelp_id_for_step3");
        this._btnAccess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HelpUtils.showHelp((Component)SourceDBPageMigration.this._btnAccess);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._btnAccessOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HelpUtils.showHelp((Component)SourceDBPageMigration.this._btnAccessOff);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private String[] getThirdPartyConnectionSubtypes() {
        String[] stringArray = Connections.getInstance().getConnNames();
        Properties properties = null;
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = null;
        if (stringArray != null) {
            for (String string2 : stringArray) {
                properties = Connections.getInstance().getConnectionInfo(string2);
                string = properties.getProperty("subtype");
                if ("oraJDBC".equals(string) || "TimesTen".equals(string) || "ODBCBridge".equals(string)) continue;
                arrayList.add(string);
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add("SuppressDefaultOracleConnections");
        }
        stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    private void lockPage(boolean bl) {
        this._pageLocked = true;
        this.disablePageWidgets();
    }

    private void skipIfNeeded(TraversableContext traversableContext) {
        if (this._skip && QMWizard.ContextHelper.getConnType() != null && !"Oracle".equals(QMWizard.ContextHelper.getConnType()) && !"MIGREPO".equals(QMWizard.ContextHelper.getConnType())) {
            this.initPageState(traversableContext);
        }
        if (this._skip && QMWizard.ContextHelper.isMigrationAction() && QMWizard.ContextHelper.getActionName() != null && (QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("CONVERTED_PAGE").trim()) || QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("GENERATE_PAGE").trim()) || QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("DATAMOVE_PAGE").trim()))) {
            this._skip = false;
            this.lockPage(false);
            this.initPageState(traversableContext);
            this._rbtnUnknown.setSelected(true);
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
    }

    private void disablePageWidgets() {
        this._lblOverview.setEnabled(false);
        this._lblOverview2.setEnabled(false);
        this._supPlat.setEnabled(false);
        this._checkForUpdate.setEnabled(false);
        this._rbtnOnlineCapture.setEnabled(false);
        this._rbtnOfflineCapture.setEnabled(false);
        this._lblAvailableDatabases.setEnabled(false);
        this._connPanel.setEnabled(false);
        this._chooser.setEnabled(false);
        this._prefDlgActivate.setEnabled(false);
        this._btnAccess.setEnabled(false);
        this._btnAccessOff.setEnabled(false);
    }

    public void initPageState(TraversableContext traversableContext) {
        boolean bl;
        String string = (String)traversableContext.get("PROJECT_NAME");
        boolean bl2 = QMWizard.ContextHelper.isCaptureModeOnline() || this._rbtnOnlineCapture.isSelected();
        boolean bl3 = bl = QMWizard.ContextHelper.isCaptureModeOffline() || this._rbtnOfflineCapture.isSelected();
        if (bl2) {
            String string2 = QMWizard.ContextHelper.getConnType();
            if (!(string2 == null || string2.equals("Oracle") || string2.equals("MIGREPO") || string2.equals("MIGPROJ"))) {
                String string3 = QMWizard.ContextHelper.getConnName();
                this._connPanel.setSelectedItem(string3);
                this._rbtnOnlineCapture.doClick();
            } else {
                String string4 = QMWizard.ContextHelper.getProjectSourceConnection(string);
                this._connPanel.setSelectedItem(string4);
                this._rbtnOnlineCapture.doClick();
            }
        } else if (bl) {
            this._chooser.setText(QMWizard.ContextHelper.getOfflineCaptureDir());
            this._rbtnOfflineCapture.doClick();
        } else if (this._pageLocked) {
            this._cl.show(this._topPanel, "unknown");
            this._prefDlgActivate.setVisible(false);
            this.revalidate();
        }
    }

    private void validateAndAbsorbPage(TraversableContext traversableContext) throws TraversalException {
        String string;
        String string2 = (String)traversableContext.get("SOURCE_CONN");
        String string3 = (String)traversableContext.get("OFF_CAPTURE_CONTROL");
        boolean bl = false;
        if (this._rbtnOnlineCapture.isSelected()) {
            string = this._connPanel.getConnectionName();
            if (string == null || string.trim().length() == 0) {
                throw new TraversalException(QMWizardArb.getString("InvalidSrcConnection"));
            }
            try {
                Connections.getInstance().getConnection(string);
            }
            catch (Exception exception) {
                throw new TraversalException(QMWizardArb.getString("InvalidSrcConnection"));
            }
            traversableContext.put("SOURCE_CONN", (Object)string.trim());
            traversableContext.put("OFFLINE_FILE_ENCODING", null);
            traversableContext.put("OFF_CAPTURE_CONTROL", null);
            if (string2 == null || !string2.equals(string)) {
                bl = true;
            }
        }
        if (this._rbtnOfflineCapture.isSelected()) {
            string = this._chooser.getText().trim();
            String string4 = this._chooser.getEncoding();
            if (string == null || (string = string.trim()).length() == 0) {
                throw new TraversalException(QMWizardArb.getString("CaptureControlFileInvalid"));
            }
            File file = new File(string);
            if (!file.exists() || file.isDirectory()) {
                throw new TraversalException(QMWizardArb.getString("CaptureControlFileInvalid"));
            }
            try {
                traversableContext.put("OFF_CAPTURE_CONTROL", (Object)file.getCanonicalPath());
                traversableContext.put("OFFLINE_FILE_ENCODING", (Object)string4);
                traversableContext.put("SOURCE_CONN", null);
            }
            catch (IOException iOException) {
                throw new TraversalException("Internal Error: Unable to get the canonical path : " + string);
            }
            if (string3 == null || !string3.equals(string)) {
                bl = true;
            }
        }
        if (bl) {
            traversableContext.put("AVAILABLE_DB_LIST", null);
            traversableContext.put("SELECTED_DB_LIST", null);
        }
    }

    private class ModeActionListener
    implements ActionListener {
        private ModeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SourceDBPageMigration.this._rbtnOnlineCapture) {
                SourceDBPageMigration.this._cl.show(SourceDBPageMigration.this._topPanel, SourceDBPageMigration.ONLINEPANEL);
                SourceDBPageMigration.this._prefDlgActivate.setVisible(true);
            } else {
                SourceDBPageMigration.this._cl.show(SourceDBPageMigration.this._topPanel, SourceDBPageMigration.OFFLINEPANEL);
                SourceDBPageMigration.this._prefDlgActivate.setVisible(false);
            }
        }
    }

    private class PlatformListBuilder {
        private StringBuilder databaseList = new StringBuilder();

        PlatformListBuilder() {
            this.initAvailablePlatforms();
        }

        String getPlatformList() {
            return this.databaseList.toString();
        }

        private void initAvailablePlatforms() {
            ArrayList arrayList = ConnectionTypeRegistry.getTabNames();
            for (String string : arrayList) {
                try {
                    if (Arrays.asList(SourceDBPageMigration.this.m_ignorePlatforms).contains(string)) continue;
                    IConnectionPanel iConnectionPanel = ConnectionTypeRegistry.getPanelFor((String)string);
                    boolean bl = false;
                    String[] stringArray = iConnectionPanel.getSupportedDrivers();
                    ClassLoader classLoader = null;
                    for (String string2 : stringArray) {
                        try {
                            classLoader = RaptorClassLoader.findClassLoader((String)string2);
                            if (classLoader == null) continue;
                            classLoader.loadClass(string2);
                            bl = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!bl) continue;
                    String string3 = string.trim();
                    this.databaseList.append(string);
                    this.databaseList.append("\n");
                }
                catch (Exception exception) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(Messages.getString((String)"ConnectionDialog.7") + string + "\n" + exception.getMessage()), (String)Messages.getString((String)"ConnectionDialog.9"), (String)"f1_connectiontype_load_err_html");
                }
            }
            String string = this.databaseList.toString();
        }
    }
}

