/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationWizardFinisher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryCategory;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryItem;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.dbtools.raptor.controls.ConnectionPanelUI;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Element;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class RepoPageMigration
extends DefaultTraversablePanel
implements CommitListener,
SummaryProvider {
    private static final long serialVersionUID = 1L;
    private final JCheckBox _chkTrunc = new JCheckBox();
    private final JCheckBox _chkGoSummary = new JCheckBox();
    private ConnectionPanelUI connPanel = null;
    private boolean _resetting;
    private boolean _skip = true;
    private boolean _pageLocked = false;

    RepoPageMigration() {
        ResourceUtils.resButton((AbstractButton)this._chkTrunc, (String)QMWizardArb.getString("Trunc"));
        ResourceUtils.resButton((AbstractButton)this._chkGoSummary, (String)QMWizardArb.getString("GoToSummary"));
        this.putClientProperty("pagetitle", QMWizard.REPO_PAGE_ID);
        QMWizard.ContextHelper.addSummaryProvider(QMWizard.REPO_PAGE_ID, this);
        this.initGUI();
    }

    public void onEntry(TraversableContext traversableContext) {
        this.initPageWithData(traversableContext);
        this.skipIfNeeded(traversableContext);
        if (this._pageLocked) {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.connPanel.getConnectionName();
        if (traversableContext.getDirection() == 1 && string == null || string.trim().length() == 0) {
            throw new TraversalException(QMWizardArb.getString("RepoConnBad"));
        }
        traversableContext.put("REPOSITORY_CONNECTION", (Object)string);
        traversableContext.put("TRUNCATE", (Object)this._chkTrunc.isSelected());
        RepositoryManager.findOrCreateRepositoryTables(string);
        if (!this._pageLocked) {
            if (traversableContext.getDirection() == 2) {
                QMWizard.ContextHelper.removeCommitPage(QMWizardArb.getString("STEP1"));
            } else if (traversableContext.getDirection() == 1) {
                QMWizard.ContextHelper.addCommitPage(QMWizardArb.getString("STEP1"));
            }
        }
    }

    public Object getExitTransition() {
        if (this._chkGoSummary.isSelected()) {
            return "TRANSITION_TO_SUMMARY";
        }
        return null;
    }

    @Override
    public SummaryItem getSummary(SummaryCategory summaryCategory) {
        SummaryCategory summaryCategory2 = null;
        SummaryItem summaryItem = null;
        SummaryItem summaryItem2 = null;
        if (summaryCategory == null) {
            summaryCategory2 = new SummaryCategory(QMWizardArb.getString("Repository"), null);
            summaryItem = new SummaryItem(QMWizardArb.getString("RepoConnName"), Connections.getDisplayName((String)this.connPanel.getConnectionName()));
            summaryCategory2.addChild(summaryItem);
        } else {
            summaryCategory.addChild(new SummaryItem(QMWizardArb.getString("CreateRepo"), null));
            summaryItem2 = this._chkTrunc.isSelected() ? new SummaryItem(QMWizardArb.getString("TruncateRepos"), QMWizardArb.getString("Yes")) : new SummaryItem(QMWizardArb.getString("TruncateRepos"), QMWizardArb.getString("No"));
            summaryCategory.addChild(summaryItem2);
            summaryCategory2 = summaryCategory;
        }
        return summaryCategory2;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        String string = (String)this.getClientProperty("pagetitle");
        try {
            if (QMWizard.ContextHelper.isActiveCommitPage(string)) {
                Properties properties = new Properties();
                properties.put("REPO_CONN", this.connPanel.getConnectionName());
                properties.put("REPO_TRUNC", (Object)this._chkTrunc.isSelected());
                Element element = QMWizard.ContextHelper.getContextElement();
                if (element != null) {
                    properties.put("CTX_ELEMENT", element);
                }
                MigrationWizardFinisher migrationWizardFinisher = null;
                migrationWizardFinisher = QMWizard.ContextHelper.getWizardFinisher();
                migrationWizardFinisher.setParamAndFinish(properties, 2);
            }
        }
        catch (Exception exception) {
            throw new TraversalException(exception.getMessage());
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    private final void initGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.connPanel = new ConnectionPanelUI(true, false);
        this.connPanel.addComboListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!RepoPageMigration.this._resetting) {
                    RepoPageMigration.this.hideTruncIfNoRepository(RepoPageMigration.this.connPanel.getConnectionName());
                }
            }
        });
        this.connPanel.setConnectionPrompt(QMWizardArb.getString("RepoOverview"));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.connPanel, "North");
        jPanel2.add((Component)this._chkTrunc, "South");
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this._chkGoSummary);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel2, "North");
        this.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel4, "North");
        jPanel.add((Component)jPanel3, "South");
        this.add(jPanel, "Center");
    }

    private void lockPage(boolean bl) {
        this._pageLocked = true;
        this.disablePageWidgets();
    }

    private void skipIfNeeded(TraversableContext traversableContext) {
        if (this._skip && QMWizard.ContextHelper.getActionName() != null && QMWizard.ContextHelper.getDefaultRepository() != null) {
            this._skip = false;
            this.lockPage(false);
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
    }

    private void disablePageWidgets() {
        this._chkTrunc.setEnabled(false);
        this._chkGoSummary.setEnabled(false);
        this.connPanel.setEnabled(false);
    }

    private void initPageWithData(TraversableContext traversableContext) {
        String string;
        if (this.connPanel != null) {
            this._resetting = true;
            this.connPanel.resetConnections();
            this._resetting = false;
        }
        if ((string = QMWizard.ContextHelper.getDefaultRepository()) != null && string.trim().length() > 0) {
            this.connPanel.setSelectedItem(string);
        }
        this.hideTruncIfNoRepository(this.connPanel.getConnectionName());
    }

    private void hideTruncIfNoRepository(String string) {
        boolean bl = false;
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            bl = RepositoryManager.doesRepositoryExist(connection);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            this._chkTrunc.setVisible(true);
        } else {
            this._chkTrunc.setSelected(false);
            this._chkTrunc.setVisible(false);
        }
    }
}

