/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationWizardFinisher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryCategory;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryItem;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ProjectPageMigration
extends DefaultTraversablePanel
implements CommitListener,
SummaryProvider {
    private final MultiLineLabel _lblOverview = new MultiLineLabel(QMWizardArb.getString("ProjectOverview"));
    private final JLabel _lblProjectName = new JLabel();
    private final JTextField _txtProjName = new JTextField();
    private JScrollPane _descContainer = null;
    private final JLabel _lblProjDesc = new JLabel();
    private final JTextPane _txtProjDesc = new JTextPane();
    private final JLabel _lblOutputDir = new JLabel();
    private final URLTextField _txtOutputDir = new URLTextField();
    private final JButton _btnBrowse = new JButton();
    private final JCheckBox _chkGoSummary = new JCheckBox();
    private boolean _skip = true;
    private boolean _suppressException = true;
    private boolean _pageLocked = false;

    ProjectPageMigration() {
        ResourceUtils.resLabel((JLabel)this._lblProjectName, (Component)this._txtProjName, (String)QMWizardArb.getString("ProjectNameLabel"));
        ResourceUtils.resLabel((JLabel)this._lblProjDesc, (Component)this._txtProjDesc, (String)QMWizardArb.getString("ProjectDescriptionLabel"));
        ResourceUtils.resLabel((JLabel)this._lblOutputDir, (Component)this._txtOutputDir, (String)QMWizardArb.getString("ProjectOutDirLabel"));
        ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)QMWizardArb.getString("Browse"));
        ResourceUtils.resButton((AbstractButton)this._chkGoSummary, (String)QMWizardArb.getString("GoToSummary"));
        this.putClientProperty("pagetitle", QMWizard.PROJ_PAGE_ID);
        QMWizard.ContextHelper.addSummaryProvider(QMWizard.PROJ_PAGE_ID, this);
        this.initGUI();
    }

    public void onEntry(TraversableContext traversableContext) {
        this.skipIfNeeded(traversableContext);
        if (this._pageLocked) {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateAndAbsorbPage(traversableContext);
        }
        if (!this._pageLocked) {
            if (traversableContext.getDirection() == 2) {
                QMWizard.ContextHelper.removeCommitPage(QMWizardArb.getString("STEP2"));
            } else if (traversableContext.getDirection() == 1) {
                QMWizard.ContextHelper.addCommitPage(QMWizardArb.getString("STEP2"));
            }
        }
    }

    public Object getExitTransition() {
        if (this._chkGoSummary.isSelected()) {
            return "TRANSITION_TO_SUMMARY";
        }
        return null;
    }

    private void initPageState(TraversableContext traversableContext) {
        String string = QMWizard.ContextHelper.getProjectName();
        String string2 = QMWizard.ContextHelper.getProjectDescription();
        String string3 = QMWizard.ContextHelper.getProjectOutputDir(string);
        if (string != null) {
            this._txtProjName.setText(string);
        }
        if (string2 != null) {
            // empty if block
        }
        this._txtProjDesc.setText(string2);
        if (this._pageLocked && "UnknownDir".equals(string3)) {
            string3 = null;
        }
        this._txtOutputDir.setText(string3);
        if (string3 == null || string3.trim().length() == 0) {
            this.enableOutputDir();
        }
    }

    @Override
    public SummaryItem getSummary(SummaryCategory summaryCategory) {
        SummaryCategory summaryCategory2 = null;
        SummaryItem summaryItem = null;
        SummaryItem summaryItem2 = null;
        SummaryItem summaryItem3 = null;
        if (summaryCategory == null) {
            summaryCategory2 = new SummaryCategory(QMWizardArb.getString("Project"), null);
            summaryItem = new SummaryItem(StringUtils.stripMnemonic((String)QMWizardArb.getString("ProjectNameLabel")), this._txtProjName.getText());
            summaryItem2 = new SummaryItem(StringUtils.stripMnemonic((String)QMWizardArb.getString("ProjectOutDirLabel")), this._txtOutputDir.getText());
            summaryCategory2.addChild(summaryItem);
            summaryCategory2.addChild(summaryItem2);
        } else {
            summaryCategory2 = summaryCategory;
            summaryItem3 = new SummaryItem(QMWizardArb.getString("CreateProj"), null);
            summaryCategory2.addChild(summaryItem3);
        }
        return summaryCategory2;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        TraversableContext traversableContext = applyEvent.getTraversableContext();
        String string = (String)this.getClientProperty("pagetitle");
        if (QMWizard.ContextHelper.isActiveCommitPage(string)) {
            Properties properties = new Properties();
            properties.setProperty("PROJ_NAME", this._txtProjName.getText().trim());
            properties.setProperty("PROJ_DESC", this._txtProjDesc.getText().trim());
            properties.setProperty("PROJ_OUTDIR", this._txtOutputDir.getText().trim());
            Element element = QMWizard.ContextHelper.getContextElement();
            if (element != null) {
                properties.put("CTX_ELEMENT", element);
            }
            MigrationWizardFinisher migrationWizardFinisher = null;
            migrationWizardFinisher = QMWizard.ContextHelper.getWizardFinisher();
            migrationWizardFinisher.setParamAndFinish(properties, 4);
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    private final void initGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.setLayout(new BorderLayout());
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this._lblProjectName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(15, 0, 10, 0), 0, 0));
        jPanel2.add((Component)this._txtProjName, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 1, new Insets(15, 0, 10, 0), 0, 0));
        jPanel2.add((Component)this._lblProjDesc, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
        this._descContainer = new JScrollPane(this._txtProjDesc);
        jPanel2.add((Component)this._descContainer, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        jPanel2.add((Component)this._lblOutputDir, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
        jPanel2.add((Component)this._txtOutputDir, new GridBagConstraints(1, 3, -1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
        jPanel2.add((Component)this._btnBrowse, new GridBagConstraints(2, 3, 0, 1, 0.0, 0.0, 11, 1, new Insets(0, 10, 10, 0), 0, 0));
        jPanel.add((Component)this._lblOverview, "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this._chkGoSummary, "South");
        this.add(jPanel, "Center");
        this._btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL;
                MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
                URLFileChooser uRLFileChooser = new URLFileChooser();
                uRLFileChooser.clearChooseableURLFilters();
                uRLFileChooser.setSelectionScope(1);
                uRLFileChooser.setSelectionMode(0);
                int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), QMWizardArb.getString("ChooseDir"));
                if (n == 0 && (uRL = uRLFileChooser.getSelectedURL()) != null && uRL.toString().length() > 0) {
                    File file = new File(uRL.getPath());
                    if (!file.exists() || !file.canWrite()) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)QMWizardArb.getString("DirInvalid"), (String)QMWizardArb.getString("ChooseDir"), null);
                    } else {
                        ProjectPageMigration.this._txtOutputDir.setText(file.getAbsolutePath());
                    }
                }
            }
        });
    }

    private void lockPage(boolean bl) {
        this._pageLocked = true;
        this.disablePageWidgets();
    }

    private void skipIfNeeded(TraversableContext traversableContext) {
        if (this._skip && QMWizard.ContextHelper.isMigrationAction() && QMWizard.ContextHelper.getCtxFolderType() != null && !QMWizard.ContextHelper.getCtxFolderType().equals("MIGRATION_PROJECTS_FOLDER")) {
            this._skip = false;
            this.lockPage(false);
            this.initPageState(traversableContext);
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
    }

    private void disablePageWidgets() {
        this._lblOverview.setEnabled(false);
        this._lblProjectName.setEnabled(false);
        this._lblProjDesc.setEnabled(false);
        this._btnBrowse.setEnabled(false);
        this._lblOutputDir.setEnabled(false);
        this._txtOutputDir.setEnabled(false);
        this._txtProjName.setEnabled(false);
        this._txtProjDesc.setEnabled(false);
        this._chkGoSummary.setEnabled(false);
    }

    private void enableOutputDir() {
        this._lblOutputDir.setEnabled(true);
        this._txtOutputDir.setEnabled(true);
        this._btnBrowse.setEnabled(true);
    }

    private void checkIfProjectExists(String string, TraversableContext traversableContext) throws TraversalException {
        MigrationProjectsFolderNode migrationProjectsFolderNode = MigrationProjectsFolderNode.getInstance();
        Iterator iterator = migrationProjectsFolderNode.getChildren();
        Element element = null;
        String string2 = null;
        if (string == null) {
            return;
        }
        while (iterator != null && iterator.hasNext()) {
            element = (Element)iterator.next();
            string2 = element.getShortLabel();
            if (string2 == null || !(string2 = string2.trim()).equals(string)) continue;
            throw new TraversalException("Project with this name already exists!");
        }
    }

    private void validateAndAbsorbPage(TraversableContext traversableContext) throws TraversalException {
        String string = this._txtProjName.getText();
        String string2 = this._txtOutputDir.getText();
        String string3 = this._txtProjDesc.getText();
        boolean bl = (Boolean)traversableContext.get("TRUNCATE");
        if (string != null && string.trim().length() > 0) {
            string = string.trim();
            if (!this._pageLocked && !bl) {
                this.checkIfProjectExists(string, traversableContext);
            }
        } else {
            throw new TraversalException(QMWizardArb.getString("InvalidProjectName"));
        }
        traversableContext.put("PROJECT_NAME", (Object)string);
        File file = new File(string2.trim());
        if (!(string2 != null && string2.trim().length() > 0 && file.exists() && file.isDirectory() && file.canWrite())) {
            if (this._suppressException && this._pageLocked) {
                this._suppressException = false;
                throw new TraversalException(null);
            }
            throw new TraversalException(QMWizardArb.getString("InvalidOutputDir"));
        }
        string2 = string2.trim();
        if (string2 != null && string2.trim().length() > 0 && (string2.charAt(string2.length() - 1) == '/' || string2.charAt(string2.length() - 1) == '\\')) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        traversableContext.put("OUTPUT_DIR", (Object)string2);
        QMWizard.updateLogFileHandler(string2);
        traversableContext.put("PROJECT_DESC", (Object)string3);
    }
}

