/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.ide.model.Element;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class ProjectNamePanel
extends DefaultTraversablePanel {
    protected static final Logger LOGGER = Logger.getLogger(ProjectNamePanel.class.getName());
    private GridBagLayout panelLayout = new GridBagLayout();
    private JTextPane m_txtDescription = new JTextPane();
    private JLabel projectNameLabel = new JLabel();
    private JTextField projectNameField = new JTextField();
    private JCheckBox proceedToSummaryCheckBox = new JCheckBox();
    private static final String HTMLCONTENT = "text/html";
    private TraversableContext _dataContext;
    private boolean projectNamePreset;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public ProjectNamePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ProjectNamePanel.log(exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.panelLayout);
        Font font = this.projectNameLabel.getFont();
        String string = MigrationUtils.fontToCSSString(font);
        this.m_txtDescription.setContentType(HTMLCONTENT);
        this.m_txtDescription.setText(MigrationAddinArb.format("QUICKMIGRATE_PROJECT_DESC", string));
        this.m_txtDescription.setEditable(false);
        this.m_txtDescription.setOpaque(false);
        this.m_txtDescription.setRequestFocusEnabled(false);
        this.m_txtDescription.setFocusable(false);
        ResourceUtils.resLabel((JLabel)this.projectNameLabel, (Component)this.projectNameField, (String)QMWizardArb.get("ProjectNamePanel_projectNameLabel"));
        this.projectNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ProjectNamePanel.this.wizardEnableButtons(documentEvent.getDocument().getLength());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ProjectNamePanel.this.wizardEnableButtons(documentEvent.getDocument().getLength());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ProjectNamePanel.this.wizardEnableButtons(documentEvent.getDocument().getLength());
            }
        });
        this.proceedToSummaryCheckBox.setText(QMWizardArb.get("ProceedToSummaryLabel"));
        this.add(this.m_txtDescription, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.projectNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.projectNameField, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.proceedToSummaryCheckBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void wizardEnableButtons(int n) {
        if (this._dataContext != null) {
            if (n > 0) {
                this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
            } else {
                this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            }
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._dataContext = traversableContext;
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        String string = (String)traversableContext.get("PROJECT_NAME");
        if (string != null) {
            this.projectNameField.setText(string);
        }
        this._dataContext.getWizardCallbacks().wizardSetInitialFocus((Component)this.projectNameField);
        this.proceedToSummaryCheckBox.setSelected(false);
        this._dataContext.put("DO_CAPTURE", (Object)true);
        this.projectNamePreset = (Boolean)traversableContext.get("IS_PROJECT_NAME_PRESET");
        if (this.projectNamePreset) {
            this.projectNameField.setEnabled(false);
            this.proceedToSummaryCheckBox.setEnabled(false);
            if (traversableContext.getDirection() == 1) {
                this._dataContext.getWizardCallbacks().nextPage();
            }
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.projectNameField.getText();
        if (!this.projectNamePreset) {
            Iterator iterator = MigrationProjectsFolderNode.getInstance().getChildren();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!element.getShortLabel().equals(string)) continue;
                throw new TraversalException(MigrationProjectNavigatorArb.getString("FAILED_DUPLICATE_NAME_MESSAGE"));
            }
        }
        traversableContext.put("PROJECT_NAME", (Object)string);
        if (this.proceedToSummaryCheckBox.isSelected()) {
            traversableContext.put("DO_CAPTURE", (Object)false);
        }
    }

    public Object getExitTransition() {
        if (this.proceedToSummaryCheckBox.isSelected()) {
            return "TRANSITION_TO_SUMMARY";
        }
        return null;
    }
}

