/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.FullMigrateTask;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.Messages;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

class MigrationWizardFinisher {
    private Properties _migrationParams = new Properties();
    private int _actionMask = 0;
    private int _dataMask = 0;

    MigrationWizardFinisher() {
    }

    private void doMigration() {
        try {
            Properties properties = new Properties();
            Enumeration<Object> enumeration = this._migrationParams.keys();
            Object object = null;
            while (enumeration != null && enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                properties.put(object, this._migrationParams.get(object));
            }
            FullMigrateTask fullMigrateTask = new FullMigrateTask(this._actionMask, properties);
            try {
                fullMigrateTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                        String string = MigrationAddinArb.getString("MigrationCancelled");
                        MigrationWizardFinisher.this.showCompletionMessage(string);
                    }

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                        String string = MigrationAddinArb.getString("MigrationFailed");
                        MigrationWizardFinisher.this.showCompletionMessage(string);
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        String string = MigrationAddinArb.getString("MigrationSuccessful");
                        MigrationWizardFinisher.this.showCompletionMessage(string);
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)fullMigrateTask);
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), Messages.getString("QMSummary.13"), (Throwable)exception);
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("QM_ERROR_PLUGINEXCEPTION_MSG"), (String)MigrationAddinArb.getString("QM_ERROR_PLUGINEXCEPTION_TITLE"), (String)"help_migration_plugin_exception");
            MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), Messages.getString("QMSummary.15"), (Throwable)exception);
            return;
        }
    }

    void initCommitActionMask() {
        if (this._actionMask == 0) {
            Iterator<String> iterator = QMWizard.ContextHelper.getActiveCommitPages();
            String string = null;
            while (iterator != null && iterator.hasNext()) {
                string = iterator.next();
                if (string.equals(QMWizard.REPO_PAGE_ID)) {
                    this._actionMask |= 2;
                }
                if (string.equals(QMWizard.PROJ_PAGE_ID)) {
                    this._actionMask |= 4;
                }
                if (string.equals(QMWizard.CAPT_PAGE_ID)) {
                    this._actionMask |= 8;
                }
                if (string.equals(QMWizard.CONV_PAGE_ID)) {
                    this._actionMask |= 0x10;
                }
                if (string.equals(QMWizard.TGTDB_PAGE_ID)) {
                    this._actionMask |= 0x20;
                }
                if (!string.equals(QMWizard.MVDAT_PAGE_ID)) continue;
                this._actionMask |= 0x40;
            }
        }
    }

    void setParamAndFinish(Properties properties, int n) {
        Enumeration<Object> enumeration = properties.keys();
        String string = null;
        Object object = null;
        while (enumeration != null && enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = properties.get(string);
            this._migrationParams.put(string, object);
        }
        this._dataMask |= n;
        this.checkAndTriggerMigrate();
    }

    private void checkAndTriggerMigrate() {
        boolean bl = false;
        if (this._actionMask == this._dataMask) {
            bl = true;
        }
        if (bl) {
            this.doMigration();
        }
    }

    private void showCompletionMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string);
            }
        });
        MigrationLogUtil.endMigrationLogWizard();
    }

    private void printAllParams() {
        if (this._migrationParams != null) {
            Enumeration<Object> enumeration = this._migrationParams.keys();
            String string = null;
            while (enumeration != null && enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                System.out.println(string + " : -- : " + this._migrationParams.get(string));
            }
        }
    }
}

