/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.preferences.IdentitiferPreferencesPanel;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPreferences;
import oracle.dbtools.migration.workbench.core.ui.DataMapPanel;
import oracle.dbtools.migration.workbench.core.ui.IdentifierMappingPanel;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationWizardFinisher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryCategory;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryItem;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.model.Element;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;

public class ConvertPageMigration
extends DefaultTraversablePanel
implements CommitListener,
SummaryProvider,
ChangeListener {
    private static final String REPOS_PRESENT = "repos";
    private static final String REPOS_NOTPRESENT = "norepos";
    private final MultiLineLabel _lblOverview = new MultiLineLabel(QMWizardArb.getString("ConvertOverview"));
    private final JTabbedPane _tpConvertPreferences = new JTabbedPane();
    private final JPanel _container = new JPanel();
    private JPanel master = new JPanel();
    private final CardLayout _cl = new CardLayout();
    private final DataTypeSpecification[] EMPTY_FILTER_SPEC = new DataTypeSpecification[0];
    private DataMapPanel _dataMapPanel = null;
    private IdentifierMappingPanel _idMapPanel = null;
    private MigrationPlugin _plugin = null;
    private boolean _isReposAvailable = false;
    private String _tpConnectionType = null;
    private SupportedDataTypesMap _typeMap = null;
    private final HyperlinkButton _prefDlgActivate = new HyperlinkButton(QMWizardArb.getString("AdvanceOptions").trim());
    private final JCheckBox _chkGoSummary = new JCheckBox();
    private boolean _skip = true;
    private boolean _pageLocked = false;
    private boolean _dataTypeMapChanged = false;
    private boolean _identifierNameMapChanged = false;

    ConvertPageMigration() {
        ResourceUtils.resButton((AbstractButton)this._chkGoSummary, (String)QMWizardArb.getString("GoToSummary"));
        this.putClientProperty("pagetitle", QMWizard.CONV_PAGE_ID);
        QMWizard.ContextHelper.addSummaryProvider(QMWizard.CONV_PAGE_ID, this);
        this.initGUI();
    }

    public void onEntry(TraversableContext traversableContext) {
        this.initDataTypeMap(traversableContext);
        this.refreshGUI(traversableContext);
        this.skipIfNeeded(traversableContext);
        if (this._pageLocked) {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateAndAbsorbPage(traversableContext);
        }
        if (!this._pageLocked) {
            if (traversableContext.getDirection() == 2) {
                QMWizard.ContextHelper.removeCommitPage(QMWizardArb.getString("STEP5"));
            } else if (traversableContext.getDirection() == 1) {
                QMWizard.ContextHelper.addCommitPage(QMWizardArb.getString("STEP5"));
            }
        }
        if (this._idMapPanel != null) {
            this._dataTypeMapChanged = this.isDatatypeMapChanged();
            this._identifierNameMapChanged = this.isIdentifierNameMapChanged();
            this._idMapPanel.cleanUp();
            this._idMapPanel = null;
        }
    }

    public Object getExitTransition() {
        if (this._chkGoSummary.isSelected()) {
            return "TRANSITION_TO_SUMMARY";
        }
        return null;
    }

    @Override
    public SummaryItem getSummary(SummaryCategory summaryCategory) {
        SummaryCategory summaryCategory2 = null;
        SummaryItem summaryItem = null;
        if (summaryCategory != null) {
            summaryCategory2 = summaryCategory;
            summaryItem = this._dataTypeMapChanged ? new SummaryItem(QMWizardArb.getString("DTMapCustomized"), QMWizardArb.getString("Yes")) : new SummaryItem(QMWizardArb.getString("DTMapCustomized"), QMWizardArb.getString("No"));
            summaryCategory2.addChild(summaryItem);
            summaryItem = this._identifierNameMapChanged ? new SummaryItem(QMWizardArb.getString("IdentMapCustomized"), QMWizardArb.getString("Yes")) : new SummaryItem(QMWizardArb.getString("IdentMapCustomized"), QMWizardArb.getString("No"));
            summaryCategory2.addChild(summaryItem);
        }
        return summaryCategory2;
    }

    private boolean isDatatypeMapChanged() {
        boolean bl = false;
        if (this._dataMapPanel != null) {
            bl = this._dataMapPanel.isChanged();
        }
        return bl;
    }

    private boolean isIdentifierNameMapChanged() {
        boolean bl = false;
        if (this._idMapPanel != null) {
            bl = this._idMapPanel.isChanged();
        }
        return bl;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        TraversableContext traversableContext = applyEvent.getTraversableContext();
        String string = (String)this.getClientProperty("pagetitle");
        if (QMWizard.ContextHelper.isActiveCommitPage(string)) {
            Element element;
            MdProject mdProject;
            Properties properties = new Properties();
            MigrationWizardFinisher migrationWizardFinisher = null;
            MdConnection mdConnection = QMWizard.ContextHelper.getCapturedConnectionObject();
            if (mdConnection != null) {
                properties.put("CONV_CATPCONN", mdConnection);
            }
            properties.put("CONV_DTMAP", this._dataMapPanel.getDataTypeConversionMap());
            if (this._idMapPanel != null && this._idMapPanel.isInitialized()) {
                properties.put("CONV_IDMAP", this._idMapPanel.getChangedRows());
            }
            if ((mdProject = QMWizard.ContextHelper.getProject()) != null) {
                properties.put("PARAM_PROJ", mdProject);
            }
            if (this._idMapPanel != null && this._idMapPanel.isInitialized()) {
                properties.put("CONV_IDMAP_TBLMODEL", this._idMapPanel.getModel());
            }
            if ((element = QMWizard.ContextHelper.getContextElement()) != null) {
                properties.put("CTX_ELEMENT", element);
            }
            migrationWizardFinisher = QMWizard.ContextHelper.getWizardFinisher();
            migrationWizardFinisher.setParamAndFinish(properties, 16);
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
        if (this._idMapPanel != null) {
            this._dataTypeMapChanged = this.isDatatypeMapChanged();
            this._identifierNameMapChanged = this.isIdentifierNameMapChanged();
            this._idMapPanel.cleanUp();
            this._idMapPanel = null;
        }
    }

    private void initGUI() {
        this.master.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.master.add((Component)this._lblOverview, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._chkGoSummary, "West");
        jPanel.add((Component)this._prefDlgActivate, "East");
        this.master.add((Component)jPanel, "South");
        this.add(this.master, "Center");
        this._prefDlgActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IdeSettings ideSettings = Ide.getSettings();
                String[] stringArray = new String[]{MigrationPreferences.TITLE, IdentitiferPreferencesPanel.TITLE};
                ideSettings.showDialog((Frame)Ide.getMainWindow(), stringArray);
            }
        });
    }

    private void refreshGUI(TraversableContext traversableContext) {
        if (!this._pageLocked) {
            String string = (String)traversableContext.get("REPOSITORY_CONNECTION");
            boolean bl = true;
            if (this._dataMapPanel == null) {
                this._dataMapPanel = new DataMapPanel(this._typeMap, this.getDataTypesInUse(traversableContext));
            }
            if (!(bl = string != null && string.trim().length() > 0 ? Connections.getInstance().isConnectionOpen(string) : false) || traversableContext.get("CAPTURED_CONNECTION") == null) {
                this.master.add((Component)this._dataMapPanel, "Center");
            } else {
                this._tpConvertPreferences.removeAll();
                this._tpConvertPreferences.removeChangeListener(this);
                this._tpConvertPreferences.addTab(QMWizardArb.getString("DatatypeMapping"), this._dataMapPanel);
                if (this._idMapPanel == null) {
                    MdConnection mdConnection = QMWizard.ContextHelper.getCapturedConnectionObject();
                    DBObjectId dBObjectId = mdConnection != null ? mdConnection.getKey() : null;
                    String string2 = dBObjectId != null ? dBObjectId.toString() : "";
                    this._idMapPanel = new IdentifierMappingPanel((String)traversableContext.get("REPOSITORY_CONNECTION"), string2);
                }
                this._tpConvertPreferences.addTab(QMWizardArb.getString("ObjectNaming"), this._idMapPanel);
                this._tpConvertPreferences.addChangeListener(this);
                this.master.add((Component)this._tpConvertPreferences, "Center");
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        Object object = changeEvent.getSource();
        if (object == this._tpConvertPreferences && (n = this._tpConvertPreferences.getSelectedIndex()) >= 0 && this._tpConvertPreferences.getComponentAt(n) == this._idMapPanel && !this._idMapPanel.isInitialized()) {
            this._idMapPanel.init();
        }
    }

    private void initDataTypeMap(TraversableContext traversableContext) {
        try {
            String string = (String)traversableContext.get("SOURCE_CONN");
            String string2 = null;
            if (string != null) {
                this._plugin = QMWizard.ContextHelper.getMigrationPluginOnline(string);
            } else {
                string2 = (String)traversableContext.get("OFF_CAPTURE_CONTROL");
                try {
                    if (string2 != null) {
                        this._plugin = QMWizard.ContextHelper.getMigrationPluginOffline(string2);
                    }
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
            }
            if (this._plugin == null) {
                this._plugin = QMWizard.ContextHelper.getPlugin();
            }
            if (this._plugin != null) {
                this._tpConnectionType = this._plugin.getPlatformName();
                this._typeMap = this._plugin.getSupportedDataTypesMap();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void lockPage(boolean bl) {
        this._pageLocked = true;
        this.disablePageWidgets();
    }

    private DataTypeSpecification[] getDataTypesInUse(TraversableContext traversableContext) {
        MdConnection mdConnection = (MdConnection)traversableContext.get("CAPTURED_CONNECTION");
        if (mdConnection != null) {
            try {
                PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager());
                String[] stringArray = persistenceUtility.getAllDataTypesForConnection(mdConnection.getKey());
                DataTypeSpecification[] dataTypeSpecificationArray = new DataTypeSpecification[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    dataTypeSpecificationArray[i] = new DataTypeSpecification(stringArray[i]);
                }
                return dataTypeSpecificationArray;
            }
            catch (PersistenceException persistenceException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
            }
        }
        return this.EMPTY_FILTER_SPEC;
    }

    private void disablePageWidgets() {
        this._lblOverview.setEnabled(false);
        this._dataMapPanel.setEnabled(false);
        this._prefDlgActivate.setEnabled(false);
        if (this._idMapPanel != null) {
            this._idMapPanel.setEnabled(false);
        }
        this._chkGoSummary.setEnabled(false);
    }

    private void skipIfNeeded(TraversableContext traversableContext) {
        if (this._skip && QMWizard.ContextHelper.isMigrationAction() && QMWizard.ContextHelper.getActionName() != null && (QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("GENERATE_PAGE").trim()) || QMWizard.ContextHelper.getActionName() != null && QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("DATAMOVE_PAGE").trim()))) {
            this._skip = false;
            this.lockPage(false);
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
    }

    private void validateAndAbsorbPage(TraversableContext traversableContext) throws TraversalException {
    }
}

