/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationWizardFinisher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryCategory;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryItem;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class CapturePageMigration
extends DefaultTraversablePanel
implements CommitListener,
SummaryProvider {
    private final MultiLineLabel _lblOverview = new MultiLineLabel(QMWizardArb.getString("CapturePageOverview"));
    private final JLabel _lblAvailableDB = new JLabel(QMWizardArb.getString("AvailableDB"));
    private final JLabel _lblSelectedDB = new JLabel(QMWizardArb.getString("SelectedDB"));
    private JList _availDBList = new JList();
    private DefaultListModel _availDBListModel = new DefaultListModel();
    private JList _selectedDBList = new JList();
    private DefaultListModel _selectedDBListModel = new DefaultListModel();
    private final Shuttle _dbChooserShuttle = new Shuttle();
    private final ListPicker _availDBPicker = new ListPicker(this._availDBList);
    private final ListPicker _selectedDBPicker = new ListPicker(this._selectedDBList);
    private final JCheckBox _chkGoSummary = new JCheckBox();
    private boolean _skip = true;
    private boolean _pageLocked = false;

    CapturePageMigration() {
        ResourceUtils.resButton((AbstractButton)this._chkGoSummary, (String)QMWizardArb.getString("GoToSummary"));
        this.putClientProperty("pagetitle", QMWizard.CAPT_PAGE_ID);
        QMWizard.ContextHelper.addSummaryProvider(QMWizard.CAPT_PAGE_ID, this);
        this.initGUI();
    }

    public void onEntry(TraversableContext traversableContext) {
        this.skipIfNeeded(traversableContext);
        if (this._pageLocked) {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this.initPageState(traversableContext);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.validateAndAbsorbPage(traversableContext);
        if (!this._pageLocked) {
            if (traversableContext.getDirection() == 2) {
                QMWizard.ContextHelper.removeCommitPage(QMWizardArb.getString("STEP4"));
            } else if (traversableContext.getDirection() == 1) {
                QMWizard.ContextHelper.addCommitPage(QMWizardArb.getString("STEP4"));
            }
        }
    }

    public Object getExitTransition() {
        if (this._chkGoSummary.isSelected()) {
            return "TRANSITION_TO_SUMMARY";
        }
        return null;
    }

    @Override
    public SummaryItem getSummary(SummaryCategory summaryCategory) {
        SummaryCategory summaryCategory2 = null;
        SummaryItem summaryItem = null;
        if (summaryCategory != null) {
            summaryCategory2 = summaryCategory;
            SummaryCategory summaryCategory3 = new SummaryCategory(QMWizardArb.getString("CaptDbNode"), null);
            for (int i = 0; i < this._selectedDBListModel.size(); ++i) {
                summaryItem = new SummaryItem((String)this._selectedDBListModel.get(i), null);
                summaryCategory3.addChild(summaryItem);
            }
            summaryCategory2.addChild(summaryCategory3);
        }
        return summaryCategory2;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        TraversableContext traversableContext = applyEvent.getTraversableContext();
        String string = (String)this.getClientProperty("pagetitle");
        if (QMWizard.ContextHelper.isActiveCommitPage(string)) {
            Element element;
            Properties properties = new Properties();
            MigrationWizardFinisher migrationWizardFinisher = null;
            properties.put("CAPT_DBLIST", traversableContext.get("SELECTED_DB_LIST"));
            MdProject mdProject = QMWizard.ContextHelper.getProject();
            if (mdProject != null) {
                properties.put("PARAM_PROJ", mdProject);
            }
            if ((element = QMWizard.ContextHelper.getContextElement()) != null) {
                properties.put("CTX_ELEMENT", element);
            }
            migrationWizardFinisher = QMWizard.ContextHelper.getWizardFinisher();
            migrationWizardFinisher.setParamAndFinish(properties, 8);
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._dbChooserShuttle.add((Component)this._lblAvailableDB, (Object)"FromHeader");
        this._dbChooserShuttle.add((Component)this._lblSelectedDB, (Object)"ToHeader");
        this._dbChooserShuttle.setFromPicker((ItemPicker)this._availDBPicker);
        this._dbChooserShuttle.setToPicker((ItemPicker)this._selectedDBPicker);
        this.setLayout(new BorderLayout());
        jPanel.add((Component)this._lblOverview, "North");
        jPanel.add((Component)this._dbChooserShuttle, "Center");
        jPanel.add((Component)this._chkGoSummary, "South");
        this.add(jPanel, "Center");
    }

    private void lockPage(boolean bl) {
        this._pageLocked = true;
        this.disablePageWidgets();
    }

    private void initPageState(TraversableContext traversableContext) {
        int n;
        Object object;
        Object object2;
        Collection<String> collection = (Collection<String>)traversableContext.get("AVAILABLE_DB_LIST");
        Object object3 = (Collection)traversableContext.get("SELECTED_DB_LIST");
        String string = (String)traversableContext.get("SOURCE_CONN");
        String string2 = (String)traversableContext.get("OFF_CAPTURE_CONTROL");
        Object var6_6 = null;
        Collection<String> collection2 = null;
        if (string2 != null && collection == null) {
            try {
                object2 = QMWizard.ContextHelper.getMigrationPluginOffline(string2);
                object = object2 != null ? object2.getPlatformName() : "MSAccess";
                collection2 = QMWizard.ContextHelper.getAvailableDBListOffline((String)object, string2);
                traversableContext.put("AVAILABLE_DB_LIST", collection2);
                if (collection2 != null && collection2.size() > 1) {
                    collection = collection2;
                    traversableContext.put("AVAILABLE_DB_LIST", collection2);
                } else if (collection2 != null) {
                    collection = collection2;
                    collection2 = null;
                }
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
        object2 = null;
        if (string != null && collection == null) {
            try {
                object2 = QMWizard.ContextHelper.getMigrationPluginOnline(string).getPlatformName();
                collection2 = QMWizard.ContextHelper.getAvailableDBListOnline((String)object2, string);
                if (collection2 != null && collection2.size() > 1) {
                    collection = collection2;
                    traversableContext.put("AVAILABLE_DB_LIST", collection2);
                } else if (collection2 != null) {
                    collection = collection2;
                    collection2 = null;
                }
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
        object = QMWizard.ContextHelper.getMultiCatalogListFromNavSelection((String)object2);
        if (collection != null) {
            if (collection.size() == 1) {
                if (object3 == null || object3.size() < 1) {
                    object3 = collection;
                    collection = null;
                }
            } else if (object != null) {
                for (int i = 0; i < object.size(); ++i) {
                    if (object3 != null) continue;
                    object3 = object;
                }
                collection = this.adjustAvailableList(collection, (Collection<String>)object);
            }
        }
        this._availDBListModel.clear();
        this._selectedDBListModel.clear();
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (collection != null) {
            stringArray = new String[collection.size()];
            collection.toArray(stringArray);
        }
        if (object3 != null) {
            stringArray2 = new String[object3.size()];
            object3.toArray(stringArray2);
        }
        for (n = 0; stringArray != null && stringArray.length > n; ++n) {
            this._availDBListModel.add(n, stringArray[n]);
        }
        for (n = 0; stringArray2 != null && stringArray2.length > n; ++n) {
            this._selectedDBListModel.add(n, stringArray2[n]);
        }
        this._availDBList.setModel(this._availDBListModel);
        this._selectedDBList.setModel(this._selectedDBListModel);
    }

    private Collection<String> adjustAvailableList(Collection<String> collection, Collection<String> collection2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        String string2 = null;
        Iterator<String> iterator = null;
        Iterator<String> iterator2 = null;
        boolean bl = false;
        if (collection != null && collection2 != null) {
            iterator = collection.iterator();
            while (iterator != null && iterator.hasNext()) {
                string = iterator.next().trim();
                iterator2 = collection2.iterator();
                while (iterator2 != null && iterator2.hasNext()) {
                    string2 = iterator2.next().trim();
                    if (!string.equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    arrayList.add(string);
                    continue;
                }
                bl = false;
            }
        }
        return arrayList;
    }

    private void initPageStateLocked(TraversableContext traversableContext) {
        int n;
        String[] stringArray;
        String[] stringArray2;
        Collection<String> collection = (Collection<String>)traversableContext.get("AVAILABLE_DB_LIST");
        Collection<String> collection2 = (Collection<String>)traversableContext.get("SELECTED_DB_LIST");
        boolean bl = false;
        boolean bl2 = false;
        bl = traversableContext.get("SOURCE_CONN") != null;
        bl2 = traversableContext.get("OFF_CAPTURE_CONTROL") != null;
        Collection<String> collection3 = null;
        Collection<String> collection4 = null;
        if (bl2) {
            if (collection == null) {
                stringArray2 = (String[])traversableContext.get("OFF_CAPTURE_CONTROL");
                try {
                    stringArray = QMWizard.ContextHelper.getMigrationPluginOffline((String)stringArray2);
                    String string = stringArray != null ? stringArray.getPlatformName() : "MSAccess";
                    collection = collection3 = QMWizard.ContextHelper.getAvailableDBListOffline(string, (String)stringArray2);
                    traversableContext.put("AVAILABLE_DB_LIST", collection);
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                }
            }
            if (collection2 == null) {
                collection2 = collection4 = QMWizard.ContextHelper.getCaptureDBList();
                traversableContext.put("SELECTED_DB_LIST", collection2);
            }
        } else if (bl) {
            try {
                if (collection == null) {
                    stringArray2 = (String)traversableContext.get("SOURCE_CONN");
                    stringArray = QMWizard.ContextHelper.getMigrationPluginOnline((String)stringArray2).getPlatformName();
                    collection = collection3 = QMWizard.ContextHelper.getAvailableDBListOnline((String)stringArray, (String)stringArray2);
                    traversableContext.put("AVAILABLE_DB_LIST", collection);
                }
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
            if (collection2 == null) {
                collection2 = collection4 = QMWizard.ContextHelper.getCaptureDBList();
                traversableContext.put("SELECTED_DB_LIST", collection2);
            }
        } else if (this._pageLocked) {
            collection3 = null;
            if (collection2 == null) {
                collection2 = collection4 = QMWizard.ContextHelper.getCaptureDBList();
                traversableContext.put("SELECTED_DB_LIST", collection2);
            }
        }
        this._availDBListModel.clear();
        this._selectedDBListModel.clear();
        stringArray2 = null;
        stringArray = null;
        if (collection != null) {
            stringArray2 = new String[collection.size()];
            collection.toArray(stringArray2);
        }
        if (collection2 != null) {
            stringArray = new String[collection2.size()];
            collection2.toArray(stringArray);
        }
        for (n = 0; stringArray2 != null && stringArray2.length > n; ++n) {
            this._availDBListModel.add(n, stringArray2[n]);
        }
        for (n = 0; stringArray != null && stringArray.length > n; ++n) {
            this._selectedDBListModel.add(n, stringArray[n]);
        }
        this._availDBList.setModel(this._availDBListModel);
        this._selectedDBList.setModel(this._selectedDBListModel);
    }

    private void disablePageWidgets() {
        this._dbChooserShuttle.setEnabled(false);
        this._chkGoSummary.setEnabled(false);
        this._lblOverview.setEnabled(false);
        this._lblAvailableDB.setEnabled(false);
        this._lblSelectedDB.setEnabled(false);
    }

    private void skipIfNeeded(TraversableContext traversableContext) {
        if (this._skip && QMWizard.ContextHelper.isMigrationAction() && QMWizard.ContextHelper.getActionName() != null && (QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("CONVERTED_PAGE").trim()) || QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("GENERATE_PAGE").trim()) || QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("DATAMOVE_PAGE").trim()))) {
            this._skip = false;
            this.lockPage(false);
            this.initPageStateLocked(traversableContext);
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
    }

    private void validateAndAbsorbPage(TraversableContext traversableContext) throws TraversalException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Enumeration enumeration = this._availDBListModel.elements();
        Enumeration enumeration2 = this._selectedDBListModel.elements();
        String string = null;
        if (this._selectedDBListModel.size() == 0 && traversableContext.getDirection() == 1) {
            throw new TraversalException(QMWizardArb.getString("InvalidSelDBList"));
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            arrayList.add(string);
        }
        while (enumeration2 != null && enumeration2.hasMoreElements()) {
            string = (String)enumeration2.nextElement();
            arrayList2.add(string);
        }
        traversableContext.put("AVAILABLE_DB_LIST", Collections.unmodifiableCollection(arrayList));
        traversableContext.put("SELECTED_DB_LIST", Collections.unmodifiableCollection(arrayList2));
        traversableContext.put("CAPTURED_CONNECTION", (Object)QMWizard.ContextHelper.getCapturedConnectionObject());
    }
}

