/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.OfflineGenerationOutputStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.GenerateRunner;
import oracle.dbtools.migration.workbench.core.ui.Messages;
import oracle.dbtools.migration.workbench.core.ui.MigrationConnectionNodeRenderer;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public class OfflineOracleGenerationDialog {
    private JPanel m_panel;
    private JEWTDialog m_dlg;
    private JComboBox m_combo;

    public OfflineOracleGenerationDialog() {
        this.init();
    }

    private void init() {
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(MigrationAddinArb.getString("CONVERTED_ROOT_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 0, 1, 1, 4.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0);
        MigrationConnectionNode[] migrationConnectionNodeArray = ConvertedDatabases.getInstance().getMigrationConnectionNodes();
        if (migrationConnectionNodeArray != null) {
            this.m_combo = new JComboBox<MigrationConnectionNode>(migrationConnectionNodeArray);
            if (migrationConnectionNodeArray.length > 0) {
                this.m_combo.setSelectedIndex(0);
                this.m_combo.setToolTipText(migrationConnectionNodeArray[0].getMdConnection().getName());
            }
            this.m_combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OfflineOracleGenerationDialog.this.m_combo.getSelectedItem() != null) {
                        OfflineOracleGenerationDialog.this.m_combo.setToolTipText(((MigrationConnectionNode)OfflineOracleGenerationDialog.this.m_combo.getSelectedItem()).getMdConnection().getName());
                    }
                }
            });
        }
        this.m_combo.setRenderer(new MigrationConnectionNodeRenderer());
        this.m_panel.add((Component)jLabel, gridBagConstraints);
        this.m_panel.add((Component)this.m_combo, gridBagConstraints2);
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.m_panel, null, (String)StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MIGRATION_GENERATE_ORACLE_SCRIPTS_MENU")), (int)6);
        this.m_dlg.setSize(400, 120);
        this.m_dlg.setResizable(false);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_panel, "f1_offlinegeneration_html");
        JButton jButton = new JButton(MigrationAddinArb.getString("ConnectionDialog_btnOK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Preferences preferences = Preferences.getPreferences();
                MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
                Dimension dimension = OfflineOracleGenerationDialog.this.m_combo.getSize();
                dimension.getHeight();
                OfflineGenerationOutputStream offlineGenerationOutputStream = new OfflineGenerationOutputStream(migrationConfig);
                MigrationObjectFilterList migrationObjectFilterList = null;
                MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)OfflineOracleGenerationDialog.this.m_combo.getSelectedItem();
                MdConnection mdConnection = migrationConnectionNode.getMdConnection();
                GenerateWorker generateWorker = new GenerateWorker(MigrationAddin.getPersistenceManager(), mdConnection.getKey(), offlineGenerationOutputStream, migrationObjectFilterList);
                GenerateRunner generateRunner = new GenerateRunner(generateWorker);
                try {
                    OfflineOracleGenerationDialog.this.m_dlg.setVisible(false);
                    generateRunner.start(true);
                    String string = MessageFormat.format(MigrationAddinArb.getString("OfflineGeneration_GENERATION_COMPLETE"), "outputdir");
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)MigrationAddinArb.getString("OfflineGeneration_GENERATION_COMPLETE_TITLE"), null);
                }
                catch (Exception exception) {
                    MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), Messages.getString("OfflineOracleGenerationDialog.1"), (Throwable)exception);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("OfflineGeneration_MOREINFORMATION"), (String)MigrationAddinArb.getString("OfflineGeneration_GENERATION_FAILED"), (String)"help_need_output_access");
                }
            }
        });
        this.m_dlg.addCustomButton((Component)jButton);
    }

    public void launch() {
        if (this.m_dlg != null) {
            this.m_dlg.setLocationRelativeTo((Component)Ide.getMainWindow());
            this.m_dlg.setVisible(true);
        }
    }
}

