/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.DataMoveException;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveRunner;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveWorker;
import oracle.dbtools.migration.datamove.offline.OfflineDatamovePrintStream;
import oracle.dbtools.migration.datamove.offline.OfflineSQLLoaderPrintStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.Messages;
import oracle.dbtools.migration.workbench.core.ui.MigrationConnectionNodeRenderer;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class OfflineDatamoveDialog
extends AbstractMenuAction {
    private static String s_title = Messages.getString("OfflineDatamoveDialog.0");
    private JEWTDialog m_dlg;
    private JPanel m_panel;
    private boolean m_known = false;
    private int m_width;
    private int m_height;
    private JComboBox m_comboBox;
    private JLabel label;
    private JTextField directoryTextField;
    private JButton chooseDirectoryButton;
    private MdConnection m_mdConnection;

    private void dlgInit() {
        GridBagConstraints gridBagConstraints;
        GridBagConstraints gridBagConstraints2;
        MigrationConnectionNode[] migrationConnectionNodeArray = null;
        if (ConvertedDatabases.getInstance() != null) {
            migrationConnectionNodeArray = ConvertedDatabases.getInstance().getMigrationConnectionNodes();
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = OfflineDatamoveDialog.this.checkConvId();
                boolean bl2 = OfflineDatamoveDialog.this.checkDir();
                if (bl && bl2) {
                    try {
                        Offline3rdPartyPrintStream offline3rdPartyPrintStream;
                        String string = OfflineDatamoveDialog.this.directoryTextField.getText();
                        String string2 = OfflineDatamovePrintStream.getTimeStamp();
                        string2 = string2.replaceFirst(":", "h");
                        string2 = string2.replaceFirst(":", "m");
                        string2 = string2 + "s";
                        MigrationPlugin migrationPlugin = MigrationUtils.getPluginForConnection(OfflineDatamoveDialog.this.m_mdConnection);
                        String string3 = migrationPlugin.getPlatformName();
                        if (string3.equals("sql server")) {
                            string3 = "Sybase";
                        }
                        if ((offline3rdPartyPrintStream = migrationPlugin.getOffline3rdPartyPrintStream(string2, string)) == null) {
                            offline3rdPartyPrintStream = new Offline3rdPartyPrintStream(string3, string2, string);
                        }
                        OfflineSQLLoaderPrintStream offlineSQLLoaderPrintStream = new OfflineSQLLoaderPrintStream(string3, string2, string);
                        OfflineDataMoveWorker offlineDataMoveWorker = new OfflineDataMoveWorker(MigrationAddin.getPersistenceManager(), OfflineDatamoveDialog.this.m_mdConnection, OfflineDatamoveDialog.this.directoryTextField.getText(), offline3rdPartyPrintStream, offlineSQLLoaderPrintStream);
                        OfflineDataMoveRunner offlineDataMoveRunner = new OfflineDataMoveRunner(offlineDataMoveWorker);
                        OfflineDatamoveDialog.this.m_dlg.closeDialog(true);
                        offlineDataMoveRunner.start(true);
                    }
                    catch (DataMoveException dataMoveException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dataMoveException.getStackTrace()[0].toString(), dataMoveException);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    OfflineDatamoveDialog.this.m_dlg.setVisible(!bl && !bl2);
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        if (!this.m_known) {
            this.label = new JLabel();
            this.label.setText(Messages.getString("OfflineDatamoveDialog.8"));
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(5, 5, 0, 10);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 1;
            jPanel.add((Component)this.label, gridBagConstraints2);
            this.m_comboBox = new JComboBox<MigrationConnectionNode>(migrationConnectionNodeArray);
            this.m_comboBox.setRenderer(new MigrationConnectionNodeRenderer());
            if (migrationConnectionNodeArray != null && migrationConnectionNodeArray.length > 0) {
                this.m_comboBox.setToolTipText(migrationConnectionNodeArray[0].getMdConnection().getName());
                this.m_comboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OfflineDatamoveDialog.this.m_comboBox.getSelectedItem() != null) {
                            OfflineDatamoveDialog.this.m_comboBox.setToolTipText(((MigrationConnectionNode)OfflineDatamoveDialog.this.m_comboBox.getSelectedItem()).getMdConnection().getName());
                        }
                    }
                });
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 4.0;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)this.m_comboBox, gridBagConstraints);
        }
        this.directoryTextField = new JTextField();
        this.directoryTextField.setEditable(true);
        this.directoryTextField.setEnabled(true);
        this.directoryTextField.setText(MigrationAddin.getMigrationConfig().getOfflineDataMoveScriptDirectory());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.weightx = 4.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = this.m_known ? 0 : 1;
        gridBagConstraints2.gridx = 0;
        jPanel.add((Component)this.directoryTextField, gridBagConstraints2);
        this.chooseDirectoryButton = new JButton();
        this.chooseDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL;
                int n;
                MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
                URLFileChooser uRLFileChooser = new URLFileChooser();
                uRLFileChooser.clearChooseableURLFilters();
                uRLFileChooser.setSelectionScope(1);
                uRLFileChooser.setSelectionMode(0);
                String string = migrationConfig.getOfflineDataMoveScriptDirectory();
                if (string != null && !string.equals("")) {
                    File file = new File(string);
                    try {
                        uRLFileChooser.setSelectedURL(file.toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
                    }
                }
                if ((n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), MigrationAddinArb.getString("MIGRATION_OFFLINE_CHOOSE_DIR"))) == 0 && (uRL = uRLFileChooser.getSelectedURL()) != null && uRL.toString().length() > 0) {
                    File file = new File(uRL.getPath());
                    if (!file.exists() || !file.canWrite()) {
                        oracle.javatools.dialogs.MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MIGRATION_OFFLINE_DIR_NOT_EXISTS"), (String)MigrationAddinArb.getString("MIGRATION_OFFLINE_CHOOSE_DIR"), null);
                    }
                    OfflineDatamoveDialog.this.directoryTextField.setText(file.getAbsolutePath());
                }
            }
        });
        this.chooseDirectoryButton.setText(MigrationAddinArb.getString("MIGRATION_OFFLINE_CHOOSE_DIR"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.gridy = this.m_known ? 0 : 1;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.chooseDirectoryButton, gridBagConstraints);
        if (this.m_known) {
            this.m_width = 500;
            this.m_height = 130;
            jPanel.setSize(this.m_width, this.m_height);
        } else {
            this.m_width = 500;
            this.m_height = 160;
            jPanel.setSize(this.m_width, this.m_height);
        }
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)s_title, (int)6);
        this.m_dlg.setSize(this.m_width, this.m_height);
        JButton jButton = new JButton(Messages.getString("OfflineDatamoveDialog.1"));
        jButton.addActionListener(actionListener);
        this.m_dlg.addCustomButton((Component)jButton);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_offlinedatamove_html");
        this.m_dlg.setSize(this.m_width, this.m_height);
        this.m_dlg.setPreferredSize(this.m_width, this.m_height);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.m_dlg);
    }

    private boolean checkConvId() {
        boolean bl = false;
        DBObjectId dBObjectId = null;
        if (this.m_known) {
            bl = true;
        } else if (this.m_comboBox.getSelectedItem() != null) {
            MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)this.m_comboBox.getSelectedItem();
            this.m_mdConnection = migrationConnectionNode.getMdConnection();
            dBObjectId = this.m_mdConnection.getKey();
            if (dBObjectId != null) {
                bl = true;
            }
        } else {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MIGRATION_OFFLINE_DATA_MOVE_NOCONVID_TEXT"), (String)MigrationAddinArb.getString("MIGRATION_OFFLINE_DATA_MOVE_NOCONVID_TITLE"), (String)"f1_offlineDatamoveNoCovertID_html");
        }
        return bl;
    }

    private boolean checkDir() {
        String string = this.directoryTextField.getText();
        if (string.equals("")) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("OFFLINE_DATA_MOVE_GENDIR_TEXT"), (String)MigrationAddinArb.getString("OFFLINE_DATA_MOVE_GENDIR_TITLE"), (String)"f1_offlineDatamoveNoGenDir_html");
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("OFFLINE_DATA_MOVE_DIR_NONEXISTENT"), (String)MigrationAddinArb.getString("OFFLINE_DATA_MOVE_GENDIR_TITLE"), (String)"f1_offlineDatamoveNoGenDir_html");
            return false;
        }
        if (!file.canRead() || !file.canWrite()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("OFFLINE_DATA_MOVE_DIR_PERMISSIONS_ERR"), (String)MigrationAddinArb.getString("OFFLINE_DATA_MOVE_GENDIR_TITLE"), (String)"f1_offlineDatamoveNoGenDir_html");
            return false;
        }
        return true;
    }

    public void launch() {
        this.m_known = true;
        DBObject dBObject = this.getDBObject();
        ConvertedConnectionNode convertedConnectionNode = (ConvertedConnectionNode)dBObject.getElement();
        this.m_mdConnection = convertedConnectionNode.getMdConnection();
        this.dlgInit();
        this.m_dlg.setVisible(true);
    }

    public void launchunknownMenu() {
        this.dlgInit();
        this.m_dlg.setVisible(true);
    }
}

