/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.util.MigrationResourceManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.EditableGridController;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.controls.grid.ResultSetTableCellRenderer;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CHAR;

public class IdentifierMappingPanel
extends JPanel
implements IActionUpdater {
    private static final long serialVersionUID = 1L;
    private String _capturedConnName = null;
    private JScrollPane m_scrollPane = null;
    private Toolbar m_toolbar = null;
    private EditableResultSetTable m_table = null;
    private boolean m_initialized = false;
    protected String DEFAULT_ALL_CHANGES_CMD = "impanel.all.default";
    protected String DEFAULT_SELECT_CHANGES_CMD = "impanel.select.default";
    int DEFAULT_ALL_CHANGES_ID = Ide.findOrCreateCmdID((String)this.DEFAULT_ALL_CHANGES_CMD);
    int DEFAULT_SELECT_CHANGES_ID = Ide.findOrCreateCmdID((String)this.DEFAULT_SELECT_CHANGES_CMD);
    IdeAction DEFAULT_ALL_ACTION = IdeAction.get((int)this.DEFAULT_ALL_CHANGES_ID, null, (String)MigrationAddinArb.getString("IDENT_ALL_DEFAULT"), null, null, (Icon)MigrationResourceManager.getIcon(IdentifierMappingPanel.class, "/oracle/dbtools/migration/workbench/core/images/migidentifiermapall.png"), null, (boolean)false);
    IdeAction DEFAULT_SELECT_ACTION = IdeAction.get((int)this.DEFAULT_SELECT_CHANGES_ID, null, (String)MigrationAddinArb.getString("IDENT_SEL_DEFAULT"), null, null, (Icon)MigrationResourceManager.getIcon(IdentifierMappingPanel.class, "/oracle/dbtools/migration/workbench/core/images/mig_identifiermap_single.png"), null, (boolean)false);
    private String m_table_alias = "T";
    private String m_view_alias = "V";
    public final String TABLE_ALIAS = "T.";
    public final String VIEW_ALIAS = "V.";
    private final Integer ORIGINAL_IDENTIFIER = 0;
    private final Integer NEW_IDENTIFIER = 1;
    private final Integer TRANSFORMED = 2;
    private final Integer QUALIFIEDNAME = 3;
    private final Integer SRC_TYPE = 4;
    private final String TRANSFORMED_VALUE = "Y";
    private List<String> m_uneditCols = new ArrayList<String>();
    private List<String> m_editCols = new ArrayList<String>();
    private IMController _controller = null;
    private IMContextMenuItems _cm = null;
    private String _captId = null;

    public IdentifierMappingPanel(String string, String string2) {
        this._capturedConnName = string;
        this._captId = string2;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_convertionIdentifierMap_html");
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.m_toolbar != null) {
            this.m_toolbar.setVisible(bl);
        }
        if (this.m_table != null) {
            this.m_table.setEditable(bl);
        }
    }

    public void init() {
        this.m_toolbar = new Toolbar();
        this.m_table = new EditableResultSetTable(this){
            private static final long serialVersionUID = 1L;

            public void addColumn(TableColumn tableColumn) {
                super.addColumn(tableColumn);
                EditableResultSetTableModel editableResultSetTableModel = IdentifierMappingPanel.this.m_table.getGridModel();
                int n = tableColumn.getModelIndex();
                ResultSetGridColumn resultSetGridColumn = (ResultSetGridColumn)editableResultSetTableModel.getGridColumns().get(n);
                if (resultSetGridColumn.getOriginal().equals("ORIGINAL_IDENTIFIER")) {
                    tableColumn.setHeaderValue(MigrationAddinArb.getString("ORIGINAL_IDENTIFIER"));
                    tableColumn.setIdentifier("ORIGINAL_IDENTIFIER");
                } else if (resultSetGridColumn.getOriginal().equals("NEW_IDENTIFIER")) {
                    tableColumn.setHeaderValue(MigrationAddinArb.getString("NEW_IDENTIFIER"));
                    tableColumn.setIdentifier("NEW_IDENTIFIER");
                } else {
                    if (resultSetGridColumn.getOriginal().equals("TRANSFORMED")) {
                        tableColumn.setHeaderValue(MigrationAddinArb.getString("TRANSFORMED"));
                        tableColumn.setIdentifier("TRANSFORMED");
                        tableColumn.setCellRenderer((TableCellRenderer)new ResultSetTableCellRenderer(){
                            private static final long serialVersionUID = 1L;

                            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                                JCheckBox jCheckBox = new JCheckBox();
                                jCheckBox.setHorizontalAlignment(0);
                                jCheckBox.setBackground(IdentifierMappingPanel.this.m_table.getBackground());
                                String string = null;
                                try {
                                    string = ((CHAR)object).getString();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (string != null && string.equals("Y")) {
                                    jCheckBox.setSelected(true);
                                } else {
                                    jCheckBox.setSelected(false);
                                }
                                return jCheckBox;
                            }
                        });
                        return;
                    }
                    if (resultSetGridColumn.getOriginal().equals("QUALIFIEDNAME")) {
                        tableColumn.setHeaderValue(MigrationAddinArb.getString("QUALIFIEDNAME"));
                        tableColumn.setIdentifier("QUALIFIEDNAME");
                    } else if (resultSetGridColumn.getOriginal().equals("SRC_TYPE")) {
                        tableColumn.setHeaderValue(MigrationAddinArb.getString("SRC_TYPE"));
                        tableColumn.setIdentifier("SRC_TYPE");
                    } else {
                        return;
                    }
                }
            }
        };
        this.m_table.setInsertAllowed(false);
        this.m_table.setDeleteAllowed(false);
        this.m_table.setCommitActionAllowed(false);
        this.m_table.setRollbackActionAllowed(false);
        this._controller = new IMController(this.m_table.getController());
        this._cm = new IMContextMenuItems();
        this.m_table.addLocalContextMenuListener((GridContextMenuItem)this._cm);
        this.enableAcceleratorKeyStroke();
        String string = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            string = this.buildSql(hashMap);
        }
        catch (Exception exception) {
            return;
        }
        DBObject dBObject = DBObject.getDBObjectForName((String)"MD_DERIVATIVES", (String)this._capturedConnName);
        this.m_table.setQuery(this._capturedConnName, string, null, hashMap, dBObject, this.m_uneditCols, this.m_editCols);
        this.m_table.registerGridUpdater((IRaptorGridUpdater)new IMGridUpdater(new EditableResultSetTableModel.DataTabGridUpdater(this.m_table.getGridModel())));
        this.m_table.getGridModel().setDataIntegrityColumnNames(Arrays.asList("T.ROWID", "T.ORA_ROWSCN"));
        try {
            this.m_table.open(new RaptorEditableGridTaskWrapper(MigrationAddinArb.getString("QUERY_TITLE"), IRaptorTaskRunMode.NO_GUI, false, null, null, null, null));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this._controller.addToolBarActions(this.m_toolbar);
        this.m_scrollPane = new JScrollPane((Component)this.m_table, 22, 30);
        this.setLayout(new BorderLayout());
        this.m_scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JViewport jViewport = new JViewport();
        jViewport.setView(this.m_table.getRowHeader());
        jViewport.setPreferredSize(this.m_table.getRowHeader().getMaximumSize());
        this.m_scrollPane.setRowHeader(jViewport);
        this.add((Component)this.m_toolbar, "North");
        this.add((Component)this.m_scrollPane, "Center");
        this.m_table.addMouseListener((MouseListener)new IMMouseAdaptor());
        this.m_initialized = true;
    }

    private void enableAcceleratorKeyStroke() {
        final KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        keyStrokeOptions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                IdentifierMappingPanel.this.updateKeyMap(keyStrokeOptions);
            }
        });
        this.updateKeyMap(keyStrokeOptions);
    }

    private void updateKeyMap(KeyStrokeOptions keyStrokeOptions) {
        UIUtils.addIdeKeyBindings((JComponent)this.m_table, (int)1, (String)"oracle/dbtools/raptor/oviewer/base/accelerators.xml");
        UIUtils.setupAccelerators((Toolbar)this.m_toolbar);
    }

    public void cleanUp() {
        if (this.m_table != null) {
            this.m_table.closeModel();
        }
        this.m_initialized = false;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public List<RaptorGridRowModel> getChangedRows() {
        List<Object> list = new ArrayList<RaptorGridRowModel>();
        if (this.m_table != null) {
            list = ((EditableResultSetTableModel)this.m_table.getModel()).getChangedRows();
        }
        return list;
    }

    public EditableResultSetTableModel getModel() {
        EditableResultSetTableModel editableResultSetTableModel = null;
        if (this.m_table != null) {
            editableResultSetTableModel = this.m_table.getGridModel();
        }
        return editableResultSetTableModel;
    }

    public void updateActions() {
        View.updateToolbarActions((Toolbar)this.m_toolbar);
        this.DEFAULT_ALL_ACTION.setEnabled(!this.m_table.isChanged());
        this.DEFAULT_SELECT_ACTION.setEnabled(this.m_table.isCellSelected(this.m_table.getSelectedRow(), this.getNewIdentifierColumn()));
    }

    public void save() {
        if (this.m_table != null && this.m_table.isChanged()) {
            this.m_table.save();
        }
    }

    public boolean isChanged() {
        if (this.m_table != null) {
            return this.m_table.isChanged();
        }
        return false;
    }

    private final String buildSql(HashMap<String, Object> hashMap) throws Exception {
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        hashMap2.put(this.ORIGINAL_IDENTIFIER, "ORIGINAL_IDENTIFIER");
        hashMap2.put(this.NEW_IDENTIFIER, "NEW_IDENTIFIER");
        hashMap2.put(this.TRANSFORMED, "TRANSFORMED");
        hashMap2.put(this.QUALIFIEDNAME, "QUALIFIEDNAME");
        hashMap2.put(this.SRC_TYPE, "SRC_TYPE");
        hashMap.put("CAPID", this._captId);
        String string = "/* + INDEX_COMBINE ";
        string = string + "(" + this.m_table_alias + " " + "MD_DERIVATIVES_PERF_IDX MD_DERIVATIVES_PERF_IDX1 MD_DERIVATIVES_PERF_IDX2 MD_DERIVATIVES_PERF_IDX3) */";
        String string2 = "SELECT " + string + " ";
        string2 = string2 + "T." + (String)hashMap2.get(this.ORIGINAL_IDENTIFIER) + ", ";
        string2 = string2 + "T." + (String)hashMap2.get(this.NEW_IDENTIFIER) + ", ";
        string2 = string2 + "T." + (String)hashMap2.get(this.TRANSFORMED) + ", ";
        string2 = string2 + "V." + (String)hashMap2.get(this.QUALIFIEDNAME) + ", ";
        string2 = string2 + "T." + (String)hashMap2.get(this.SRC_TYPE) + " FROM MD_DERIVATIVES " + this.m_table_alias + ", " + "MGV_ALL_DETAILS " + this.m_view_alias;
        string2 = string2 + " WHERE V.CONNID = :CAPID AND T.DERIVED_CONNECTION_ID_FK = :CAPID";
        string2 = string2 + " AND V.CAPTUREDORCONVERTED = 'CAPTURED' AND T.SRC_TYPE <> 'MD_CATALOGS' AND V.OBJTYPE = ";
        string2 = string2 + "T.SRC_TYPE AND V.OBJID = T.SRC_ID ORDER BY T." + (String)hashMap2.get(this.ORIGINAL_IDENTIFIER);
        this.m_uneditCols.add((String)hashMap2.get(this.ORIGINAL_IDENTIFIER));
        this.m_uneditCols.add((String)hashMap2.get(this.TRANSFORMED));
        this.m_uneditCols.add((String)hashMap2.get(this.QUALIFIEDNAME));
        this.m_uneditCols.add((String)hashMap2.get(this.SRC_TYPE));
        this.m_editCols.add((String)hashMap2.get(this.NEW_IDENTIFIER));
        return string2;
    }

    public int getNewIdentifierColumn() {
        return this.NEW_IDENTIFIER;
    }

    public void generateDefaultNewIdentifiers() {
        final EditableResultSetTableModel editableResultSetTableModel = this.m_table.getGridModel();
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    editableResultSetTableModel.fetchAllRows(true);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
        };
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                    int n = editableResultSetTableModel.getRowCount();
                    for (int i = 0; i < n; ++i) {
                        String string;
                        String string2;
                        String string3 = ((CHAR)IdentifierMappingPanel.this.m_table.getValueAt(i, IdentifierMappingPanel.this.ORIGINAL_IDENTIFIER.intValue())).getString();
                        String string4 = ((CHAR)IdentifierMappingPanel.this.m_table.getValueAt(i, IdentifierMappingPanel.this.NEW_IDENTIFIER.intValue())).getString();
                        if (string4.equals(string2 = IdentifierMappingPanel.this.getDerivedIdentifier(string3, string = ((CHAR)IdentifierMappingPanel.this.m_table.getValueAt(i, IdentifierMappingPanel.this.SRC_TYPE.intValue())).getString()))) continue;
                        CHAR cHAR = new CHAR(string2, CHAR.DEFAULT_CHARSET);
                        IdentifierMappingPanel.this.m_table.setValueAt((Object)cHAR, i, IdentifierMappingPanel.this.NEW_IDENTIFIER.intValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    private void generateDefaultSelectedNewIdentifiers() {
        int[] nArray = this.m_table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            try {
                String string;
                String string2;
                if (!this.m_table.isCellSelected(nArray[i], this.NEW_IDENTIFIER.intValue())) continue;
                String string3 = ((CHAR)this.m_table.getValueAt(nArray[i], this.ORIGINAL_IDENTIFIER.intValue())).stringValue();
                String string4 = this.m_table.getValueAt(nArray[i], this.NEW_IDENTIFIER.intValue()).toString();
                if (string4.equals(string2 = this.getDerivedIdentifier(string3, string = ((CHAR)this.m_table.getValueAt(nArray[i], this.SRC_TYPE.intValue())).getString()))) continue;
                CHAR cHAR = new CHAR(string2, CHAR.DEFAULT_CHARSET);
                this.m_table.setValueAt((Object)cHAR, nArray[i], this.NEW_IDENTIFIER.intValue());
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    private String getDerivedIdentifier(String string, String string2) throws Exception {
        Connection connection;
        String string3 = null;
        if (string2.equals("MD_SCHEMAS")) {
            string = this.getDefaultIdentifier(string);
        }
        if ((connection = Connections.getInstance().getConnection(this._capturedConnName)) != null) {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ?:= MIGRATION_TRANSFORMER.TRANSFORM_IDENTIFIER(?)}");
            oracleCallableStatement.registerOutParameter(1, 12);
            oracleCallableStatement.setString(2, string);
            oracleCallableStatement.execute();
            string3 = oracleCallableStatement.getString(1);
            oracleCallableStatement.close();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultIdentifier(String string) throws Exception {
        DBUtil dBUtil = null;
        ResultSetWrapper resultSetWrapper = null;
        Connection connection = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.getId("MD_CATALOGS", null);
        String string3 = this.getId("MD_SCHEMAS", string);
        if (!(string2 == null && string2.equals("") || string3 == null && string3.equals(""))) {
            String string4 = "select CATALOG_NAME, DUMMY_FLAG from MD_CATALOGS WHERE ID = :CATID";
            hashMap.put("CATID", string2);
            connection = Connections.getInstance().getConnection(this._capturedConnName);
            String string5 = null;
            String string6 = null;
            try {
                if (connection != null) {
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    DBUtil.getConnectionResolver().lock(connection);
                    resultSetWrapper = dBUtil.executeOracleQuery(string4, hashMap);
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        string5 = resultSet.getString(1);
                        string6 = resultSet.getString(2);
                    }
                    if (!string6.equals("Y")) {
                        string = string + "_" + string5;
                    }
                }
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                DBUtil.getConnectionResolver().unlock(connection);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getId(String string, String string2) throws Exception {
        String string3 = null;
        String string4 = null;
        DBUtil dBUtil = null;
        ResultSetWrapper resultSetWrapper = null;
        Connection connection = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string2 == null || string2.equals("")) {
            string4 = "SELECT SRC_ID FROM MD_DERIVATIVES WHERE DERIVED_CONNECTION_ID_FK = :CAPTID AND SRC_TYPE = ':SRCTYPE'";
        } else {
            string4 = "SELECT SRC_ID FROM MD_DERIVATIVES WHERE DERIVED_CONNECTION_ID_FK = :CAPTID AND SRC_TYPE = ':SRCTYPE' AND ORIGINAL_IDENTIFIER = ':OID'";
            hashMap.put("OID", string2);
        }
        hashMap.put("SRCTYPE", string);
        hashMap.put("CAPTID", this._captId);
        try {
            connection = Connections.getInstance().getConnection(this._capturedConnName);
            if (connection != null) {
                dBUtil = DBUtil.getInstance((Connection)connection);
                DBUtil.getConnectionResolver().lock(connection);
                resultSetWrapper = dBUtil.executeOracleQuery(string4, hashMap);
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    string3 = resultSet.getString(1);
                }
            }
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            DBUtil.getConnectionResolver().unlock(connection);
        }
        return string3;
    }

    private class IMContextMenuItems
    extends GridContextMenuItem {
        IMContextMenuItems() {
            IdentifierMappingPanel.this.DEFAULT_ALL_ACTION.addController((Controller)this);
            IdentifierMappingPanel.this.DEFAULT_SELECT_ACTION.addController((Controller)this);
        }

        protected boolean canShow(ContextMenu contextMenu) {
            boolean bl;
            boolean bl2 = bl = this._table != null && this._table.isEditable() && !this._table.isVerticalDisplay();
            if (bl && this._table instanceof EditableResultSetTable && this._table == IdentifierMappingPanel.this.m_table) {
                bl = true;
            }
            return bl;
        }

        protected void createAndShowMenu(ContextMenu contextMenu) {
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)IdentifierMappingPanel.this.DEFAULT_ALL_ACTION);
            contextMenu.add((Component)jMenuItem);
            JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)IdentifierMappingPanel.this.DEFAULT_SELECT_ACTION);
            contextMenu.add((Component)jMenuItem2);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return IdentifierMappingPanel.this._controller.handleEvent(ideAction, context);
        }

        public boolean update(IdeAction ideAction, Context context) {
            return IdentifierMappingPanel.this._controller.update(ideAction, context);
        }
    }

    private class IMGridUpdater
    implements IRaptorGridUpdater {
        IRaptorGridUpdater superUpdater = null;

        public IMGridUpdater(EditableResultSetTableModel.DataTabGridUpdater dataTabGridUpdater) {
            this.superUpdater = dataTabGridUpdater;
        }

        public int insertRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            return 0;
        }

        public int deleteRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            return 0;
        }

        public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            if (this.superUpdater != null) {
                return this.superUpdater.updateRows(string, list, iRaptorTaskProgressUpdater, list2);
            }
            return 0;
        }

        public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
            ResultSetGridColumn resultSetGridColumn;
            EditableResultSetTableModel editableResultSetTableModel = IdentifierMappingPanel.this.m_table.getGridModel();
            if (editableResultSetTableModel != null && (resultSetGridColumn = (ResultSetGridColumn)editableResultSetTableModel.getGridColumns().get(n2)).getOriginal().equals("NEW_IDENTIFIER")) {
                Object object2;
                List list = editableResultSetTableModel.getGridColumns();
                int n3 = -1;
                int n4 = -1;
                int n5 = -1;
                for (int i = 0; i < list.size(); ++i) {
                    object2 = (ResultSetGridColumn)list.get(i);
                    if (object2.getOriginal().equals("ORIGINAL_IDENTIFIER")) {
                        n3 = i;
                        continue;
                    }
                    if (object2.getOriginal().equals("NEW_IDENTIFIER")) {
                        n4 = i;
                        continue;
                    }
                    if (!object2.getOriginal().equals("TRANSFORMED")) continue;
                    n5 = i;
                }
                String string2 = null;
                object2 = null;
                try {
                    Object object3;
                    if (n3 != -1 && (object3 = editableResultSetTableModel.getValueAt(n, n3)) != null) {
                        string2 = ((CHAR)object3).getString();
                    }
                    if (n4 != -1 && (object3 = editableResultSetTableModel.getValueAt(n, n4)) != null) {
                        object2 = DataTypesUtil.stringValue((Object)object3, (Connection)Connections.getInstance().getConnection(IdentifierMappingPanel.this._capturedConnName));
                    }
                    if (!object2.equals(string2)) {
                        object3 = new CHAR("Y", CHAR.DEFAULT_CHARSET);
                        editableResultSetTableModel.setValueAt(object3, n, n5);
                    } else {
                        object3 = new CHAR("", CHAR.DEFAULT_CHARSET);
                        editableResultSetTableModel.setValueAt(object3, n, n5);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public void setGridInfo(EditableGridInfo editableGridInfo) {
        }
    }

    class IMMouseAdaptor
    extends MouseAdapter {
        IMMouseAdaptor() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            IdentifierMappingPanel.this.updateActions();
        }
    }

    class IMController
    implements Controller {
        private EditableGridController _super = null;
        private boolean _cmAdded = false;

        public IMController(EditableGridController editableGridController) {
            this._super = editableGridController;
            IdentifierMappingPanel.this.DEFAULT_ALL_ACTION.addController((Controller)this);
            IdentifierMappingPanel.this.DEFAULT_SELECT_ACTION.addController((Controller)this);
        }

        public void addToolBarActions(Toolbar toolbar) {
            toolbar.add((ToggleAction)IdentifierMappingPanel.this.DEFAULT_ALL_ACTION);
            IdentifierMappingPanel.this.DEFAULT_ALL_ACTION.addController((Controller)this);
            toolbar.add((ToggleAction)IdentifierMappingPanel.this.DEFAULT_SELECT_ACTION);
            IdentifierMappingPanel.this.DEFAULT_SELECT_ACTION.addController((Controller)this);
            this._super.addToolBarActions(toolbar);
        }

        public void addContextMenuActions(ContextMenu contextMenu) {
            if (!this._cmAdded) {
                this._cmAdded = true;
                JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)IdentifierMappingPanel.this.DEFAULT_ALL_ACTION);
                contextMenu.add((Component)jMenuItem);
                jMenuItem = contextMenu.createMenuItem((ToggleAction)IdentifierMappingPanel.this.DEFAULT_SELECT_ACTION);
                contextMenu.add((Component)jMenuItem);
                this._super.addContextMenuActions(contextMenu);
            }
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (this._super.getGrid() == null) {
                return false;
            }
            if (this._super.getGrid() != IdentifierMappingPanel.this.m_table) {
                return false;
            }
            int n = ideAction.getCommandId();
            if (this.isDefaultCommand(n)) {
                IdentifierMappingPanel.this.generateDefaultNewIdentifiers();
                IdentifierMappingPanel.this.m_table.changeSelection(0, IdentifierMappingPanel.this.NEW_IDENTIFIER.intValue(), false, false);
                IdentifierMappingPanel.this.m_scrollPane.getVerticalScrollBar().setValue(IdentifierMappingPanel.this.m_scrollPane.getVerticalScrollBar().getMinimum());
                IdentifierMappingPanel.this.m_table.clearSelection();
            } else if (this.isDefaultSingleCommand(n)) {
                IdentifierMappingPanel.this.generateDefaultSelectedNewIdentifiers();
            } else {
                return this._super.handleEvent(ideAction, context);
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (!this._super.isGridReady()) {
                ideAction.setEnabled(false);
                return true;
            }
            int n = ideAction.getCommandId();
            if (this.isDefaultCommand(n)) {
                ideAction.setEnabled(!this._super.getGrid().isChanged());
            } else if (this.isDefaultSingleCommand(n)) {
                ideAction.setEnabled(this._super.getGrid().isCellSelected(this._super.getGrid().getSelectedRow(), IdentifierMappingPanel.this.getNewIdentifierColumn()));
            } else {
                this._super.update(ideAction, context);
            }
            return true;
        }

        boolean isDefaultCommand(int n) {
            return n == IdentifierMappingPanel.this.DEFAULT_ALL_CHANGES_ID;
        }

        boolean isDefaultSingleCommand(int n) {
            return n == IdentifierMappingPanel.this.DEFAULT_SELECT_CHANGES_ID;
        }
    }
}

