/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Desktop;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureCmd;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.capture.OfflineCaptureWorker;
import oracle.dbtools.migration.capture.OnlineCaptureWorker;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.convert.ConvertEvent;
import oracle.dbtools.migration.convert.ConvertEventListener;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveWorker;
import oracle.dbtools.migration.datamove.offline.OfflineSQLLoaderPrintStream;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.datamove.online.DataMoveWorker;
import oracle.dbtools.migration.estimation.RSTableMigrationEstimateXLS;
import oracle.dbtools.migration.generate.GenerateEvent;
import oracle.dbtools.migration.generate.GenerateEventListener;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.generate.SimpleGenerationOutputStream;
import oracle.dbtools.migration.persistence.MigrDatatypeTransformMap;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.editor.OpenWorksheetWizard;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;

public class FullMigrateTask
extends DatabaseQueryTask<Boolean> {
    private MigrationPlugin m_plugin;
    private URL m_url;
    private String m_generationConnectionName;
    private String m_sourceConnectionName;
    private File m_generateSQLFile;
    private String _scriptName;
    private boolean m_leastPrivilege = false;
    private boolean m_needToCreateARepo = false;
    private String m_currentStep = null;
    private ThirdPartyDbProvider m_provider;
    private CaptureWorker m_captureWorker;
    private DataMoveWorker m_dataMoveWorker;
    private ConverterWorker m_convertWorker;
    private GenerateWorker m_generateWorker;
    private CountDownLatch _cancelSignal;
    private MigrationCmd captCmd;
    private Thread _cancelThread;
    private Thread _eeStatusThread;
    private volatile boolean m_topLevelCancel = false;
    private volatile boolean m_cancelCapture = false;
    private volatile boolean m_cancelConvert = false;
    private volatile boolean m_cancelDataMove = false;
    private volatile boolean m_cancelGenerateWorker = false;
    private int _actionMask;
    private Properties _actionParams;
    private long _projectId;
    private String _repoName;
    private MdProject _project;
    private MdConnection _captConn;
    private MdConnection _convConn;
    private Connection _genTargetConn;
    private Connection _dmTargetConn;
    private static Logger s_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    protected static final Logger LOGGER = Logger.getLogger(FullMigrateTask.class.getName());
    public static final String MIGRATION_TYPE = "MIGRATION_TYPE";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String PROJ_OUTPUTDIR = "PROJ_OUTPUTDIR";
    public static final String PLUGIN = "PLUGIN";
    public static final String REPOSITORY_CONNECTION = "REPOSITORY_CONNECTION";
    public static final String REPOSITORY_KEEP = "REPOSITORY_KEEP";
    public static final String SOURCE_CONNECTION = "SOURCE_CONNECTION";
    public static final String SOURCE_CONNECTION_OBJ = "SOURCE_CONNECTION_OBJ";
    public static final String TARGET_CONNECTION = "TARGET_CONNECTION";
    public static final String DO_CAPTURE = "DO_CAPTURE";
    public static final String DO_CONVERT = "DO_CONVERT";
    public static final String CAPTURED_CONNECTION = "CAPTURED_CONNECTION";
    public static final String PARAM_ELEMENT = "CTX_ELEMENT";
    public static final String PARAM_REPO_CONN = "REPO_CONN";
    public static final String PARAM_REPO_TRUNC = "REPO_TRUNC";
    public static final String PARAM_PROJ_NAME = "PROJ_NAME";
    public static final String PARAM_PROJ = "PARAM_PROJ";
    public static final String PARAM_PROJ_DESC = "PROJ_DESC";
    public static final String PARAM_PROJ_OUTDIR = "PROJ_OUTDIR";
    public static final String PARAM_CAPT_MODE = "CAPT_MODE";
    public static final String PARAM_CAPT_SRCCONN = "CAPT_SRCCONN";
    public static final String PARAM_CAPT_OCPPATH = "CAPT_OCPPATH";
    public static final String PARAM_CAPT_ENCODING = "CAPT_ENCODING";
    public static final String PARAM_CAPT_DBLIST = "CAPT_DBLIST";
    public static final String PARAM_PLATFORM_NAME = "PLATFORM_NAME";
    public static final String PARAM_ESTIMATION_XLSNAME = "PARAM_ESTIMATION_XLSNAME";
    public static final String PARAM_CONV_CATPCONN = "CONV_CATPCONN";
    public static final String PARAM_CONV_CONVCONN = "CONV_CONVCONN";
    public static final String PARAM_CONV_DTMAP = "CONV_DTMAP";
    public static final String PARAM_CONV_DTMAP_CHANGED = "CONV_DTMAP_CHANGED";
    public static final String PARAM_CONV_IDMAP = "CONV_IDMAP";
    public static final String PARAM_CONV_IDMAP_CHANGED = "CONV_IDMAP_CHANGED";
    public static final String PARAM_CONV_IDMAP_TBLMODEL = "CONV_IDMAP_TBLMODEL";
    public static final String PARAM_GEN_MODE = "GEN_MODE";
    public static final String PARAM_GEN_TGTCONN = "GEN_TGTCONN";
    public static final String PARAM_GEN_DROP_ENABLED = "GEN_DROP_ENABLED";
    public static final String PARAM_GEN_SCRIPTDIR = "GEN_SCRIPTDIR";
    public static final String PARAM_DM_MODE = "DM_MODE";
    public static final String PARAM_DM_SRCCONN = "DM_SRCCONN";
    public static final String PARAM_DM_TGTCONN = "DM_TGTCONN";
    public static final String PARAM_DM_TRUNC_ENABLED = "DM_TRUNC_ENABLED";
    public static final String PARAM_DM_SCRIPTDIR = "DM_SCRIPTDIR";
    private static final String CAPTURE_MODE_ONLINE = "Online";
    private static final String CAPTURE_MODE_OFFLINE = "Offline";
    public static final int ACTN_REPO_CREATE = 2;
    public static final int ACTN_PROJ_CREATE = 4;
    public static final int ACTN_CAPTURE = 8;
    public static final int ACTN_CONVERT = 16;
    public static final int ACTN_GENERATE = 32;
    public static final int ACTN_DATAMOVE = 64;
    public static final int ACTN_ESTIMATION = 128;
    private static final String KEY_DELIMITER = "$#$";

    public FullMigrateTask(int n, Properties properties, String string) {
        super(string == null ? MigrationAddinArb.get("FULLMIGRATION_TITLE") : string, IRaptorTaskRunMode.MODAL, false, true, true);
        this._actionMask = n;
        this._actionParams = properties;
        this._repoName = properties.getProperty(PARAM_REPO_CONN);
        try {
            if (this._repoName == null || this._repoName.trim().length() == 0) {
                this._repoName = MigrationAddin.getDefaultMigrationRepository();
            }
            Connections.getInstance().getConnection(this._repoName);
            if (!MigrationAddin.isRepositoryOpen()) {
                MigrationAddin.openRepository(this._repoName);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    public FullMigrateTask(int n, Properties properties) {
        this(n, properties, null);
    }

    protected Boolean doWork() throws TaskException {
        Boolean bl = Boolean.TRUE;
        Exception exception = null;
        try {
            this.initPlugin();
            this.doMaskBasedActions();
            if (this._actionParams.get(PARAM_ELEMENT) == null) {
                this.notifyNavigator((Element)MigrationProjectsFolderNode.getInstance());
            }
        }
        catch (Exception exception2) {
            exception = exception2;
            if (this._eeStatusThread != null) {
                this._eeStatusThread.interrupt();
            }
            MigrationLogUtil.logThrowable(exception2.getLocalizedMessage(), exception2.getStackTrace(), (Throwable)exception2);
            bl = Boolean.FALSE;
        }
        if (bl != null && bl.equals(Boolean.FALSE) || exception != null) {
            this.setMessage(this.getDescriptor().getMessage() + ": " + MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_TEST_FAIL"));
            s_logger.log(Level.WARNING, this.getDescriptor().getMessage() + " : " + MigrationAddinArb.getString("QUICKMIGRATE_DIALOG_TITLE") + " : " + MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_TEST_FAIL"));
        } else {
            this.setMessage(MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_TEST_SUCCESS"));
        }
        MigrationLogUtil.endMigrationLogSession();
        if (exception != null) {
            throw new TaskException((Throwable)exception);
        }
        return bl;
    }

    public String getConnectionName() {
        return this.m_sourceConnectionName;
    }

    public String getQuery() {
        return MigrationAddinArb.getString("QUICKMIGRATE_DIALOG_TITLE");
    }

    public boolean cancel() {
        this.m_topLevelCancel = true;
        this.passCancelOn();
        return true;
    }

    private void passCancelOn() {
        if (this.m_cancelCapture) {
            if (this.m_captureWorker != null) {
                this.m_captureWorker.signalCancel();
            }
            if (this.captCmd != null && this._cancelSignal != null) {
                this._cancelSignal.countDown();
            }
        }
        if (this.m_cancelConvert && this.m_convertWorker != null) {
            this.m_convertWorker.signalCancel();
        }
        if (this.m_cancelDataMove && this.m_dataMoveWorker != null) {
            this.m_dataMoveWorker.signalCancel();
        }
        if (this.m_cancelGenerateWorker && this.m_generateWorker != null) {
            this.m_generateWorker.signalCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaskBasedActions() throws Exception {
        try {
            if ((this._actionMask & 2) > 0) {
                this.doCreateRepository();
            }
            if ((this._actionMask & 4) > 0) {
                this.doCreateProject();
            }
            if ((this._actionMask & 8) > 0) {
                this.doCapture();
            }
            if ((this._actionMask & 0x80) > 0) {
                this.doEstimationToXls();
            }
            if ((this._actionMask & 0x10) > 0) {
                this.doConvert();
            }
            if ((this._actionMask & 0x20) > 0) {
                this.doGenerate();
            }
            if ((this._actionMask & 0x40) > 0) {
                this.doDataMove();
            }
        }
        finally {
            Element element = (Element)this._actionParams.get(PARAM_ELEMENT);
            this.notifyNavigator(element);
        }
    }

    private void doCreateRepository() throws Exception {
        boolean bl = false;
        if (this.m_topLevelCancel) {
            return;
        }
        if (this._actionParams.get(PARAM_REPO_TRUNC) != null) {
            bl = (Boolean)this._actionParams.get(PARAM_REPO_TRUNC);
        }
        String string = this._actionParams.getProperty(PARAM_REPO_CONN);
        Connection connection = Connections.getInstance().getConnection(string);
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        if (RepositoryManager.doesRepositoryExist(connection)) {
            if (bl) {
                this.setMessage(MigrationAddinArb.getString("MIGRATION_TRUNCATE_REPOSITORY_TEXT"));
                RunRepositoryScripts runRepositoryScripts = new RunRepositoryScripts(connection);
                runRepositoryScripts.setUpdater(this.getRaptorTaskProgressUpdater());
                runRepositoryScripts.setMode(4);
                runRepositoryScripts.setScript("purgeRepository.sql");
                runRepositoryScripts.run();
            }
            this.setMessage(MigrationAddinArb.format(MigrationAddinArb.getString("DEFAULT_REPOSITORY_CHANGED"), string));
            migrationConfig.addRepository(string);
            migrationConfig.setDefaultRepository(string);
            this._repoName = string;
        } else {
            RunRepositoryScripts runRepositoryScripts = new RunRepositoryScripts(connection);
            runRepositoryScripts.setUpdater(this.getRaptorTaskProgressUpdater());
            runRepositoryScripts.setMode(1);
            runRepositoryScripts.setScript("CREATE_REPOSITORY.sql");
            this.setMessage(MigrationAddinArb.getString("FULLMIGRATION_TOOLTUP_CREATEREPO"));
            runRepositoryScripts.run();
            this.setMessage(MigrationAddinArb.getString("REPOSITORY_BUILT"));
            migrationConfig.addRepository(string);
            migrationConfig.setDefaultRepository(string);
        }
    }

    private void doCreateProject() throws Exception {
        String string = this._actionParams.getProperty(PARAM_PROJ_NAME);
        String string2 = this._actionParams.getProperty(PARAM_PROJ_DESC);
        String string3 = this._actionParams.getProperty(PARAM_PROJ_OUTDIR);
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
        this.m_cancelConvert = true;
        if (this.m_topLevelCancel) {
            return;
        }
        MdProject mdProject = null;
        try {
            this.setMessage(MigrationAddinArb.getString("FULLMIGRATION_TOOLTIP_CREATEPROJECT"));
            mdProject = persistenceUtility.getNamedProject(string);
            if (mdProject == null) {
                mdProject = new MdProject(string);
                mdProject.setComments(string2);
                mdProject.save(persistenceManager);
                this._project = mdProject;
                this.setProjectOutputDir(string3);
                this._actionParams.put(PARAM_PROJ, this._project);
                this.setMessage(MigrationAddinArb.getString("FULLMIGRATION_TOOLTIP_PROJECTBUILD"));
            }
        }
        catch (PersistenceException persistenceException) {
            FullMigrateTask.log(persistenceException);
        }
    }

    private boolean isClassicSqlServerMigration(String string) {
        boolean bl = true;
        String string2 = null;
        if (string == null) {
            return false;
        }
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            string2 = connection.getMetaData().getDatabaseProductVersion();
            if (!string2.startsWith("07") && !string2.startsWith("08")) {
                bl = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEstimationToXls() throws Exception {
        Object object;
        String string = null;
        File file = null;
        try {
            string = this.createTemporaryConnection();
            object = new HashMap<String, Object>();
            object.put("IDPROJECT", this._project.getKey().getId());
            object.put("IDCAPCONNECTION", this._captConn.getKey().getId());
            RSTableMigrationEstimateXLS rSTableMigrationEstimateXLS = RSTableMigrationEstimateXLS.getInstance();
            file = (File)this._actionParams.get(PARAM_ESTIMATION_XLSNAME);
            rSTableMigrationEstimateXLS.createEstimationPlan((Component)Ide.getMainWindow(), string, file, (Map<String, Object>)object);
        }
        catch (Throwable throwable) {
            Object object2;
            if (string != null && (object2 = Connections.getInstance().getConnection(string)) != null) {
                object2.close();
            }
            if (Desktop.isDesktopSupported() && file != null) {
                object2 = Desktop.getDesktop();
                try {
                    ((Desktop)object2).open(file);
                }
                catch (IOException iOException) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)(MigrationAddinArb.getString("MIGRATION_COMPLETE") + "\n" + file.getAbsolutePath()), (String)MigrationAddinArb.getString("MIGRATION_COMPLETE"), null);
                }
            }
            throw throwable;
        }
        if (string != null && (object = Connections.getInstance().getConnection(string)) != null) {
            object.close();
        }
        if (Desktop.isDesktopSupported() && file != null) {
            object = Desktop.getDesktop();
            try {
                ((Desktop)object).open(file);
            }
            catch (IOException iOException) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)(MigrationAddinArb.getString("MIGRATION_COMPLETE") + "\n" + file.getAbsolutePath()), (String)MigrationAddinArb.getString("MIGRATION_COMPLETE"), null);
            }
        }
    }

    private void doCapture() throws Exception {
        String string = this._actionParams.getProperty(PARAM_CAPT_MODE);
        String string2 = this.m_plugin.getPlatformName();
        boolean bl = false;
        String string3 = this._actionParams.getProperty(PARAM_CAPT_SRCCONN);
        this.m_cancelCapture = true;
        if (this.m_topLevelCancel) {
            return;
        }
        if (CAPTURE_MODE_ONLINE.equals(string)) {
            if ("Sybase".equals(string2) || "Microsoft SQL Server".equals(string2) && string3 != null && !this.isClassicSqlServerMigration(string3) || "Teradata".equals(string2)) {
                bl = true;
            }
            if (bl) {
                this.doOnlineEnterpriseCapture();
            } else {
                this.doOnlineClassicCapture();
            }
            this.setCaptureModeOnline();
            this.setSourceConnection();
        } else if (CAPTURE_MODE_OFFLINE.equals(string)) {
            this.doOfflineCapture();
            this.setCaptureModeOffline();
            this.setSourceOcp();
        } else {
            this.clearCaptureMode();
        }
        this._captConn.setStatus("captured");
        this._captConn.save(MigrationAddin.getPersistenceManager());
    }

    private void doOnlineEnterpriseCapture() throws Exception {
        MdProject mdProject;
        this._project = mdProject = this._project != null ? this._project : (MdProject)this._actionParams.get(PARAM_PROJ);
        String string = this._actionParams.getProperty(PARAM_CAPT_SRCCONN).trim();
        Collection collection = (Collection)this._actionParams.get(PARAM_CAPT_DBLIST);
        final PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        this.m_cancelCapture = true;
        if (this.m_topLevelCancel) {
            return;
        }
        Object var5_5 = null;
        String[] stringArray = new String[3];
        stringArray[0] = "-actions=capture";
        StringBuilder stringBuilder = new StringBuilder().append("-conn=");
        Connections.getInstance();
        stringArray[1] = stringBuilder.append(Connections.getDisplayName((String)string)).toString();
        stringArray[2] = this.getDBList(collection);
        WizardMigrationDetails wizardMigrationDetails = new WizardMigrationDetails(stringArray);
        final String string2 = this.m_plugin.getPlatformName();
        final int n = this.m_plugin.getPlatformMask();
        if (mdProject != null) {
            wizardMigrationDetails.put("PROJECT_ID", Long.toString(mdProject.getKey().getId()));
            wizardMigrationDetails.put("project", mdProject.getObjectName());
            wizardMigrationDetails.put("append", "TRUE");
        }
        this.captCmd = MigrationCmdRegistry.getMigrationCmd("capture", wizardMigrationDetails, wizardMigrationDetails.getOut(), true);
        this._cancelThread = new Thread(){

            @Override
            public void run() {
                try {
                    FullMigrateTask.this._cancelSignal.await();
                    if (FullMigrateTask.this.captCmd != null) {
                        FullMigrateTask.this.captCmd.signalCancel();
                    }
                    if (FullMigrateTask.this._eeStatusThread != null) {
                        FullMigrateTask.this._eeStatusThread.interrupt();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this._eeStatusThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Connection connection = null;
                try {
                    connection = Connections.getInstance().cloneConnection(persistenceManager.getConn());
                    Statement statement = null;
                    Object var3_6 = null;
                    String string = null;
                    String string22 = null;
                    if (string2.equals("Sybase")) {
                        string22 = "SYB12ALLPLATFORM";
                    } else if (string2.equals("Microsoft SQL Server") && n != 32 && n != 16) {
                        string22 = "SS2K5ALLPLATFORM";
                    }
                    while (!this.isInterrupted()) {
                        if (string22 != null) {
                            ((CaptureCmd)FullMigrateTask.this.captCmd).waitForPackageCreation();
                            statement = connection.prepareCall("{call ? := " + string22 + ".GetStatus(?)}");
                            statement.setLong(2, FullMigrateTask.this._projectId);
                            statement.registerOutParameter(1, 12);
                            statement.execute();
                            string = statement.getString(1);
                            FullMigrateTask.this.setMessage(string);
                        } else {
                            Thread.sleep(100L);
                        }
                        Thread.sleep(100L);
                        if (statement == null) continue;
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                        continue;
                        catch (InterruptedException interruptedException) {
                            if (statement == null) return;
                            try {
                                statement.close();
                                return;
                            }
                            catch (Exception exception) {}
                            return;
                        }
                        catch (Exception exception) {
                            if (statement == null) continue;
                            try {
                                statement.close();
                            }
                            catch (Exception exception2) {}
                            continue;
                            {
                                catch (Throwable throwable) {
                                    if (statement == null) throw throwable;
                                    try {
                                        statement.close();
                                        throw throwable;
                                    }
                                    catch (Exception exception3) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                    return;
                                }
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("Exception : " + exception.getMessage());
                    exception.printStackTrace();
                    return;
                }
                finally {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.setMessage(MigrationAddinArb.getString("CAPTURING"));
        this._cancelSignal = new CountDownLatch(1);
        this._cancelThread.start();
        this._projectId = ((CaptureCmd)this.captCmd).getCurrentProjectID();
        this._eeStatusThread.start();
        this.captCmd.execute();
        this._eeStatusThread.interrupt();
        this._cancelThread.interrupt();
        String string3 = wizardMigrationDetails.getCurrentCapturedModel();
        if (string3 != null) {
            DBObjectId dBObjectId = new DBObjectId(Long.parseLong(string3));
            this._captConn = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId);
            ByteArrayOutputStream byteArrayOutputStream = wizardMigrationDetails.getErrStream();
            if (byteArrayOutputStream.size() > 0) {
                String string4 = new String(byteArrayOutputStream.toByteArray());
                wizardMigrationDetails.close();
                MigrationLogUtil.logThrowable(string4, "Capture", null);
                s_logger.log(Level.SEVERE, string4);
            }
        } else {
            throw new Exception("Capture failed.  Refer to MIGRLOG table in the repository for details");
        }
        wizardMigrationDetails.close();
        this.setMessage(MigrationAddinArb.getString("CAPTURED"));
    }

    private String getDBList(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder("-dblist=");
        boolean bl = true;
        if (collection != null) {
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(iterator.next());
                bl = false;
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnlineClassicCapture() throws Exception {
        MdProject mdProject;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        BasicMigrationStorer basicMigrationStorer = new BasicMigrationStorer(persistenceManager);
        MigrationObjectFilterList migrationObjectFilterList = MigrationFilterUtil.getFullFilter();
        Collection collection = (Collection)this._actionParams.get(PARAM_CAPT_DBLIST);
        String string = this.getDatabasesListString(new ArrayList<String>(collection));
        MigrationObjectFilter migrationObjectFilter = migrationObjectFilterList.getFilterForType("MD_SCHEMAS");
        migrationObjectFilter.setSelectedDatabaseListString(string);
        this._project = mdProject = this._project != null ? this._project : (MdProject)this._actionParams.get(PARAM_PROJ);
        String string2 = this._actionParams.getProperty(PARAM_PROJ_NAME);
        if (string2 == null) {
            string2 = this._project.getProjectName();
        }
        this.m_captureWorker = new OnlineCaptureWorker(this.m_provider.getCapturer(basicMigrationStorer), string2, this.m_plugin.getClass().getName(), migrationObjectFilterList);
        this.m_captureWorker.addActionListener(new MigrationProgressStatusListener());
        this.m_cancelCapture = true;
        try {
            if (this.m_topLevelCancel) {
                return;
            }
            this.setMessage(MigrationAddinArb.getString("CAPTURING"));
            if (!this.m_captureWorker.runCapture()) {
                return;
            }
            this.setMessage(MigrationAddinArb.getString("CAPTURED"));
        }
        catch (PersistenceException persistenceException) {
            s_logger.log(Level.WARNING, "Capture.EXCEPTION", persistenceException.getLocalizedMessage());
            throw persistenceException;
        }
        catch (CaptureException captureException) {
            s_logger.log(Level.WARNING, "Capture.EXCEPTION", captureException.getLocalizedMessage());
            throw captureException;
        }
        finally {
            MigrationLogUtil.endMigrationLogSession();
        }
        final MdConnection[] mdConnectionArray = new MdConnection[]{null};
        final Exception[] exceptionArray = new Exception[]{null};
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        mdConnectionArray[0] = FullMigrateTask.this.m_captureWorker.getCapturedConnection();
                        MigrationAddin.getMigrationConfig().updateUACode(FullMigrateTask.this.m_plugin.getPlatformMask());
                        CapturedDatabases.getInstance().addMdConnection(mdConnectionArray[0]);
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            s_logger.log(Level.WARNING, "Capture.EXCEPTION", interruptedException.getLocalizedMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            s_logger.log(Level.WARNING, "Capture.EXCEPTION", invocationTargetException.getLocalizedMessage());
        }
        finally {
            this.m_captureWorker = null;
        }
        if (exceptionArray[0] != null) {
            s_logger.log(Level.WARNING, "Capture.EXCEPTION", exceptionArray[0].getLocalizedMessage());
        }
        this._captConn = mdConnectionArray[0];
    }

    private void doOfflineCapture() throws Exception {
        String string = null;
        MdProject mdProject = (MdProject)this._actionParams.get(PARAM_PROJ);
        File file = null;
        Properties properties = new Properties();
        String string2 = null;
        String string3 = this._actionParams.getProperty(PARAM_CAPT_OCPPATH);
        String string4 = this._actionParams.getProperty(PARAM_CAPT_ENCODING);
        Collection collection = (Collection)this._actionParams.get(PARAM_CAPT_DBLIST);
        this.m_cancelCapture = true;
        if (this.m_topLevelCancel) {
            return;
        }
        if (string3 != null) {
            Object object;
            file = new File(string3);
            if (string3.toUpperCase().endsWith("XML")) {
                string = "oracle.dbtools.migration.workbench.plugin.MSAccessPlugin";
                string2 = string3;
            } else if (file != null && file.canRead()) {
                try {
                    object = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string5 = MigrationAddinArb.format("ERR_FILE_MISSING", file.getName());
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)MigrationAddinArb.getString("TITLE_FILE_MISSING"), (String)"help_file_missing");
                    return;
                }
                try {
                    string2 = file.getParent();
                    properties.load((InputStream)object);
                    string = properties.getProperty("OfflinePluginIdentifier");
                }
                catch (IOException iOException) {
                    String string6 = MigrationAddinArb.format("READ_OFFLINE_OUTPUT_FAILED", file.getName(), iOException.getMessage());
                    throw new Exception(string6);
                }
                finally {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (string == null || string.trim().length() == 0) {
                object = MigrationAddinArb.format("ERR_FILE_INVALID_FORMAT", file.getName());
                throw new Exception((String)object);
            }
            object = MigrationAddin.findPlugin(string);
            if (object == null) {
                String string7 = MigrationAddinArb.getString("MSG_PLUGIN_NO_LONGER_AVAILABLE");
                throw new Exception(string7);
            }
            OfflineCapturer offlineCapturer = object.getOfflineCapturer();
            offlineCapturer.setSelectedDatabaseList(new ArrayList<String>(collection));
            if (offlineCapturer == null) {
                String string8 = MigrationAddinArb.getString("ERR_OFFLINE_NOT_SUPPORTED");
                throw new Exception(string8);
            }
            try {
                BasicMigrationStorer basicMigrationStorer = new BasicMigrationStorer(MigrationAddin.getPersistenceManager());
                String string9 = offlineCapturer.captureInitialize(string2, properties, basicMigrationStorer, string4);
                if (string9 == null) {
                    throw new OfflineCaptureException(new NullPointerException());
                }
                if (mdProject != null) {
                    string9 = mdProject.getObjectName();
                }
                OfflineCaptureWorker offlineCaptureWorker = new OfflineCaptureWorker(offlineCapturer, string9, string);
                offlineCaptureWorker.addActionListener(new MigrationProgressStatusListener());
                this.setMessage(MigrationAddinArb.getString("CAPTURING"));
                offlineCaptureWorker.runCapture();
                this._captConn = offlineCaptureWorker.getCapturedConnection();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable(exception.getMessage(), Messages.getString("CaptureInitiator.2"), (Throwable)exception);
                throw exception;
            }
            this.setMessage(MigrationAddinArb.getString("CAPTURED"));
        }
    }

    private String getDatabasesListString(ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder("");
        String string = "'";
        boolean bl = true;
        if (arrayList != null) {
            stringBuilder.append(string);
            Iterator<String> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuilder.append("','");
                }
                stringBuilder.append(iterator.next());
                bl = false;
            }
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private void persistDataTypeMap() throws Exception {
        Object object = this._actionParams.get(PARAM_CONV_DTMAP);
        DataTypeConversionMap dataTypeConversionMap = object != null ? (DataTypeConversionMap)object : null;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = this._project.getKey();
        ConvertUtils.persistMap(persistenceManager, dBObjectId, "dbmigration", dataTypeConversionMap);
    }

    private void persistIdentifierMap() throws Exception {
        Object object = this._actionParams.get(PARAM_CONV_IDMAP_TBLMODEL);
        EditableResultSetTableModel editableResultSetTableModel = null;
        if (object != null) {
            editableResultSetTableModel = (EditableResultSetTableModel)object;
            boolean bl = editableResultSetTableModel.save(false, true);
            if (!bl) {
                throw new Exception(Messages.getString("IdentifierMappingFailed"));
            }
            editableResultSetTableModel.closeModel();
        }
    }

    private void doConvert() throws Exception {
        Object object;
        try {
            MigrationObjectFilterList migrationObjectFilterList = null;
            migrationObjectFilterList = MigrationFilterUtil.getFullFilter();
            object = MigrationAddin.getPersistenceManager();
            this._project = this._project != null ? this._project : (MdProject)this._actionParams.get(PARAM_PROJ);
            this._captConn = this._captConn != null ? this._captConn : (MdConnection)this._actionParams.get(PARAM_CONV_CATPCONN);
            DBObjectId dBObjectId = this._project.getKey();
            this.persistDataTypeMap();
            this.persistIdentifierMap();
            MigrDatatypeTransformMap migrDatatypeTransformMap = ConvertUtils.getMapForProjectId((PersistenceManager)object, dBObjectId);
            DBObjectId dBObjectId2 = migrDatatypeTransformMap.getKey();
            this.m_convertWorker = new ConverterWorker((PersistenceManager)object, this._captConn.getKey(), this.m_plugin.getConverter(), dBObjectId2, migrationObjectFilterList);
            this.m_convertWorker.addEventListener(new MigrationProgressStatusListener());
            this.m_cancelConvert = true;
            if (this.m_topLevelCancel) {
                return;
            }
            this.setMessage(MigrationAddinArb.getString("CONVERTING"));
            boolean bl = this.m_convertWorker.runConvert();
            if (bl) {
                this._convConn = this.m_convertWorker.getConvertedConnection();
                this.setMessage(MigrationAddinArb.getString("CONVERTED"));
            }
            this._captConn.setStatus("converted");
            this._captConn.save(MigrationAddin.getPersistenceManager());
        }
        catch (Exception exception) {
            object = null;
            object = exception.getMessage() == null ? (exception instanceof NullPointerException ? "NullPointerException" : "unknown") : exception.getMessage();
            MigrationLogUtil.logThrowable((String)object, Messages.getString("CaptureInitiator.2"), (Throwable)exception);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw exception;
        }
        finally {
            this.m_convertWorker = null;
        }
    }

    private GenerationOutputStream createPrintStream(String string) throws Exception {
        File file = new File(string);
        Object object = this._actionParams.get(PARAM_PROJ);
        MdProject mdProject = object != null ? (MdProject)object : null;
        String string2 = mdProject.getProjectName();
        MdConnection mdConnection = this._captConn != null ? this._captConn : (MdConnection)this._actionParams.get(PARAM_CONV_CATPCONN);
        String string3 = mdConnection.getName();
        if (!file.exists()) {
            file.mkdirs();
        }
        this._scriptName = string + File.separator + string2 + "." + string3;
        this.m_generateSQLFile = new File(this._scriptName + ".sql");
        SimpleGenerationOutputStream simpleGenerationOutputStream = null;
        String string4 = Ide.getEnvironOptions().getEncoding();
        simpleGenerationOutputStream = string4 == null ? new SimpleGenerationOutputStream(new PrintStream(this.m_generateSQLFile)) : new SimpleGenerationOutputStream(new PrintStream(this.m_generateSQLFile, string4));
        return simpleGenerationOutputStream;
    }

    private void doGenerate() throws Exception {
        try {
            MigrationObjectFilterList migrationObjectFilterList = null;
            migrationObjectFilterList = MigrationFilterUtil.getFullFilter();
            PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
            String string = (String)this._actionParams.get(PARAM_GEN_SCRIPTDIR);
            GenerationOutputStream generationOutputStream = this.createPrintStream(string);
            final String string2 = (String)this._actionParams.get(PARAM_GEN_TGTCONN);
            String string3 = (String)this._actionParams.get(PARAM_GEN_MODE);
            boolean bl = (Boolean)this._actionParams.get(PARAM_GEN_DROP_ENABLED);
            this._project = this._project != null ? this._project : (MdProject)this._actionParams.get(PARAM_PROJ);
            this._captConn = this._captConn != null ? this._captConn : (MdConnection)this._actionParams.get(PARAM_CONV_CATPCONN);
            this._convConn = this._convConn != null ? this._convConn : (MdConnection)this._actionParams.get(PARAM_CONV_CONVCONN);
            DBObjectId dBObjectId = this._convConn.getKey();
            GenerateWorker generateWorker = new GenerateWorker(persistenceManager, dBObjectId, generationOutputStream, migrationObjectFilterList, bl);
            generateWorker.addEventListener(new MigrationProgressStatusListener());
            generateWorker.setOutputDir(string);
            this.m_generateWorker = generateWorker;
            this.m_cancelGenerateWorker = true;
            if (this.m_topLevelCancel) {
                return;
            }
            this.setMessage(MigrationAddinArb.getString("GENERATERUNNER_TITLE"));
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            this.m_leastPrivilege = migrationConfig.getSingleSchemaLeastPrivilege() && generateWorker.findSchemaCount() == 1;
            boolean bl2 = generateWorker.runGenerate(this.m_leastPrivilege);
            generationOutputStream.close();
            File file = generateWorker.getMasterFile();
            if (file != null) {
                this.m_generateSQLFile = file;
            }
            if (string3 == null || string3.equals(CAPTURE_MODE_OFFLINE)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            OpenWorksheetWizard.openNewWorksheet((String)string2, (URL)FullMigrateTask.this.m_generateSQLFile.toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                });
            }
            if (this.m_topLevelCancel) {
                return;
            }
            if (bl2) {
                this.setMessage(MigrationAddinArb.getString("GENERATED"));
                if (string3 != null && string3.equals(CAPTURE_MODE_ONLINE)) {
                    this.runGenerateScript(string2);
                }
            }
            this._captConn.setStatus("generated");
            this._captConn.save(MigrationAddin.getPersistenceManager());
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.m_generateWorker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runGenerateScript(String string) throws Exception {
        Connection connection = Connections.getInstance().getConnection(string);
        String string2 = this._scriptName + ".out";
        File file = new File(string2);
        FileInputStream fileInputStream = new FileInputStream(this.m_generateSQLFile);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        URL uRL = this.m_generateSQLFile.toURI().toURL();
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), Ide.getEnvironOptions().getEncoding());
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        scriptRunnerContext.setTopLevel(true);
        scriptRunnerContext.setLastUrl(uRL);
        scriptRunnerContext.setSqlError(0);
        scriptRunnerContext.setOsError(0);
        WrapListenBufferOutputStream wrapListenBufferOutputStream = new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream, null);
        wrapListenBufferOutputStream.setRemoveForcePrint(true);
        scriptRunnerContext.setOutputStreamWrapper((BufferedOutputStream)wrapListenBufferOutputStream);
        scriptRunnerContext.consumerRuning(true);
        try {
            ScriptExecutor scriptExecutor = new ScriptExecutor((Reader)new BufferedReader(inputStreamReader), connection);
            scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
            scriptExecutor.setOut((BufferedOutputStream)wrapListenBufferOutputStream);
            this.setMessage(MigrationAddinArb.getString("BEGIN_GENERATE_RUN"));
            scriptExecutor.run();
        }
        finally {
            try {
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                inputStreamReader.close();
                fileInputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
        if (scriptRunnerContext.getReturnExited()) {
            this.setMessage(MigrationAddinArb.getString("GENERATE_RUN_SUCCESS"));
        } else {
            this.setMessage(MigrationAddinArb.getString("GENERATE_RUN_FAILED"));
        }
    }

    public int findSchemaCount() throws PersistenceException {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
        MigrationObjectFilterList migrationObjectFilterList = null;
        migrationObjectFilterList = MigrationFilterUtil.getFullFilter();
        return persistenceUtility.getSchemaCountForConnectionId(this._convConn.getKey(), migrationObjectFilterList);
    }

    private void doDataMove() throws Exception {
        try {
            Object object;
            MigrationObjectFilterList migrationObjectFilterList = null;
            migrationObjectFilterList = MigrationFilterUtil.getFullFilter();
            PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
            String string = (String)this._actionParams.get(PARAM_DM_SCRIPTDIR);
            String string2 = (String)this._actionParams.get(PARAM_DM_SRCCONN);
            String string3 = (String)this._actionParams.get(PARAM_DM_TGTCONN);
            boolean bl = (Boolean)this._actionParams.get(PARAM_DM_TRUNC_ENABLED);
            String string4 = (String)this._actionParams.get(PARAM_DM_MODE);
            String string5 = this._actionParams.getProperty(PARAM_CAPT_ENCODING);
            this._project = this._project != null ? this._project : (MdProject)this._actionParams.get(PARAM_PROJ);
            this._captConn = this._captConn != null ? this._captConn : (MdConnection)this._actionParams.get(PARAM_CONV_CATPCONN);
            this._convConn = this._convConn != null ? this._convConn : (MdConnection)this._actionParams.get(PARAM_CONV_CONVCONN);
            this.m_cancelDataMove = true;
            if (this.m_topLevelCancel) {
                return;
            }
            if (string4 != null && !string4.equals(CAPTURE_MODE_ONLINE)) {
                object = this.m_plugin.getPlatformName();
                String string6 = this._project.getProjectName() + File.separator + this._captConn.getName();
                File file = new File(string);
                if (!file.exists()) {
                    file.mkdirs();
                }
                Offline3rdPartyPrintStream offline3rdPartyPrintStream = null;
                if (((String)object).equals("Teradata")) {
                    offline3rdPartyPrintStream = this.m_plugin.getOffline3rdPartyPrintStream(string6, string);
                    if (offline3rdPartyPrintStream == null) {
                        offline3rdPartyPrintStream = new Offline3rdPartyPrintStream((String)object, string6, string);
                    }
                } else {
                    offline3rdPartyPrintStream = new Offline3rdPartyPrintStream((String)object, string6, string);
                }
                OfflineSQLLoaderPrintStream offlineSQLLoaderPrintStream = new OfflineSQLLoaderPrintStream((String)object, string6, string);
                OfflineDataMoveWorker offlineDataMoveWorker = new OfflineDataMoveWorker(persistenceManager, this._convConn, string, offline3rdPartyPrintStream, offlineSQLLoaderPrintStream, bl);
                offlineDataMoveWorker.addListener(new MigrationProgressStatusListener());
                this.setMessage(MigrationAddinArb.getString("DATAMOVERUNNER_OFFLINE_START"));
                offlineDataMoveWorker.doWork();
                this.setMessage(MigrationAddinArb.getString("DATAMOVERUNNER_OFFLINE_END"));
            }
            if (this.m_topLevelCancel) {
                return;
            }
            if (string4 != null && string4.equals(CAPTURE_MODE_ONLINE)) {
                object = this._convConn.getKey();
                this.m_leastPrivilege = false;
                this.m_dataMoveWorker = new DataMoveWorker(persistenceManager, string2, string3, (DBObjectId)object, MigrationAddin.getMigrationConfig().getNumDataMoveThreads(), MigrationAddin.getMigrationConfig().getDataMoveCommitInterval(), !this.m_leastPrivilege, bl);
                this.m_dataMoveWorker.addListener(new MigrationProgressStatusListener());
                this.setMessage(MigrationAddinArb.getString("DATAMOVERUNNER_INITIAL_MESSAGE"));
                this.m_dataMoveWorker.doWork();
                this.setMessage(MigrationAddinArb.getString("DATAMOVERUNNER_SUCCESS"));
                Connections.getInstance().getConnection(string3).commit();
            }
            this._captConn.setStatus("datamoved");
            this._captConn.save(MigrationAddin.getPersistenceManager());
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.m_dataMoveWorker = null;
        }
    }

    private void setProjectOutputDir(String string) {
        String string2 = this._actionParams.getProperty(PARAM_PROJ_NAME);
        String string3 = string2 != null ? string2 : "UnknownProject";
        MigrationAddin.getMigrationConfig().setStringProperty(string3 + "_" + "outdir", string);
    }

    private void setCaptureModeOnline() {
        String string = this._actionParams.getProperty(PARAM_PROJ_NAME);
        if (string != null) {
            MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + this._captConn.getKey() + KEY_DELIMITER + "captmode_on", true);
            MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + this._captConn.getKey() + KEY_DELIMITER + "captmode_off", false);
        }
    }

    private void setCaptureModeOffline() {
        String string = this._actionParams.getProperty(PARAM_PROJ_NAME);
        if (string != null) {
            MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + this._captConn.getKey() + KEY_DELIMITER + "captmode_on", false);
            MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + this._captConn.getKey() + KEY_DELIMITER + "captmode_off", true);
        }
    }

    private void setSourceConnection() {
        String string;
        String string2 = this._actionParams.getProperty(PARAM_PROJ_NAME);
        String string3 = this._actionParams.getProperty(PARAM_CAPT_SRCCONN);
        String string4 = string = string2 != null ? string2 : null;
        if (string != null) {
            MigrationAddin.getMigrationConfig().setStringProperty(string + KEY_DELIMITER + this._captConn.getKey() + KEY_DELIMITER + "source_conn", string3);
        }
    }

    private void setSourceOcp() {
        String string = this._actionParams.getProperty(PARAM_PROJ_NAME);
        String string2 = this._actionParams.getProperty(PARAM_CAPT_OCPPATH);
        if (string != null) {
            MigrationAddin.getMigrationConfig().setStringProperty(string + KEY_DELIMITER + this._captConn.getKey() + KEY_DELIMITER + "offline_captdir", string2);
        }
    }

    private void clearCaptureMode() {
        String string = this._actionParams.getProperty(PARAM_PROJ_NAME);
        if (string != null) {
            MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + this._captConn.getKey() + KEY_DELIMITER + "captmode_on", false);
        }
        MigrationAddin.getMigrationConfig().setBooleanProperty(string + KEY_DELIMITER + this._captConn.getKey() + KEY_DELIMITER + "captmode_off", false);
    }

    public String getCurrentStep() {
        return this.m_currentStep;
    }

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    protected static void ignore(Throwable throwable) {
        if ($assertionsDisabled || throwable != null) {
            // empty if block
        }
    }

    private void initPlugin() throws Exception {
        MdConnection mdConnection;
        String string = this._actionParams.getProperty(PARAM_CAPT_SRCCONN);
        String string2 = this._actionParams.getProperty(PARAM_CAPT_OCPPATH);
        Object object = this._actionParams.get(PARAM_CONV_CATPCONN);
        MdConnection mdConnection2 = mdConnection = object != null ? (MdConnection)object : null;
        if (string != null) {
            Connection connection = Connections.getInstance().getConnection(string);
            this.m_plugin = MigrationAddin.getPluginForConnection(connection);
            this.m_provider = this.m_plugin.getProvider(connection);
        } else if (mdConnection != null) {
            String string3 = mdConnection.getProperty("PLUGIN_ID");
            this.m_plugin = (MigrationPlugin)Class.forName(string3).newInstance();
        } else if (string2 != null) {
            Object object2;
            String string4 = null;
            File file = null;
            if (string2.toUpperCase().endsWith("XML")) {
                string4 = "oracle.dbtools.migration.workbench.plugin.MSAccessPlugin";
            } else {
                file = new File(string2);
                if (file != null && file.canRead()) {
                    try {
                        object2 = new FileInputStream(file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        String string5 = MigrationAddinArb.format("ERR_FILE_MISSING", file.getName());
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)MigrationAddinArb.getString("TITLE_FILE_MISSING"), (String)"help_file_missing");
                        return;
                    }
                    Properties properties = new Properties();
                    properties.load((InputStream)object2);
                    string4 = properties.getProperty("OfflinePluginIdentifier");
                }
            }
            if (string4 == null || string4.trim().length() == 0) {
                object2 = MigrationAddinArb.format("ERR_FILE_INVALID_FORMAT", file.getName());
                throw new Exception((String)object2);
            }
            this.m_plugin = MigrationAddin.findPlugin(string4);
        }
    }

    private String createTemporaryConnection() {
        String string = null;
        String string2 = MigrationAddin.getRepositoryConnectionName();
        try {
            string = Connections.getInstance().createPrivateConnection(string2);
            Connections.getInstance().getConnection(string);
        }
        catch (ConnectionException connectionException) {
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return string;
    }

    private void notifyNavigator(final Element element) {
        if (element == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((MigrationProjectNavigatorManager)MigrationProjectNavigatorManager.getInstance()).refreshElement(element);
            }
        });
    }

    class MigrationProgressStatusListener
    implements CaptureEventListener,
    ConvertEventListener,
    GenerateEventListener,
    DataMoveListener {
        MigrationProgressStatusListener() {
        }

        @Override
        public void raiseEvent(CaptureEvent captureEvent) {
            String string = captureEvent.getEventSourceType();
            String string2 = captureEvent.getEventSource();
            if (captureEvent.getEventId() != 7) {
                String string3 = QMWizardArb.getString("Capturing") + " " + string + " " + string2;
                FullMigrateTask.this.setMessage(string3);
            }
        }

        @Override
        public void raiseEvent(ConvertEvent convertEvent) {
            int n = convertEvent.getEventId();
            String string = convertEvent.getEventSourceType();
            String string2 = convertEvent.getEventSource();
            String string3 = "";
            if (string != null) {
                if ("CONSTRAINT".equals(string)) {
                    string3 = "Constraint";
                } else if ("MD_VIEWS".equals(string)) {
                    string3 = "View";
                } else if ("MD_STORED_PROGRAMS".equals(string)) {
                    string3 = "Stored Program";
                } else if ("MD_TRIGGERS".equals(string)) {
                    string3 = "Trigger";
                }
            }
            String string4 = "";
            switch (n) {
                case 1: {
                    string4 = QMWizardArb.getString("BuildingCM");
                    break;
                }
                case 3: {
                    string4 = QMWizardArb.getString("TransformId");
                    break;
                }
                case 6: {
                    string4 = QMWizardArb.getString("DataTypeTransform");
                    break;
                }
                case 8: {
                    string4 = QMWizardArb.getString("Translating") + " " + string3 + " " + string2;
                    break;
                }
                case 10: {
                    string4 = QMWizardArb.getString("ColumnDefaultTrans");
                    break;
                }
                case 13: {
                    string4 = QMWizardArb.getString("IdColTranslation");
                    break;
                }
                case 16: {
                    string4 = QMWizardArb.getString("PlatformTrans");
                }
            }
            FullMigrateTask.this.setMessage(string4);
        }

        @Override
        public void raiseEvent(GenerateEvent generateEvent) {
            String string = generateEvent.getEventSourceType();
            String string2 = generateEvent.getEventSource();
            String string3 = QMWizardArb.getString("Generating") + " " + string + " " + string2;
            FullMigrateTask.this.setMessage(string3);
        }

        @Override
        public void raiseEvent(DataMoveEvent dataMoveEvent) {
            String string = "TABLE";
            String string2 = dataMoveEvent.getSource();
            String string3 = QMWizardArb.getString("MovingData") + " " + string + " " + string2;
            FullMigrateTask.this.setMessage(string3);
        }
    }

    private class WizardMigrationDetails
    extends MigrationDetails {
        private ByteArrayOutputStream _stdStream;
        private ByteArrayOutputStream _errStream;

        WizardMigrationDetails() {
        }

        WizardMigrationDetails(String[] stringArray) {
            super(stringArray);
        }

        @Override
        public CMDOut getOut() {
            if (this.cmdout == null) {
                this._stdStream = new ByteArrayOutputStream();
                this._errStream = new ByteArrayOutputStream();
                this.cmdout = new CMDOut(false, new PrintStream(this._stdStream), new PrintStream(this._errStream)){

                    @Override
                    public void printMessage(String string) {
                        super.printMessage(string);
                        FullMigrateTask.this.setMessage(string);
                    }

                    @Override
                    public void printError(String string) {
                        super.printError(string);
                        FullMigrateTask.this.setMessage(string);
                    }

                    @Override
                    public void printResult(String string) {
                        super.printResult(string);
                        FullMigrateTask.this.setMessage(string);
                    }

                    @Override
                    public void printError(Exception exception) {
                        String string = this.getExceptionSummary(exception);
                        this.printError("Error:" + string);
                    }
                };
            }
            return this.cmdout;
        }

        public ByteArrayOutputStream getStdStream() {
            return this._stdStream;
        }

        public ByteArrayOutputStream getErrStream() {
            return this._errStream;
        }

        public void close() {
            if (this._stdStream != null) {
                try {
                    this._stdStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._errStream != null) {
                try {
                    this._errStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

