/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.ui.MigrationSchedulingRule;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.internal.ConnectionMutexFactory;
import oracle.dbtools.raptor.backgroundTask.internal.ObjectMutexRule;

public class CaptureRunnerTask
extends RaptorTask<Object> {
    private int m_uaMask;
    private CaptureWorker m_worker;
    private String m_sourceConnName;

    public CaptureRunnerTask(CaptureWorker captureWorker, int n, String string) {
        super(MigrationAddinArb.getString("CAPTURERUNNER_TITLE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL);
        this.m_worker = captureWorker;
        this.m_uaMask = n;
        this.m_sourceConnName = string;
        this.setMessage(MigrationAddinArb.getString("CAPTURERUNNER_INITIAL_MESSAGE"));
        this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            private void cleanUp() {
                MdConnection mdConnection = CaptureRunnerTask.this.m_worker.getCapturedConnection();
                if (mdConnection != null) {
                    try {
                        mdConnection.delete(MigrationAddin.getPersistenceManager());
                        MigrationAddin.getPersistenceManager().commit();
                    }
                    catch (PersistenceException persistenceException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                }
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanUp();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                this.cleanUp();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Boolean bl = Boolean.FALSE;
                try {
                    bl = (Boolean)CaptureRunnerTask.this.getResult();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl != null && bl.booleanValue()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CapturedDatabases.getInstance().addMdConnection(CaptureRunnerTask.this.m_worker.getCapturedConnection());
                            MigrationAddin.getMigrationConfig().updateUACode(CaptureRunnerTask.this.m_uaMask);
                        }
                    });
                } else {
                    this.cleanUp();
                }
            }
        });
    }

    public CaptureRunnerTask(CaptureWorker captureWorker, int n) {
        this(captureWorker, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doWork() throws TaskException {
        try {
            if (this.m_worker.runCapture()) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        catch (Exception exception) {
            throw new TaskException((Throwable)exception);
        }
        finally {
            MigrationLogUtil.endMigrationLogSession();
        }
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule iSchedulingRule = ConnectionMutexFactory.getRule((String)MigrationAddin.getRepositoryConnectionName());
        ObjectMutexRule objectMutexRule = new ObjectMutexRule((Object)"MigrationSession");
        if (this.m_sourceConnName != null) {
            ISchedulingRule iSchedulingRule2 = ConnectionMutexFactory.getRule((String)this.m_sourceConnName);
            return new MigrationSchedulingRule(iSchedulingRule2, iSchedulingRule, objectMutexRule);
        }
        return new MigrationSchedulingRule(iSchedulingRule, objectMutexRule);
    }

    public boolean cancel() {
        this.m_worker.signalCancel();
        return true;
    }
}

