/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.CountEventModel;
import oracle.dbtools.migration.workbench.core.ui.FullMigrateTask;
import oracle.dbtools.migration.workbench.core.ui.SimpleTablePanel;

class CaptureEventListenerPanelForTask
implements CaptureEventListener {
    private SimpleTablePanel m_eventPanel;
    private FullMigrateTask m_runnable;
    private JPanel m_panel;
    private JLabel m_label;

    public CaptureEventListenerPanelForTask(FullMigrateTask fullMigrateTask) {
        CountEventModel countEventModel = new CountEventModel(new String[]{MigrationAddinArb.getString("OBJECT_TYPE"), MigrationAddinArb.getString("OBJECTS_CAPTURED")});
        this.m_eventPanel = new SimpleTablePanel(200, MigrationAddinArb.getString("FULLMIGRATION_TOOLTIP_CAPTURE"), countEventModel);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        this.m_panel = new JPanel();
        this.m_panel.setLayout(borderLayout);
        this.m_panel.add((Component)this.m_eventPanel, "Center");
        this.m_label = new JLabel();
        this.m_panel.add((Component)this.m_label, "South");
    }

    public JPanel getPanel() {
        return this.m_panel;
    }

    public String getPanelName() {
        return MigrationAddinArb.getString("FULLMIGRATION_TAB_CAPTURE");
    }

    @Override
    public void raiseEvent(final CaptureEvent captureEvent) {
        String string = "";
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_label.setText("");
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        CaptureEventListenerPanelForTask.this.m_label.setText("");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        switch (captureEvent.getEventId()) {
            case 1: {
                string = MigrationAddinArb.getString("CAPTURING") + " " + captureEvent.getEventSource();
                break;
            }
            case 2: {
                string = captureEvent.getEventSource() + " " + MigrationAddinArb.getString("CAPTURED");
                break;
            }
            case 3: {
                string = MigrationAddinArb.getString("STORING") + " " + captureEvent.getEventSource();
                break;
            }
            case 4: {
                string = MigrationAddinArb.getString("STORED") + " " + captureEvent.getEventSource();
                break;
            }
            case 5: {
                return;
            }
            case 6: {
                string = MigrationAddinArb.getString("START_CAPTURE");
                break;
            }
            case 7: {
                string = MigrationAddinArb.getString("END_CAPTURE");
                break;
            }
            case 8: {
                final String string2 = string = captureEvent.getEventSourceType();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CaptureEventListenerPanelForTask.this.m_label.setText(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        this.updateProgress(captureEvent.getEventId(), captureEvent, string);
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_eventPanel.updateProgress(captureEvent.toEventString());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        CaptureEventListenerPanelForTask.this.m_eventPanel.updateProgress(captureEvent.toEventString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void updateProgress(int n, Object object, Object object2) {
        if ($assertionsDisabled || object != null) {
            // empty if block
        }
        if (this.m_runnable.getCurrentStep() != null) {
            if (this.m_runnable.getCurrentStep().equals("CURRENTSTEP_CREATE") || this.m_runnable.getCurrentStep().equals("CURRENTSTEP_REMOVE")) {
                this.m_runnable.setMessage("(" + n + "%)");
                if (n == 100 && !SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            } else {
                this.m_runnable.setMessage((String)object2);
            }
        }
    }
}

