/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.IntegerDocument;
import oracle.ide.util.ResourceUtils;

class UpdateTypePanel
extends JPanel {
    private JComboBox _cmbSourceField;
    private JTextField _txfSourcePrecision;
    private JTextField _txfSourceScale;
    private Set<DataTypeSpecification> _availableDataTypes;

    public UpdateTypePanel(DataTypeSpecification[] dataTypeSpecificationArray) {
        super(new BorderLayout());
        this.initGUI();
        this._availableDataTypes = new HashSet<DataTypeSpecification>();
        for (DataTypeSpecification dataTypeSpecification : dataTypeSpecificationArray) {
            boolean bl = false;
            for (DataTypeSpecification dataTypeSpecification2 : this._availableDataTypes) {
                if (!dataTypeSpecification.getName().equals(dataTypeSpecification2.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this._availableDataTypes.add(dataTypeSpecification);
        }
        this.initializeValues();
    }

    public Integer getScale() {
        if (this._txfSourceScale.getText().trim().length() > 0) {
            return Integer.valueOf(this._txfSourceScale.getText());
        }
        return null;
    }

    public Integer getPrecision() {
        if (this._txfSourcePrecision.getText().trim().length() > 0) {
            return Integer.valueOf(this._txfSourcePrecision.getText());
        }
        return null;
    }

    public String getTypeName() {
        return ((DataTypeSpecification)this._cmbSourceField.getSelectedItem()).getName();
    }

    public void setCurrentColumnType(String string, Integer n, Integer n2) {
        for (int i = 0; i < this._cmbSourceField.getItemCount(); ++i) {
            if (!((DataTypeSpecification)this._cmbSourceField.getItemAt(i)).getName().equals(string)) continue;
            this._cmbSourceField.setSelectedIndex(i);
        }
        this._txfSourcePrecision.setText(n == null ? "" : String.valueOf(n));
        this._txfSourceScale.setText(n2 == null ? "" : String.valueOf(n2));
    }

    private void initializeValues() {
        this._cmbSourceField.removeAllItems();
        for (DataTypeSpecification dataTypeSpecification : this._availableDataTypes) {
            this._cmbSourceField.addItem(dataTypeSpecification);
        }
        this._cmbSourceField.setSelectedIndex(0);
    }

    private void initGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
        gridBagLayout.rowHeights = new int[]{7, 7, 7};
        gridBagLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setPreferredSize(new Dimension(150, 80));
        JLabel jLabel = new JLabel();
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._cmbSourceField = new JComboBox();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._cmbSourceField, (String)(MigrationAddinArb.getString("COLUMN_SOURCE_DATA_TYPE") + ":"));
        this._cmbSourceField.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof DataTypeSpecification) {
                    return super.getListCellRendererComponent((JList<?>)jList, ((DataTypeSpecification)object).getName(), n, bl, bl2);
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        jPanel.add((Component)this._cmbSourceField, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfSourcePrecision = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._txfSourcePrecision, (String)(MigrationAddinArb.getString("COLUMN_PRECISION") + ":"));
        this._txfSourcePrecision.setDocument(new IntegerDocument());
        jPanel.add((Component)this._txfSourcePrecision, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel3 = new JLabel();
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfSourceScale = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._txfSourceScale, (String)(MigrationAddinArb.getString("COLUMN_SCALE") + ":"));
        this._txfSourceScale.setDocument(new IntegerDocument());
        jPanel.add((Component)this._txfSourceScale, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._cmbSourceField.addItemListener(new ComboListener());
        this.add(jPanel);
    }

    private class ComboListener
    implements ItemListener {
        private ComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            DataTypeSpecification dataTypeSpecification = (DataTypeSpecification)itemEvent.getItem();
            UpdateTypePanel.this._txfSourceScale.setText("");
            UpdateTypePanel.this._txfSourcePrecision.setText("");
            if (dataTypeSpecification.getPrecision() != null) {
                UpdateTypePanel.this._txfSourcePrecision.setText(String.valueOf(dataTypeSpecification.getPrecision()));
            }
            if (dataTypeSpecification.getScale() != null) {
                UpdateTypePanel.this._txfSourceScale.setText(String.valueOf(dataTypeSpecification.getScale()));
            }
        }
    }
}

