/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.Serializable;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.dbtools.migration.workbench.core.preferences.Messages;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public final class TranslationPanelData
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 0L;
    public static final String TITLE = Messages.getString("ConfigurationPanelData.0");
    public static final String PAGE_TITLE = Messages.getString("ConfigurationPanelData.1");
    public static final String[] DATEFORMATS = new String[]{"dd/mm/yyyy", "day/mon/yyyy"};
    private JFormattedTextField m_varPrefixTextField;
    private JFormattedTextField m_inParamTextField;
    private JComboBox m_dataFormatComboBox;
    private JComboBox m_queryAssignmentCombobox;
    private JPanel jPanelLevel = null;
    private JPanel jPanel1 = null;
    private JTextField m_dataFormatTextField;
    private boolean _inited = false;
    private JCheckBox m_showASTCheckBox = null;
    private JCheckBox m_useCompoundTrigger = null;

    public TranslationPanelData() {
        this.setDefaultTitle(PAGE_TITLE);
        this.setHelpID("f1_configurationpaneldata_html");
    }

    public void jbInit() throws Exception {
        if (!this._inited) {
            this._inited = true;
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0));
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.add(this.getDateFormatComboBoxPanel());
            jPanel.add(Box.createRigidArea(new Dimension(10, 5)));
            jPanel.add(this.getVarPrefixPanel());
            jPanel.add(Box.createRigidArea(new Dimension(10, 5)));
            jPanel.add(this.getInParamPrefixPanel());
            jPanel.add(Box.createRigidArea(new Dimension(10, 5)));
            jPanel.add(this.getQueryAssignmentComboBoxPanel());
            jPanel.add(Box.createRigidArea(new Dimension(10, 5)));
            jPanel.add(this.getShowASTPanel());
            jPanel.add(Box.createRigidArea(new Dimension(10, 5)));
            jPanel.add(this.getCompoundTriggerPanel());
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jPanel, "North");
            this.setLayout(new BorderLayout());
            this.add(jPanel3, "North");
        }
    }

    private Component getShowASTPanel() {
        this.m_showASTCheckBox = new JCheckBox();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_showASTCheckBox, (String)Messages.getString("ShowAST"));
        jLabel.setHorizontalAlignment(2);
        return this.getPanelWithLabelAndComponent(jLabel, this.m_showASTCheckBox);
    }

    private Component getCompoundTriggerPanel() {
        this.m_useCompoundTrigger = new JCheckBox();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_useCompoundTrigger, (String)Messages.getString("CompoundTrigger"));
        jLabel.setHorizontalAlignment(2);
        return this.getPanelWithLabelAndComponent(jLabel, this.m_useCompoundTrigger);
    }

    private static ConfigurationData getConfigurationDataPrefs(TraversableContext traversableContext) {
        return ConfigurationData.getInstance(traversableContext.getPropertyStorage());
    }

    public void onEntry(TraversableContext traversableContext) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        ConfigurationData configurationData = TranslationPanelData.getConfigurationDataPrefs(traversableContext);
        this.load(configurationData);
    }

    public void onExit(TraversableContext traversableContext) {
        ConfigurationData configurationData = TranslationPanelData.getConfigurationDataPrefs(traversableContext);
        this.commit(configurationData);
    }

    private void load(ConfigurationData configurationData) {
        this.m_dataFormatTextField.setText(configurationData.getDateFormat());
        this.m_queryAssignmentCombobox.setSelectedItem(TranslationPreferences.getSelectLabelFromValue((String)configurationData.getQueryAssignment()));
        this.m_varPrefixTextField.setText(configurationData.getVarPrefix().trim());
        this.m_inParamTextField.setText(configurationData.getInParamPrefix().trim());
        this.m_showASTCheckBox.setSelected(configurationData.getShowAST());
        this.m_useCompoundTrigger.setSelected(configurationData.useCompoundTrigger());
    }

    private void commit(ConfigurationData configurationData) {
        configurationData.setDateFormat(this.m_dataFormatTextField.getText());
        configurationData.setQueryAssignment(TranslationPreferences.getSelectValueFromLabel((String)((String)this.m_queryAssignmentCombobox.getSelectedItem())));
        configurationData.setVarPrefix(this.m_varPrefixTextField.getText().trim());
        configurationData.setInParamPrefix(this.m_inParamTextField.getText().trim());
        configurationData.setShowAST(this.m_showASTCheckBox.isSelected());
        configurationData.setCompoundTrigger(this.m_useCompoundTrigger.isSelected());
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout);
        }
        return this.jPanel1;
    }

    private JPanel getDateFormatComboBoxPanel() {
        this.m_dataFormatTextField = new JTextField(14);
        this.m_dataFormatTextField.setMaximumSize(new Dimension(60, 100));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_dataFormatTextField, (String)Messages.getString("ConfigurationPanelData.5"));
        jLabel.setHorizontalAlignment(2);
        return this.getPanelWithLabelAndComponent(jLabel, this.m_dataFormatTextField);
    }

    private JPanel getQueryAssignmentComboBoxPanel() {
        String[] stringArray = new String[]{TranslationPreferences.SELECTINTOASSIGNMENT_LABEL, TranslationPreferences.SELECTINTOEXCEPTIONASSIGNMENT_LABEL, TranslationPreferences.CURSORLOOPASSIGNMENT_LABEL};
        this.m_queryAssignmentCombobox = new JComboBox<String>(stringArray);
        this.m_queryAssignmentCombobox.setMaximumSize(new Dimension(200, 100));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_queryAssignmentCombobox, (String)Messages.getString("ConfigurationPanelData.6"));
        return this.getPanelWithLabelAndComponent(jLabel, this.m_queryAssignmentCombobox);
    }

    private JPanel getVarPrefixPanel() {
        Serializable serializable;
        try {
            serializable = new MaskFormatter("****");
            this.m_varPrefixTextField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)serializable);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.m_varPrefixTextField.setColumns(4);
        this.m_varPrefixTextField.setMaximumSize(new Dimension(20, 100));
        serializable = new JLabel();
        ResourceUtils.resLabel((JLabel)serializable, (Component)this.m_varPrefixTextField, (String)Messages.getString("ConfigurationPanelData.7"));
        ((JLabel)serializable).setHorizontalAlignment(2);
        return this.getPanelWithLabelAndComponent((JLabel)serializable, this.m_varPrefixTextField);
    }

    private JPanel getInParamPrefixPanel() {
        Serializable serializable;
        try {
            serializable = new MaskFormatter("****");
            this.m_inParamTextField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)serializable);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.m_inParamTextField.setColumns(4);
        this.m_inParamTextField.setMaximumSize(new Dimension(20, 100));
        serializable = new JLabel();
        ResourceUtils.resLabel((JLabel)serializable, (Component)this.m_inParamTextField, (String)Messages.getString("ConfigurationPanelData.8"));
        ((JLabel)serializable).setHorizontalAlignment(2);
        return this.getPanelWithLabelAndComponent((JLabel)serializable, this.m_inParamTextField);
    }

    private JPanel getPanelWithLabelAndComponent(JLabel jLabel, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        if (jLabel != null) {
            jPanel.add((Component)jLabel, null);
        }
        jPanel.add((Component)jComponent, null);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }
}

