/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Driver;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.Messages;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class GeneratePreferencesPanel
extends DefaultTraversablePanel {
    public static final String TITLE = MigrationAddinArb.getString("GENERATE_PREFERENCES_TITLE");
    private static final long serialVersionUID = 4843227636357117485L;
    private JCheckBox m_checkComments;
    private JRadioButton m_radioPerObject;
    private JRadioButton m_radioSingle;
    private JCheckBox m_checkSingleSchema;
    private JCheckBox m_generateDataMoveUserFlag;
    private JCheckBox m_generateFailedObjects;
    private JCheckBox m_generateClobToBlob;
    private JCheckBox m_genEntireEmulationPkgField;
    private JCheckBox m_generate12c;
    private Object[] m_iotOptions = new Object[]{MigrationAddinArb.getString("MIGRATION_GENERATE_IOT_NONE"), MigrationAddinArb.getString("MIGRATION_GENERATE_IOT_PROMOTE_UNIQUE"), MigrationAddinArb.getString("MIGRATION_GENERATE_IOT_PRIMARY_KEYS")};
    private boolean m_show12 = false;
    JComboBox m_IOTCombo = new JComboBox<Object>(this.m_iotOptions);

    public GeneratePreferencesPanel() {
        this.initComponents();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_migprefgeneration_html");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.add(jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(null, MigrationAddinArb.getString("GEN_FILE_CREATION_OPTIONS"), 0, 0, null, null));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 15, 0, 0);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        this.add(jPanel2, gridBagConstraints2);
        this.m_radioSingle = new JRadioButton();
        this.m_radioSingle.setText(MigrationAddinArb.getString("GEN_SINGLE_OBJECT"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        jPanel2.add((Component)this.m_radioSingle, gridBagConstraints3);
        this.m_radioPerObject = new JRadioButton();
        this.m_radioPerObject.setText(MigrationAddinArb.getString("GEN_PRE_OBJECT"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridx = 0;
        jPanel2.add((Component)this.m_radioPerObject, gridBagConstraints4);
        buttonGroup.add(this.m_radioSingle);
        buttonGroup.add(this.m_radioPerObject);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(null, MigrationAddinArb.getString("GEN_GENERAL_OPTIONS"), 0, 0, null, null));
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(5, 15, 0, 0);
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.gridx = 0;
        this.add(jPanel3, gridBagConstraints5);
        this.m_checkComments = new JCheckBox();
        this.m_checkComments.setText(MigrationAddinArb.getString("GEN_CHECK_COMMENTS"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.anchor = 18;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.gridx = 0;
        jPanel3.add((Component)this.m_checkComments, gridBagConstraints6);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.anchor = 18;
        gridBagConstraints7.gridy = 2;
        gridBagConstraints7.gridx = 0;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.anchor = 18;
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.gridy = 3;
        gridBagConstraints8.gridx = 0;
        jPanel3.add((Component)jPanel4, gridBagConstraints8);
        this.m_checkSingleSchema = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_checkSingleSchema, (String)MigrationAddinArb.getString("GEN_LEAST_PRIVILEGE"));
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints9.weighty = 0.0;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.anchor = 18;
        gridBagConstraints9.gridy = 4;
        gridBagConstraints9.gridx = 0;
        jPanel3.add((Component)this.m_checkSingleSchema, gridBagConstraints9);
        JLabel jLabel = new JLabel();
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.gridy = 0;
        gridBagConstraints10.gridx = 2;
        jPanel4.add((Component)jLabel, gridBagConstraints10);
        ResourceUtils.resButton((AbstractButton)this.m_radioSingle, (String)MigrationAddinArb.getString("RADIO_SINGLE"));
        ResourceUtils.resButton((AbstractButton)this.m_radioPerObject, (String)MigrationAddinArb.getString("RADIO_PEROBJECT"));
        ResourceUtils.resButton((AbstractButton)this.m_checkComments, (String)MigrationAddinArb.getString("CHECK_GENERATE_COMMENTS"));
        this.m_generateDataMoveUserFlag = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_generateDataMoveUserFlag, (String)MigrationAddinArb.getString("MIGRATION_GENERATE_DATA_MOVE_USER"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.weighty = 0.0;
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridy = 5;
        gridBagConstraints11.gridx = 0;
        jPanel3.add((Component)this.m_generateDataMoveUserFlag, gridBagConstraints11);
        this.m_generateFailedObjects = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_generateFailedObjects, (String)MigrationAddinArb.getString("MIGRATION_GENERATE_FAILED_OBJECTS"));
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.weighty = 0.0;
        gridBagConstraints12.anchor = 18;
        gridBagConstraints12.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridy = 6;
        gridBagConstraints12.gridx = 0;
        jPanel3.add((Component)this.m_generateFailedObjects, gridBagConstraints12);
        this.m_generateClobToBlob = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_generateClobToBlob, (String)MigrationAddinArb.getString("MIGRATION_OFFLINE_DATA_MOVE_USE_CLOBTOBLOB"));
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.weighty = 0.0;
        gridBagConstraints13.anchor = 18;
        gridBagConstraints13.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.gridy = 7;
        gridBagConstraints13.gridx = 0;
        jPanel3.add((Component)this.m_generateClobToBlob, gridBagConstraints13);
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.weighty = 0.0;
        gridBagConstraints14.anchor = 18;
        gridBagConstraints14.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints14.fill = 2;
        gridBagConstraints14.gridy = 8;
        gridBagConstraints14.gridx = 0;
        jPanel3.add((Component)this.getGenerateEntireEmulationPkgPanel(), gridBagConstraints14);
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_IOTCombo, (String)MigrationAddinArb.getString("MIGRATION_GENERATE_IOT"));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.weighty = 0.0;
        gridBagConstraints15.anchor = 10;
        gridBagConstraints15.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.gridy = 0;
        gridBagConstraints15.gridx = 0;
        jPanel5.add((Component)jLabel2, gridBagConstraints15);
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.weighty = 0.0;
        gridBagConstraints16.anchor = 10;
        gridBagConstraints16.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints16.fill = 2;
        gridBagConstraints16.gridy = 0;
        gridBagConstraints16.gridx = 1;
        jPanel5.add((Component)this.m_IOTCombo, gridBagConstraints16);
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.weightx = 1.0;
        gridBagConstraints17.weighty = 0.0;
        gridBagConstraints17.anchor = 10;
        gridBagConstraints17.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints17.fill = 2;
        gridBagConstraints17.gridy = 0;
        gridBagConstraints17.gridx = 2;
        jPanel5.add(Box.createHorizontalGlue(), gridBagConstraints17);
        Driver driver = null;
        Throwable throwable = null;
        try {
            driver = (Driver)Class.forName("oracle.jdbc.OracleDriver").newInstance();
            if (driver != null && driver.getMajorVersion() >= 12) {
                this.m_show12 = true;
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throwable = exceptionInInitializerError;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        if (throwable != null) {
            MigrationLogUtil.logThrowable(throwable.getLocalizedMessage(), ((Object)((Object)this)).getClass().getName(), throwable);
        }
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.weightx = 1.0;
        gridBagConstraints18.weighty = this.m_show12 ? 0.0 : 1.0;
        gridBagConstraints18.anchor = 18;
        gridBagConstraints18.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints18.fill = 2;
        gridBagConstraints18.gridy = 9;
        gridBagConstraints18.gridx = 0;
        jPanel3.add((Component)jPanel5, gridBagConstraints18);
        this.m_generate12c = new JCheckBox();
        if (this.m_show12) {
            ResourceUtils.resButton((AbstractButton)this.m_generate12c, (String)MigrationAddinArb.getString("MIGRATION_USE_12C"));
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.weighty = 1.0;
            gridBagConstraints19.anchor = 18;
            gridBagConstraints19.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints19.fill = 2;
            gridBagConstraints19.gridy = 10;
            gridBagConstraints19.gridx = 0;
            jPanel3.add((Component)this.m_generate12c, gridBagConstraints19);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        MigrationConfig migrationConfig = MigrationConfig.getInstance(traversableContext.getPropertyStorage());
        super.onEntry(traversableContext);
        this.m_checkComments.setSelected(migrationConfig.getGenerateComments());
        switch (migrationConfig.getFileOutputOption()) {
            case 2: {
                this.m_radioPerObject.setSelected(true);
                break;
            }
            case 0: {
                this.m_radioSingle.setSelected(true);
            }
        }
        this.m_checkSingleSchema.setSelected(migrationConfig.getSingleSchemaLeastPrivilege());
        this.m_generateDataMoveUserFlag.setSelected(migrationConfig.getGenerateDataMoveUserFlag());
        this.m_generateFailedObjects.setSelected(migrationConfig.getGenerateFailedObjects());
        this.m_generateClobToBlob.setSelected(migrationConfig.getGenerateClobToBlob());
        this.m_IOTCombo.setSelectedIndex(migrationConfig.getIOTOption());
        this.m_genEntireEmulationPkgField.setSelected(migrationConfig.getGenerateEntireEmulationPkg());
        this.m_generate12c.setSelected(migrationConfig.getMigrate12c());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        MigrationConfig migrationConfig = MigrationConfig.getInstance(traversableContext.getPropertyStorage());
        super.onExit(traversableContext);
        migrationConfig.setGenerateComments(this.m_checkComments.isSelected());
        if (this.m_radioPerObject.isSelected()) {
            migrationConfig.setFileOutputOption(2);
        } else if (this.m_radioSingle.isSelected()) {
            migrationConfig.setFileOutputOption(0);
        }
        migrationConfig.setSingleSchemaLeastPrivilege(this.m_checkSingleSchema.isSelected());
        migrationConfig.setDataMoveUserFlag(this.m_generateDataMoveUserFlag.isSelected());
        migrationConfig.setGenerateFailedObjects(this.m_generateFailedObjects.isSelected());
        migrationConfig.setGenerateClobToBlob(this.m_generateClobToBlob.isSelected());
        migrationConfig.setIOTOption(this.m_IOTCombo.getSelectedIndex());
        migrationConfig.setGenerateEntireEmulationPkg(this.m_genEntireEmulationPkgField.isSelected());
        if (!this.m_show12) {
            this.m_generate12c.setSelected(false);
        }
        migrationConfig.setMigrate12c(this.m_generate12c.isSelected());
    }

    private JPanel getGenerateEntireEmulationPkgPanel() {
        this.m_genEntireEmulationPkgField = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_genEntireEmulationPkgField, (String)Messages.getString("ConfigurationPanelData.9"));
        return this.getPanelWithLabelAndComponent(null, this.m_genEntireEmulationPkgField);
    }

    private JPanel getPanelWithLabelAndComponent(JLabel jLabel, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        if (jLabel != null) {
            jPanel.add((Component)jLabel, null);
            jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        jPanel.add((Component)jComponent, null);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }
}

