/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.DerivativesIterator;
import oracle.dbtools.metadata.persistence.MdDerivative;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IChildNode;
import oracle.dbtools.raptor.navigator.CustomNode;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;

public abstract class DefaultContainerCustomNode
extends DefaultContainer
implements CustomNode,
IChildNode,
ViewableElement {
    protected static final Logger LOGGER = Logger.getLogger(DefaultContainerCustomNode.class.getName());
    private boolean _closing;
    protected HashMap<String, Object> _dict;
    private Element _parentElement;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public DefaultContainerCustomNode(URL uRL) {
        super(uRL);
    }

    public DefaultContainerCustomNode() {
    }

    protected abstract void queueBackgroundLoadChildrenTask();

    protected void openImpl() throws IOException {
        if (!MigrationAddin.isRepositoryOpen()) {
            return;
        }
        this._children.add(DummyElement.INSTANCE);
        UpdateMessage.fireChildAdded((Subject)this, (Element)DummyElement.INSTANCE);
        this.queueBackgroundLoadChildrenTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImpl() throws IOException {
        block6: {
            try {
                if (this._closing) break block6;
                this._closing = true;
                ArrayList arrayList = this._children;
                synchronized (arrayList) {
                    this._children.clear();
                }
            }
            finally {
                this._closing = false;
            }
        }
    }

    public abstract String getObjectName();

    public abstract String getObjectType();

    public HashMap<String, Object> getDict() {
        if (this._dict == null) {
            this._dict = (HashMap)DefaultContainerCustomNode.getBinds(null);
        }
        return this._dict;
    }

    public static Map<String, Object> getBinds(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("IDPROJECT", null);
        hashMap.put("IDCAPCONNECTION", null);
        hashMap.put("IDCAPCATALOG", null);
        hashMap.put("IDCAPSCHEMA", null);
        hashMap.put("IDCONCONNECTION", null);
        hashMap.put("IDCONCATALOG", null);
        hashMap.put("IDCONSCHEMA", null);
        hashMap.put("CAPPROJECTID", null);
        hashMap.put("CAPCONNID", null);
        hashMap.put("CAPCATALOGID", null);
        hashMap.put("CAPSCHEMAID", null);
        hashMap.put("CONPROJECTID", null);
        hashMap.put("CONCONNID", null);
        hashMap.put("CONCATALOGID", null);
        hashMap.put("CONSCHEMAID", null);
        hashMap.put("SQLDEVPREF_TARGETCONN", "super_oracle");
        if (map != null) {
            for (String string : map.keySet()) {
                hashMap.put(string, map.get(string));
            }
        }
        return hashMap;
    }

    public String getConnType() {
        return "MIGPROJ";
    }

    public String getSchemaName() {
        String string = "";
        try {
            string = Connections.getInstance().getDatabase(this.getConn()).getUserName();
        }
        catch (DBException dBException) {
            DefaultContainerCustomNode.log(dBException);
        }
        return string;
    }

    public String getObjectId() {
        return null;
    }

    public String getChildName() {
        return null;
    }

    public Object getObject() {
        return null;
    }

    public Connection getConn() {
        return MigrationAddin.getPersistenceManager().getConn();
    }

    public String getConnectionName() {
        return MigrationAddin.getRepositoryConnectionName();
    }

    public String getCatalog() {
        return null;
    }

    @Override
    public void setParentElement(Element element) {
        this._parentElement = element;
    }

    @Override
    public Element getParentElement() {
        return this._parentElement;
    }

    protected String getConvertedID(String string) {
        DBObjectId dBObjectId = this.getConvertedDBObjectID(string);
        return dBObjectId == null ? null : dBObjectId.toString();
    }

    protected DBObjectId getConvertedDBObjectID(String string) {
        DerivativesIterator derivativesIterator = new DerivativesIterator(MigrationAddin.getPersistenceManager(), null, "  derivative_reason IS NULL AND src_id = " + string);
        if (derivativesIterator.hasNext()) {
            MdDerivative mdDerivative = (MdDerivative)derivativesIterator.next();
            return mdDerivative.getDerivedId();
        }
        return null;
    }
}

