/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IPersistableObjectNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNodeChildFilter;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;

public class ConvertedModelsFolderNode
extends DefaultContainerCustomNode
implements IPersistableObjectNode {
    protected static final Logger LOGGER = Logger.getLogger(ConvertedModelsFolderNode.class.getName());
    private DBObjectId _parentId;
    private MigrationProjectNodeChildFilter _parentFilter;
    MdConnection _convertedConnection;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public ConvertedModelsFolderNode(DBObjectId dBObjectId, MigrationProjectNodeChildFilter migrationProjectNodeChildFilter) {
        this._parentId = dBObjectId;
        this._parentFilter = migrationProjectNodeChildFilter;
        String string = this._parentId.toString();
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(MigrationAddin.getRepositoryConnectionName() + "/" + string + "/" + ConvertedModelsFolderNode.class.getSimpleName())));
    }

    public MdConnection getConvertedConnection() {
        if (null == this._convertedConnection) {
            DBObjectId dBObjectId = this.getConvertedDBObjectID(this._parentId.toString());
            this._convertedConnection = MdConnection.getExistingInstance(dBObjectId);
            try {
                this._convertedConnection.retrieve(this.getPersistenceManager());
            }
            catch (Exception exception) {
                ConvertedModelsFolderNode.log(exception);
                this._convertedConnection = null;
            }
        }
        return this._convertedConnection;
    }

    public String getShortLabel() {
        return MigrationAddinArb.getString("CONVERTED_ROOT_LABEL");
    }

    public Icon getIcon() {
        return MigrationAddinArb.getIcon("MIGRATION_CONVERT_ICON");
    }

    protected MigrationConnectionNode createMdConnectionNode(String string, String string2, MdConnection mdConnection) {
        return new ConvertedConnectionNode(string, string2, mdConnection);
    }

    protected MigrationConnectionNode addChild(MdConnection mdConnection, String string) {
        Object object2;
        for (Object object2 : this._children) {
            MigrationConnectionNode migrationConnectionNode;
            if (!(object2 instanceof MigrationConnectionNode) || (migrationConnectionNode = (MigrationConnectionNode)object2).getMdConnection().getKey().getId() != mdConnection.getKey().getId()) continue;
            this.reload();
            return null;
        }
        String string2 = mdConnection.getName();
        object2 = this.createMdConnectionNode(string2, string, mdConnection);
        this._children.add(object2);
        return object2;
    }

    private void reload() {
        IconOverlayCache iconOverlayCache = IconOverlayCache.getInstance();
        iconOverlayCache.clearOverlays("MigrationNodeInfoType");
        iconOverlayCache.fireOverlaysChanged();
        UpdateMessage.fireObjectReloaded((Subject)this);
        try {
            this.close();
            this.open();
        }
        catch (IOException iOException) {
            ConvertedModelsFolderNode.log(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        boolean bl = false;
        CloseableIterator closeableIterator = null;
        try {
            closeableIterator = this.getMdConnectionsIterator();
            if (closeableIterator.hasNext()) {
                bl = true;
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
        return bl;
    }

    private PersistenceUtility getPersistenceUtility() {
        return PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager());
    }

    private CloseableIterator getMdConnectionsIterator() throws PersistenceException {
        return this.getPersistenceUtility().getConvertedModelsForCapturedModel(this._parentId);
    }

    @Override
    protected void queueBackgroundLoadChildrenTask() {
        if (this._parentFilter != null) {
            this._parentFilter.loadConvertedObjectsFolderNode(this);
        }
    }

    @Override
    public String getObjectName() {
        return "MD_CONNECTIONS";
    }

    @Override
    public String getObjectType() {
        return "CONVERTED_MODELS_FOLDER";
    }

    @Override
    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            super.getDict();
            this._dict.put("IDCONNECTION", this._parentId.toString());
            this._dict.put("CAPT_CONNECTION_OBJID", this._parentId);
            this._dict.put("IDCAPCONNECTION", this._parentId.toString());
            this._dict.put("IDCONCONNECTION", this.getConvertedID(this._parentId.toString()));
        }
        return this._dict;
    }

    @Override
    public PersistableObject getPersistableObject() {
        return this.getConvertedConnection();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }
}

