/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNodeChildFilter;
import oracle.ide.net.URLFactory;

public class CapturedObjectsFolderNode
extends DefaultContainerCustomNode {
    protected static final Logger LOGGER = Logger.getLogger(CapturedObjectsFolderNode.class.getName());
    private DBObjectId _parentId;
    private MigrationProjectNodeChildFilter _parentFilter;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public CapturedObjectsFolderNode(DBObjectId dBObjectId, MigrationProjectNodeChildFilter migrationProjectNodeChildFilter) {
        this._parentId = dBObjectId;
        this._parentFilter = migrationProjectNodeChildFilter;
        String string = this._parentId.toString();
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(MigrationAddin.getRepositoryConnectionName() + "/" + string + "/" + CapturedObjectsFolderNode.class.getSimpleName())));
    }

    public String getShortLabel() {
        return MigrationAddinArb.getString("CAPTURED_OBJECTS_ROOT_LABEL");
    }

    public Icon getIcon() {
        return CapturedConnectionNode.getCaptureIcon();
    }

    @Override
    protected void queueBackgroundLoadChildrenTask() {
        this._parentFilter.loadCapturedObjectsFolderNode(this);
    }

    @Override
    public String getObjectName() {
        return "MD_CATALOGS";
    }

    @Override
    public String getObjectType() {
        return "CAPTURED_OBJECTS_FOLDER";
    }

    @Override
    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            super.getDict();
            this._dict.put("IDCONNECTION", this._parentId.toString());
            this._dict.put("CONNECTION_OBJID", this._parentId);
            this._dict.put("IDCAPCONNECTION", this._parentId.toString());
            this._dict.put("IDCONCONNECTION", this.getConvertedID(this._parentId.toString()));
        }
        return this._dict;
    }
}

