/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.QMLauncher;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorWindow;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedObjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ConvertedModelsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IChildNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IPersistableObjectNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.db.ConnectionException;

public class MigrationProjectNavigatorContextMenu
implements ContextMenuListener {
    private static Logger LOGGER = Logger.getLogger(MigrationProjectNavigatorContextMenu.class.getName());
    private IdeAction _newProjectAction;
    private IdeAction _newCapturetAction;
    private static final int NEW_CAPTURE_CMD_ID = Ide.findOrCreateCmdID((String)"MigrationProject.Capture");
    private IdeAction _convertedPageAction;
    private IdeAction _generatePageAction;
    private IdeAction _datamovePageAction;
    private static final int CONVERTED_PAGE_CMD_ID = Ide.findOrCreateCmdID((String)"MigrationProject.ConvertedObjectsFolder.ConvertedPage");
    private static final int GENERATE_PAGE_CMD_ID = Ide.findOrCreateCmdID((String)"MigrationProject.ConvertedObjectsFolder.GeneratePage");
    private static final int DATAMOVE_PAGE_CMD_ID = Ide.findOrCreateCmdID((String)"MigrationProject.ConvertedObjectsFolder.DataMovePage");
    private IdeAction _deletePersistableObjectAction;
    private static final int NEW_DELETE_CMD_ID = Ide.findOrCreateCmdID((String)"MigrationProject.Delete");
    private IdeAction _renameProjectAction;
    private IdeAction _refreshAction;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        if (context.getView() instanceof MigrationProjectNavigatorWindow && elementArray.length == 1) {
            if (elementArray[0] instanceof MigrationProjectsFolderNode) {
                if (MigrationAddin.isRepositoryOpen()) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getNewProjectAction()));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getRefreshAction()));
                }
            } else if (elementArray[0] instanceof MigrationProjectNode) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getNewCaptureAction()));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getDeletePersistableObjectAction()));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getRenameProjectAction()));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getRefreshAction()));
            } else if (elementArray[0] instanceof ApplicationNode) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getDeletePersistableObjectAction()));
            } else if (elementArray[0] instanceof CapturedConnectionNode) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getDeletePersistableObjectAction()));
            } else if (elementArray[0] instanceof ConvertedModelsFolderNode) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getMWGeneratePageAction()));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getMWDataMovePageAction()));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getDeletePersistableObjectAction()));
            } else if (elementArray[0] instanceof CapturedObjectsFolderNode) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getMWConvertedPageAction()));
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private IdeAction getNewProjectAction() {
        if (null == this._newProjectAction) {
            Icon icon = MigrationProjectsFolderNode.getProjectIcon();
            this._newProjectAction = IdeAction.get((int)2, null, (String)MigrationProjectNavigatorArb.getString("NEW_PROJECT_CMD"), null, null, (Icon)icon, null, (boolean)true);
            this._newProjectAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (2 == n) {
                        MigrationProjectNavigatorContextMenu.this.createMigrationProject(context);
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (2 == n) {
                        ideAction.setEnabled(true);
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._newProjectAction;
    }

    private void createMigrationProject(Context context) {
        this.showMigWizardPage(context);
    }

    private IdeAction getNewCaptureAction() {
        if (null == this._newCapturetAction) {
            this._newCapturetAction = IdeAction.get((int)NEW_CAPTURE_CMD_ID, null, (String)MigrationProjectNavigatorArb.getString("NEW_CAPTURE_CMD"), null, null, (Icon)OracleIcons.getIcon((String)"new.png"), null, (boolean)true);
            this._newCapturetAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (NEW_CAPTURE_CMD_ID == n) {
                        MigrationProjectNavigatorContextMenu.this.captureSourceModel(context);
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (NEW_CAPTURE_CMD_ID == n) {
                        ideAction.setEnabled(true);
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._newCapturetAction;
    }

    private void captureSourceModel(Context context) {
        this.showMigWizardPage(context);
    }

    private IdeAction getMWConvertedPageAction() {
        if (null == this._convertedPageAction) {
            this._convertedPageAction = IdeAction.get((int)CONVERTED_PAGE_CMD_ID, null, (String)MigrationProjectNavigatorArb.getString("CONVERTED_PAGE"), null, null, null, null, (boolean)true);
            this._convertedPageAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (CONVERTED_PAGE_CMD_ID == n) {
                        MigrationProjectNavigatorContextMenu.this.showMigWizardPage(context);
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (CONVERTED_PAGE_CMD_ID == n) {
                        ideAction.setEnabled(true);
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._convertedPageAction;
    }

    private IdeAction getMWGeneratePageAction() {
        if (null == this._generatePageAction) {
            this._generatePageAction = IdeAction.get((int)GENERATE_PAGE_CMD_ID, null, (String)MigrationProjectNavigatorArb.getString("GENERATE_PAGE"), null, null, null, null, (boolean)true);
            this._generatePageAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (GENERATE_PAGE_CMD_ID == n) {
                        MigrationProjectNavigatorContextMenu.this.showMigWizardPage(context);
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (GENERATE_PAGE_CMD_ID == n) {
                        ideAction.setEnabled(true);
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._generatePageAction;
    }

    private IdeAction getMWDataMovePageAction() {
        if (null == this._datamovePageAction) {
            this._datamovePageAction = IdeAction.get((int)DATAMOVE_PAGE_CMD_ID, null, (String)MigrationProjectNavigatorArb.getString("DATAMOVE_PAGE"), null, null, null, null, (boolean)true);
            this._datamovePageAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (DATAMOVE_PAGE_CMD_ID == n) {
                        MigrationProjectNavigatorContextMenu.this.showMigWizardPage(context);
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (DATAMOVE_PAGE_CMD_ID == n) {
                        ideAction.setEnabled(true);
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._datamovePageAction;
    }

    private void showMigWizardPage(Context context) {
        QMLauncher qMLauncher = new QMLauncher();
        qMLauncher.setContext(context);
        qMLauncher.launch();
    }

    private IdeAction getDeletePersistableObjectAction() {
        if (null == this._deletePersistableObjectAction) {
            this._deletePersistableObjectAction = IdeAction.get((int)NEW_DELETE_CMD_ID, null, (String)MigrationProjectNavigatorArb.getString("DELETE_CMD"), null, null, null, null, (boolean)true);
            this._deletePersistableObjectAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    Element element;
                    int n = ideAction.getCommandId();
                    if (NEW_DELETE_CMD_ID == n && (element = context.getSelection()[0]) instanceof IPersistableObjectNode) {
                        IPersistableObjectNode iPersistableObjectNode = (IPersistableObjectNode)context.getSelection()[0];
                        String string = iPersistableObjectNode.getPersistableObject().getObjectName();
                        String string2 = MigrationProjectNavigatorArb.get("DELETE_TITLE");
                        String string3 = MigrationProjectNavigatorArb.format("DELETE_PROMPT", string);
                        if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string3, (String)string2, null, (boolean)true)) {
                            MigrationProjectNavigatorContextMenu.this.deletePersistableObject(iPersistableObjectNode);
                            if (iPersistableObjectNode instanceof MigrationProjectNode) {
                                MigrationAddin.getMigrationConfig().setStringProperty(string + "_" + "outdir", null);
                            }
                        }
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    Element element;
                    int n = ideAction.getCommandId();
                    if (NEW_DELETE_CMD_ID == n && (element = context.getSelection()[0]) instanceof IPersistableObjectNode) {
                        IPersistableObjectNode iPersistableObjectNode = (IPersistableObjectNode)element;
                        if (iPersistableObjectNode != null) {
                            ideAction.setEnabled(iPersistableObjectNode.getPersistableObject() != null);
                        } else {
                            ideAction.setEnabled(false);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._deletePersistableObjectAction;
    }

    private void deletePersistableObject(IPersistableObjectNode iPersistableObjectNode) {
        try {
            Element element;
            iPersistableObjectNode.getPersistableObject().delete(iPersistableObjectNode.getPersistenceManager());
            iPersistableObjectNode.getPersistenceManager().commit();
            if (iPersistableObjectNode instanceof IChildNode && (element = iPersistableObjectNode.getParentElement()) instanceof Subject) {
                UpdateMessage.fireChildRemoved((Subject)((Subject)element), (Element)((Element)iPersistableObjectNode));
            }
        }
        catch (Exception exception) {
            MigrationProjectNavigatorContextMenu.log(exception);
        }
    }

    private IdeAction getRenameProjectAction() {
        if (null == this._renameProjectAction) {
            this._renameProjectAction = IdeAction.get((int)14, null, (String)MigrationProjectNavigatorArb.getString("RENAME_PROJECT_CMD"), null, null, null, null, (boolean)true);
            this._renameProjectAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (14 == n) {
                        MigrationProjectNode migrationProjectNode = (MigrationProjectNode)context.getNode();
                        MigrationProjectNavigatorContextMenu.this.renameProject(migrationProjectNode);
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (14 == n) {
                        ideAction.setEnabled(true);
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._renameProjectAction;
    }

    private void renameProject(MigrationProjectNode migrationProjectNode) {
        String string = "";
        String string2 = migrationProjectNode.getMdProject().getProjectName();
        try {
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            int n = 3;
            simpleInputDialog.setButtonMask(n);
            simpleInputDialog.setInputValue(migrationProjectNode.getShortLabel());
            if (simpleInputDialog.show(MigrationProjectNavigatorArb.getString("RENAME_PROJECT_TITLE"), MigrationProjectNavigatorArb.getString("RENAME_PROJECT_PROMPT"), null)) {
                Object object;
                string = simpleInputDialog.getInputValue();
                Iterator iterator = MigrationProjectsFolderNode.getInstance().getChildren();
                while (iterator.hasNext()) {
                    object = (Element)iterator.next();
                    if (!object.getShortLabel().equals(string)) continue;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationProjectNavigatorArb.getString("FAILED_DUPLICATE_NAME_MESSAGE"), (String)MigrationProjectNavigatorArb.getString("FAILED_RENAME_TITLE"), null);
                    return;
                }
                migrationProjectNode.getMdProject().rename(string);
                migrationProjectNode.getMdProject().save(migrationProjectNode.getPersistenceManager());
                migrationProjectNode.getPersistenceManager().commit();
                migrationProjectNode.rename(string);
                object = MigrationAddin.getMigrationConfig().getStringProperty(string2 + "_" + "outdir", "UnknownDir");
                MigrationAddin.getMigrationConfig().setStringProperty(string2 + "_" + "outdir", null);
                MigrationAddin.getMigrationConfig().setStringProperty(string + "_" + "outdir", (String)object);
                MigrationAddin.getMigrationConfig().setStringProperty(string2 + "_" + "outdir", null);
            }
        }
        catch (Exception exception) {
            MigrationProjectNavigatorContextMenu.log(exception);
        }
    }

    private IdeAction getRefreshAction() {
        if (null == this._refreshAction) {
            Icon icon = OracleIcons.getIcon((String)"refresh.png");
            this._refreshAction = IdeAction.get((int)51, null, (String)MigrationProjectNavigatorArb.getString("REFRESH_CMD"), null, null, (Icon)icon, null, (boolean)true);
            this._refreshAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (51 == n) {
                        Node node = context.getNode();
                        MigrationProjectNavigatorContextMenu.this.refresh(node);
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (51 == n) {
                        ideAction.setEnabled(true);
                        return true;
                    }
                    return false;
                }
            });
        }
        return this._refreshAction;
    }

    private void refresh(final Node node) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (node != null) {
                        node.close();
                        node.open();
                        UpdateMessage.fireStructureChanged((Subject)node);
                    }
                }
                catch (IOException iOException) {
                    MigrationProjectNavigatorContextMenu.log(iOException);
                }
            }
        });
    }

    protected static class ExceptionDialogRunnable
    implements Runnable {
        Throwable m_ex;
        String m_msg;

        public ExceptionDialogRunnable(String string, Throwable throwable) {
            Throwable throwable2;
            while ((throwable instanceof ConnectionException || throwable instanceof DBException) && (throwable2 = throwable.getCause()) instanceof Exception) {
                throwable = throwable2;
            }
            this.m_ex = throwable;
            this.m_msg = string;
        }

        @Override
        public void run() {
            String string = CommonArb.getString((String)"ERROR_CONNECTING");
            Frame frame = IdeUtil.getMainWindow();
            if (this.m_ex instanceof SQLException) {
                SQLErrorDialog.showErrorDialog((String)MigrationAddin.getRepositoryConnectionName(), (Component)frame, (String)string, (SQLException)((SQLException)this.m_ex));
            } else {
                String string2 = this.m_ex instanceof ConnectionException ? MessageFormat.format(this.m_msg, this.m_ex.getLocalizedMessage()) : this.m_ex.getLocalizedMessage();
                ExceptionDialog.showExceptionDialog((Component)frame, (Throwable)this.m_ex, (String)string, (String)string2, null);
            }
        }
    }
}

