/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.util.ArrayList;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;

public final class MigrationOverlayClient {
    private static final int OVERLAY_BATCH_SIZE = 10;
    public static final String INFO_TYPE_ID = "MigrationNodeInfoType";
    private static IconOverlayTracker s_tracker;

    public static final IconOverlayTracker getTracker() {
        MigrationOverlayClient.initializeOverlays();
        return s_tracker;
    }

    private MigrationOverlayClient() {
    }

    static synchronized void initializeOverlays() {
        if (s_tracker == null) {
            s_tracker = new NodeOverlayTracker();
        }
    }

    public static final void updateOverlay(Element element) {
        IconOverlayTracker iconOverlayTracker = MigrationOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay(element);
            iconOverlayTracker.repaintOverlays();
        }
    }

    private static final class NodeOverlayTracker
    extends IconOverlayTracker {
        private static final IconOverlay NOT_CONVERTED_INFORMATION = new IconOverlay(RaptorImagesArb.getIcon((String)"NOT_CONVERTED"), null, null);

        private NodeOverlayTracker() {
            super(MigrationOverlayClient.INFO_TYPE_ID, IconOverlayCache.getInstance(), 10);
        }

        protected boolean isControlled(Element element) {
            boolean bl = false;
            if (element instanceof CapturedNode) {
                bl = true;
            }
            return bl;
        }

        protected IconOverlay[] getOverlays(Element[] elementArray) {
            ArrayList<IconOverlay> arrayList = new ArrayList<IconOverlay>(elementArray.length);
            for (int i = 0; i < elementArray.length; ++i) {
                Element element = elementArray[i];
                IconOverlay iconOverlay = null;
                if (element instanceof CapturedNode) {
                    CapturedNode capturedNode = (CapturedNode)element;
                    String string = (String)capturedNode.getProperty("NOT_CONVERTED");
                    String string2 = (String)capturedNode.getProperty("INVALID");
                    if (!Boolean.parseBoolean(string2) && Boolean.parseBoolean(string)) {
                        iconOverlay = NOT_CONVERTED_INFORMATION;
                    }
                }
                arrayList.add(iconOverlay);
            }
            return arrayList.toArray(new IconOverlay[0]);
        }
    }
}

